SphereImage = LoadImage("sphere100x100.png");
GameIcon = LoadImage("crossedSwords.png");


function SphereMenu(){

this.entries = new Array();
this.x=GetScreenWidth()/2-10;
this.y=GetScreenHeight()/2-10;
this.select=0;
this.width=Math.min(GetScreenWidth(),GetScreenHeight())/2-20;
this.height=Math.min(GetScreenWidth(),GetScreenHeight())/2-20;
this.sphere=new GlobeSphere();


this.imgMask = CreateColor(255,255,255,0);

this.windowstyle=LoadWindowStyle("verysimple.rws");
this.font = GetSystemFont();

this.tricolor=CreateColor(0,100,150,100);
this.white=CreateColor(255,255,255,255);
this.alpha=CreateColor(255,255,255,0);

this.showMenu=false;
this.linepos=0;
}

SphereMenu.prototype.paint = function (width,heigth) {
	
	if(this.sphere.frame>=this.sphere.maxFrame){
		this.sphere.degswitch=5;
		this.sphere.frame=this.sphere.maxFrame;
		this.showMenu=true;
		}
	
	if(AreKeysLeft()){
		switch(GetKey()){
			case KEY_RIGHT:{
				this.select++;
				this.linepos=0;
				break;
				}
			case KEY_LEFT:{
				if(this.select>0)this.select--;
				else this.select=this.entries.length-1
				this.linepos=0;
				break;
				}
			case KEY_ENTER:{
				if(this.showMenu){
					if(DoesGameExist(this.entries[this.select%this.entries.length].directory))
						ExecuteGame(this.entries[this.select%this.entries.length].directory);
					}
				else{
					this.sphere.degswitch=5;
					this.sphere.frame=this.sphere.maxFrame;
					this.showMenu=true;
					}
				break;
				}
			}
		}
	
	this.sphere.width=this.width;
	this.sphere.height=this.height;
	this.sphere.pos_x=this.x;
	this.sphere.pos_y=this.y;
	
	this.sphere.paint();
	var start=this.select*360/this.entries.length;
	
	
	
	

	
	
	if(this.showMenu){
		
		GradientTriangle(
			10,GetScreenHeight()-this.font.getHeight()*4-20,
			GetScreenWidth()-10,GetScreenHeight()-this.font.getHeight()*4-20,
			this.entries[(this.select)%this.entries.length].pos_x,this.entries[(this.select)%this.entries.length].pos_y,
			this.tricolor,this.tricolor,this.entries[(this.select)%this.entries.length].mask
			);
		
		GameIcon.blitMask(this.sphere.pos_x-GameIcon.width/2,this.sphere.pos_y-GameIcon.height/2,this.imgMask);
		if(this.imgMask.alpha<180)this.imgMask.alpha++;
		
		for(var i=0;i<this.entries.length;i++){
		
		this.entries[(this.select+i)%this.entries.length].gotoXYAZ(
			this.x+this.width*Math.sin((360*i/this.entries.length)*Math.PI/180),
			this.y,
			Math.max(0,Math.sin((90+360*i/this.entries.length)*Math.PI/180))*255,
			0.5+Math.sin((90+360*i/this.entries.length)*Math.PI/180)/2
			);
		this.entries[(this.select+i)%this.entries.length].paint();
		}
		
		
		this.windowstyle.drawWindow(10,GetScreenHeight()-this.font.getHeight()*4-20,GetScreenWidth()-20,this.font.getHeight()*4+10);
		
		this.font.drawText(15,GetScreenHeight()-this.font.getHeight()*4-15,this.entries[(this.select+i)%this.entries.length].name);
		GradientLine(10,GetScreenHeight()-this.font.getHeight()*3-16,10+this.linepos,GetScreenHeight()-this.font.getHeight()*3-16,this.alpha,this.white);
		
		this.font.drawText(15,GetScreenHeight()-this.font.getHeight()*3-15,"Author: "+this.entries[(this.select+i)%this.entries.length].author);
		GradientLine(10,GetScreenHeight()-this.font.getHeight()*2-16,10+this.linepos,GetScreenHeight()-this.font.getHeight()*2-16,this.alpha,this.white);
		
		this.font.drawTextBox(15,GetScreenHeight()-this.font.getHeight()*2-15,GetScreenWidth()-50,this.font.getHeight()*2,0,this.entries[(this.select+i)%this.entries.length].description);
		
		
		if(this.linepos<GetScreenWidth()-20)this.linepos++;
		}
	else{
		
		for(var i=0;i<this.entries.length;i++){
		
		this.entries[(this.select+i)%this.entries.length].gotoXYAZ(
			this.x+Math.random()*50-25,
			this.y+Math.random()*50-25,
			50,
			1
			);
		this.entries[(this.select+i)%this.entries.length].paint();
		
		}
		
		}
	
	
	
	

}

SphereMenu.prototype.addEntry = function (name,author,des,dir) {

	this.entries.push(new SphereMenuEntry());
	this.entries[this.entries.length-1].name=name;
	this.entries[this.entries.length-1].author=author;
	this.entries[this.entries.length-1].description=des;
	this.entries[this.entries.length-1].directory=dir;
	this.entries[this.entries.length-1].mask=CreateColor(Math.random()*255,Math.random()*255,255,0);

}




//--------------------------------------------------------------
function SphereMenuEntry(){
this.name = undefined;
this.author = undefined;
this.description = undefined;
this.directory = undefined;

this.pos_x=GetScreenWidth()/2;
this.pos_y=GetScreenHeight()/2;
this.alpha=0;
this.zoom=1;
this.changespeed=10;
this.go_x=0;
this.go_y=0;
this.go_alpha=0;
this.go_zoom=1;
this.mask=CreateColor(255,255,255,0);
}

SphereMenuEntry.prototype.gotoXYAZ = function (x,y,a,z){
	
	this.go_x=x;
	this.go_y=y;
	this.go_alpha=a;
	this.go_zoom=z;
	
}

SphereMenuEntry.prototype.execute = function (){
	
	ExecuteGame(this.directory);
	
}

SphereMenuEntry.prototype.paint = function (){
	this.mask.alpha=this.alpha;
	SphereImage.zoomBlitMask(this.pos_x-this.zoom*SphereImage.width/2,this.pos_y-this.zoom*SphereImage.height/2,this.zoom,this.mask);
	this.pos_x+=(this.go_x-this.pos_x)/this.changespeed;
	this.pos_y+=(this.go_y-this.pos_y)/this.changespeed;
	this.alpha+=(this.go_alpha-this.alpha)/this.changespeed;
	this.zoom+=(this.go_zoom-this.zoom)/this.changespeed;
	
}


//--------------------------------------------------------------
function GlobeSphere(){

this.width=100;
this.height=100;
this.h_rings = 5;
this.v_rings = 5;
this.frame = 0;
this.maxFrame = 100;
this.color=CreateColor(255,255,255,255);
this.pos_x=100;
this.pos_y=100;

this.degswitch=1;
}

GlobeSphere.prototype.paint = function (){
	
	for(var a=0;a<=this.frame*(180/this.maxFrame);a+=this.degswitch){
		this.color.alpha=a/180*255
		for(var v=-this.v_rings;v<=this.v_rings;v++){
			Line(
				this.pos_x-Math.sin((90+a)*Math.PI/180)*this.width*v/this.v_rings,
				this.pos_y-Math.cos((90+a)*Math.PI/180)*this.height,
				this.pos_x-Math.sin((90+a+this.degswitch)*Math.PI/180)*this.width*v/this.v_rings,
				this.pos_y-Math.cos((90+a+this.degswitch)*Math.PI/180)*this.height,
				this.color);
			Line(
				this.pos_x-Math.sin((90-a)*Math.PI/180)*this.width*v/this.v_rings,
				this.pos_y-Math.cos((90-a)*Math.PI/180)*this.height,
				this.pos_x-Math.sin((90-a+this.degswitch)*Math.PI/180)*this.width*v/this.v_rings,
				this.pos_y-Math.cos((90-a+this.degswitch)*Math.PI/180)*this.height,
				this.color);
			
			}
		
		for(var h=-this.h_rings+0.5;h<this.h_rings;h++){
			Line(
				this.pos_x-Math.sin((a)*Math.PI/180)*this.width*(Math.cos((Math.asin(h/this.h_rings)))),
				this.pos_y+(this.height/this.h_rings*h),
				this.pos_x-Math.sin((a+this.degswitch)*Math.PI/180)*this.width*(Math.cos((Math.asin(h/this.h_rings)))),
				this.pos_y+(this.height/this.h_rings*h),
				this.color);
			Line(
				this.pos_x-Math.sin((-a)*Math.PI/180)*this.width*(Math.cos((Math.asin(h/this.h_rings)))),
				this.pos_y+(this.height/this.h_rings*h),
				this.pos_x-Math.sin((-a+this.degswitch)*Math.PI/180)*this.width*(Math.cos((Math.asin(h/this.h_rings)))),
				this.pos_y+(this.height/this.h_rings*h),
				this.color);
			
			}
		
		}
	if(this.frame<this.maxFrame)this.frame++;
}