
///////////////////////////////////////////////////////////

function DoesGameExist(directory)
{
  var game_list = GetGameList();
  for (var i = 0; i < game_list.length; ++i)
    if (game_list[i].directory == directory)
      return true;
  return false;
}

///////////////////////////////////////////////////////////

function DrawClock(center_x, center_y, x_radius, y_radius, scale, date)
{
  var angle_offset = (Math.PI / 6);
  var base_angle = (-Math.PI / 2) + angle_offset;
  var theta = base_angle;

  center_x = typeof(center_x) == "number" ? center_x : GetScreenWidth() / 2;
  center_y = typeof(center_y) == "number" ? center_y : GetScreenHeight() / 2;
  x_radius = typeof(x_radius) == "number" ? x_radius : 50;
  y_radius = typeof(y_radius) == "number" ? y_radius : x_radius;
  date  = date instanceof(Date) ? date : new Date;
  scale = typeof(scale) == "Number" ? scale : 1;

  for (var i = 0; i < 12; i++) {
    var x = center_x + Math.cos(theta) * x_radius;
    var y = center_y + Math.sin(theta) * y_radius;
    Line(center_x, center_y, x, y, CreateColor(100, 200, 100));
    var str = 1 + i;
    var str_width = GetSystemFont().getStringWidth(str) * scale;
    var str_height = GetSystemFont().getStringHeight(str, str_width) * scale;
    GetSystemFont().drawZoomedText(x - (str_width / 2), y - (str_height / 2), scale, 1 + i);
    theta += angle_offset;
  }

  var sec_angle  = base_angle - angle_offset + date.getUTCSeconds() * ((2 * Math.PI) / 60);
  var min_angle  = base_angle - angle_offset + date.getUTCMinutes() * ((2 * Math.PI) / 60);
  var hour_angle = base_angle - angle_offset + Math.abs(date.getUTCHours() - 12) * ((2 * Math.PI) / 12) + (min_angle / 6);

  Line(center_x, center_y, center_x + Math.cos(hour_angle) * x_radius, center_y + Math.sin(hour_angle) * y_radius, CreateColor(255, 255, 0));
  Line(center_x, center_y, center_x + Math.cos(min_angle)  * x_radius, center_y + Math.sin(min_angle)  * y_radius, CreateColor(255, 255, 0));
  Line(center_x, center_y, center_x + Math.cos(sec_angle)  * x_radius, center_y + Math.sin(sec_angle)  * y_radius, CreateColor(255, 0, 255));

  return true;
}

///////////////////////////////////////////////////////////


function game(test)
{
  RequireScript("sphere_menu.js");
  startMenu();
}

function startMenu(){
	menu = new SphereMenu();
	gamelist = GetGameList();
	for(var i=0;i<gamelist.length;i++){
		menu.addEntry(gamelist[i].name,gamelist[i].author,gamelist[i].description,gamelist[i].directory);
		}
	while(true){
		menu.paint();
		FlipScreen();
		}
}

///////////////////////////////////////////////////////////

