/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
RequireScript("menuStrip.js");
RequireScript("session.js");
var TitleScreen = (function () {
    function TitleScreen(themeTrack) {
        this.fadeness = 1.0;
        this.image = new Texture('images/titleScreen.png');
        this.themeTrack = themeTrack;
    }
    TitleScreen.prototype.show = function () {
        if (Sphere.Game.disableTitleScreen) {
            return new Session();
        }
        this.choice = null;
        this.mode = 'transitionIn';
        if (Sphere.Game.disableAnimations) {
            this.fadeness = 0.0;
        }
        this.transition = new Scene()
            .adjustBGM(1.0)
            .pushBGM(this.themeTrack)
            .tween(this, 120, 'linear', { fadeness: 0.0 })
            .run();
        threads.join(threads.create(this));
        music.pop();
        music.adjust(1.0);
        return new Session();
    };
    TitleScreen.prototype.update = function () {
        switch (this.mode) {
            case 'idle':
                return true;
            case 'transitionIn':
                if (!this.transition.isRunning()) {
                    this.mode = 'idle';
                    this.choice = new MenuStrip("", false, ["New Game", "Continue"]).open();
                    if (Sphere.Game.disableAnimations) {
                        this.fadeness = 1.0;
                    }
                    this.transition = new Scene()
                        .fork()
                        .adjustBGM(0.0, 120)
                        .end()
                        .tween(this, 120, 'linear', { fadeness: 1.0 })
                        .run();
                    this.mode = 'transitionOut';
                }
                break;
            case 'transitionOut':
                return this.transition.isRunning();
        }
        return true;
    };
    TitleScreen.prototype.render = function () {
        prim.blit(screen, 0, 0, this.image);
        prim.fill(screen, Color.Black.fade(this.fadeness));
    };
    return TitleScreen;
}());
//# sourceMappingURL=data:application/json;base64,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