/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
var TestHarness = (function () {
    function TestHarness() {
    }
    TestHarness.initialize = function () {
        term.print("initialize Specs Engine test harness");
        term.define('harness', this, {
            'run': function (testID) {
                if (!(testID in this.tests))
                    return term.print("unknown test ID '" + testID + "'");
                this.run(testID);
            }
        });
        this.tests = {};
        this.isBattleRunning = false;
        var fileNames = from(GetFileList('~/scripts/testCases'))
            .where(function (fileName) { return fileName.endsWith('.js'); });
        try {
            for (var fileNames_1 = __values(fileNames), fileNames_1_1 = fileNames_1.next(); !fileNames_1_1.done; fileNames_1_1 = fileNames_1.next()) {
                var fileName = fileNames_1_1.value;
                term.print("load test cases from '" + fileName + "'");
                EvaluateScript("~/scripts/testCases/" + fileName);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (fileNames_1_1 && !fileNames_1_1.done && (_a = fileNames_1.return)) _a.call(fileNames_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var e_1, _a;
    };
    TestHarness.addBattle = function (testID, setupData) {
        this.tests[testID] = {
            setup: setupData,
            run: function () {
                if (TestHarness.isBattleRunning) {
                    term.print("cannot start test battle, one is ongoing");
                    return;
                }
                term.print("initiate test battle", "battleID: " + this.setup.battleID);
                var session = new Session();
                try {
                    for (var _a = __values(Game.initialParty), _b = _a.next(); !_b.done; _b = _a.next()) {
                        var characterID = _b.value;
                        session.party.remove(characterID);
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
                for (var id in this.setup.party) {
                    var memberInfo = this.setup.party[id];
                    session.party.add(id, memberInfo.level);
                    if ('weapon' in memberInfo) {
                        session.party.members[id].setWeapon(memberInfo.weapon);
                    }
                    for (var iItem = 0; iItem < memberInfo.items.length; ++iItem) {
                        session.party.members[id].items.push(new ItemUsable(memberInfo.items[iItem]));
                    }
                }
                TestHarness.isBattleRunning = true;
                new Scene()
                    .battle(this.setup.battleID, session)
                    .run(true);
                TestHarness.isBattleRunning = false;
                var e_2, _c;
            }
        };
        term.print("add battle test '" + testID + "'");
    };
    TestHarness.addTest = function (testID, func) {
        this.tests[testID] = {
            func: func,
            context: {},
            run: function () {
                this.func.call(this.context);
            }
        };
        term.define(testID, this.tests[testID], {
            'test': TestHarness.run.bind(TestHarness, testID)
        });
        term.print("add generic test '" + testID + "'");
    };
    TestHarness.run = function (testID) {
        term.print("test harness invoked", "testID: " + testID);
        this.tests[testID].run(this.tests[testID].setup, testID);
    };
    return TestHarness;
}());
//# sourceMappingURL=data:application/json;base64,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