/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
RequireScript('battleEngine/skill.js');
RequireScript('battleEngine/stat.js');
var Party = (function () {
    function Party(level) {
        if (level === void 0) { level = 1; }
        term.print("initialize party manager");
        this.defaultLevel = level;
        this.members = {};
    }
    Object.defineProperty(Party.prototype, "level", {
        get: function () {
            var _this = this;
            var memberCount = from(this.members).count();
            if (memberCount > 0) {
                var total_1 = 0;
                from(this.members).each(function (member) {
                    total_1 += _this.members[i].level;
                });
                return Math.floor(total_1 / memberCount);
            }
            else {
                return this.defaultLevel;
            }
        },
        enumerable: true,
        configurable: true
    });
    Party.prototype.add = function (characterID, level) {
        if (level === void 0) { level = this.level; }
        var newMember = new PartyMember(characterID, level);
        this.members[characterID] = newMember;
        term.print("add PC " + newMember.name + " to party");
    };
    Party.prototype.hasMember = function (characterID) {
        return characterID in this.members;
    };
    Party.prototype.remove = function (characterID) {
        from(this.members)
            .where(function (v, k) { return k === characterID; })
            .besides(function (v) { return term.print("remove PC " + v.name + " from party"); })
            .remove();
    };
    return Party;
}());
var PartyMember = (function () {
    function PartyMember(characterID, level) {
        if (level === void 0) { level = 1; }
        this.characterDef = Game.characters[characterID];
        this.characterID = characterID;
        this.isTargetScanOn = this.characterDef.autoScan;
        this.fullName = 'fullName' in Game.characters[characterID] ?
            Game.characters[characterID].fullName :
            Game.characters[characterID].name;
        this.items = [];
        this.name = Game.characters[characterID].name;
        this.skillList = [];
        this.stats = {};
        this.usableSkills = null;
        var character = Game.characters[this.characterID];
        this.weaponID = 'startingWeapon' in character ? character.startingWeapon : null;
        for (var statID in character.baseStats)
            this.stats[statID] = new Stat(character.baseStats[statID], level, true, 1.0);
        term.print("create new PC " + this.name, "lvl: " + this.level);
        for (var i = 0; i < character.skills.length; ++i)
            this.learnSkill(character.skills[i]);
    }
    Object.defineProperty(PartyMember.prototype, "level", {
        get: function () {
            var count = from(this.stats).count();
            var sum = 0;
            from(this.stats).each(function (stat) {
                sum += stat.level;
            });
            return Math.floor(sum / count);
        },
        enumerable: true,
        configurable: true
    });
    PartyMember.prototype.getInfo = function () {
        var info = {
            characterID: this.characterID,
            level: this.level,
            tier: 1
        };
        info.baseStats = {};
        info.stats = {};
        for (var statID in this.characterDef.baseStats) {
            info.baseStats[statID] = this.characterDef.baseStats[statID];
            info.stats[statID] = this.stats[statID].value;
        }
        return info;
    };
    PartyMember.prototype.getUsableSkills = function () {
        return this.usableSkills;
    };
    PartyMember.prototype.learnSkill = function (skillID) {
        var skill = new SkillUsable(skillID, 100);
        this.skillList.push(skill);
        this.refreshSkills();
        term.print("PC " + this.name + " learned skill " + skill.name);
        return skill;
    };
    PartyMember.prototype.refreshSkills = function () {
        var heldWeaponType = this.weaponID !== null ? Game.weapons[this.weaponID].type : null;
        this.usableSkills = [];
        for (var i = 0; i < this.skillList.length; ++i) {
            var skillInfo = this.skillList[i].skillInfo;
            if (skillInfo.weaponType != null && heldWeaponType != skillInfo.weaponType)
                continue;
            this.usableSkills.push(this.skillList[i]);
        }
    };
    PartyMember.prototype.setWeapon = function (weaponID) {
        this.weaponID = weaponID;
        this.refreshSkills();
    };
    return PartyMember;
}());
//# sourceMappingURL=data:application/json;base64,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