/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var DayNightEngine = require('@/scripts/inGameClock').DayNightEngine;
var Delegate = require('events').Delegate;
var _a = require('scenes'), defScenelet = _a.defScenelet, Scene = _a.Scene;
var Thread = require('threads').Thread;
global.from = require('from');
global.joy = require('joy');
global.music = require('music');
global.prim = require('prim');
global.random = require('random');
global.term = require('term');
global.threads = require('threads');
RequireScript('battleEngine/battle.js');
RequireScript('gameOverScreen.js');
RequireScript('menuStrip.js');
RequireScript('scenelets.js');
RequireScript('session.js');
RequireScript('testHarness.js');
RequireScript('titleScreen.js');
EvaluateScript('gameDef/game.js');
function game() {
    // note: a game() function is needed for now because the engine was
    //       originally written for Sphere v1.  the goal is to eventually
    //       convert the Specs Engine entirely to Sphere v2.  that effort
    //       is ongoing,  but a full conversion will take a while.
    TestHarness.initialize();
    term.define('bgm', null, {
        override: function (track) { music.override("music/" + track + ".ogg"); },
        play: function (track) { music.play("music/" + track + ".ogg"); },
        pop: function () { music.pop(); },
        push: function (track) { music.push("music/" + track + ".ogg"); },
        reset: function () { music.reset(); },
        stop: function () { music.play(null); },
        volume: function (value) { music.adjust(value / 100); },
    });
    term.define('yap', null, {
        'on': function () {
            Sphere.Game.disableTalking = false;
            term.print("oh, yappy times are here again...");
        },
        'off': function () {
            Sphere.Game.disableTalking = true;
            term.print("the yappy times are OVER!");
        },
    });
    var dayNight = new DayNightEngine();
    TestHarness.run('rsb2');
}
function clone(o, memo) {
    if (memo === void 0) { memo = []; }
    if (typeof o === 'object' && o !== null) {
        for (var i = 0; i < memo.length; ++i) {
            if (o === memo[i].original)
                return memo[i].dolly;
        }
        var dolly = Array.isArray(o) ? []
            : 'clone' in o && typeof o.clone === 'function' ? o.clone()
                : {};
        memo[memo.length] = { original: o, dolly: dolly };
        if (Array.isArray(o) || !('clone' in o) || typeof o.clone !== 'function') {
            for (var p in o)
                dolly[p] = clone(o[p], memo);
        }
        return dolly;
    }
    else {
        return o;
    }
}
function drawTextEx(font, x, y, text, color, shadowDistance, alignment) {
    if (color === void 0) { color = CreateColor(255, 255, 255); }
    if (shadowDistance === void 0) { shadowDistance = 0; }
    if (alignment === void 0) { alignment = 'left'; }
    var Align = {
        'left': function (font, x, text) { return x; },
        'center': function (font, x, text) { return x - font.getStringWidth(text) / 2; },
        'right': function (font, x, text) { return x - font.getStringWidth(text); },
    };
    x = Align[alignment](font, x, text);
    var oldColorMask = font.getColorMask();
    font.setColorMask(CreateColor(0, 0, 0, color.alpha));
    font.drawText(x + shadowDistance, y + shadowDistance, text);
    font.setColorMask(color);
    font.drawText(x, y, text);
    font.setColorMask(oldColorMask);
}
//# sourceMappingURL=data:application/json;base64,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