"use strict";
/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var prim = require("prim");
var threads_1 = require("threads");
// note: don't run more than one day/night engine at a time.  doing so
//       will cause multiple day/night masks to be applied to the screen,
//       which won't look too nice. :o)
var DayMask = Color.Transparent;
var TwilightMask = new Color(0.5, 0.125, 0.0625, 0.625);
var NightMask = new Color(0, 0, 0.125, 0.5625);
var DayNightEngine = (function (_super) {
    __extends(DayNightEngine, _super);
    function DayNightEngine() {
        var _this = _super.call(this, { priority: 1 }) || this;
        term.print("initialize day/night engine", "time: " + _this.now());
        _this.currentMask = Color.Transparent;
        _this.start();
        return _this;
    }
    DayNightEngine.prototype.now = function () {
        var realTime = new Date();
        var currentTime = 3600 * realTime.getHours() + 60 * realTime.getMinutes() + realTime.getSeconds();
        currentTime = (currentTime * 10) % 86400;
        var hour = Math.floor(currentTime / 3600);
        var minute = Math.floor((currentTime / 60) % 60);
        var second = currentTime % 60;
        return new InGameTime(hour, minute, second);
    };
    DayNightEngine.prototype.on_update = function () {
        var now = this.now();
        if (now.hour < 5 || now.hour >= 19) {
            this.currentMask = NightMask;
        }
        else if (now.hour >= 7 && now.hour < 17) {
            this.currentMask = DayMask;
        }
        else if (now.hour >= 5 && now.hour < 6) {
            var fromMask = NightMask;
            var toMask = TwilightMask;
            var alpha = now.minute / 60;
            this.currentMask = Color.mix(toMask, fromMask, alpha, 1.0 - alpha);
        }
        else if (now.hour >= 6 && now.hour < 7) {
            var fromMask = TwilightMask;
            var toMask = DayMask;
            var alpha = now.minute / 60;
            this.currentMask = Color.mix(toMask, fromMask, alpha, 1.0 - alpha);
        }
        else if (now.hour >= 17 && now.hour < 18) {
            var fromMask = DayMask;
            var toMask = TwilightMask;
            var alpha = now.minute / 60;
            this.currentMask = Color.mix(toMask, fromMask, alpha, 1.0 - alpha);
        }
        else if (now.hour >= 18 && now.hour < 19) {
            var fromMask = TwilightMask;
            var toMask = NightMask;
            var alpha = now.minute / 60;
            this.currentMask = Color.mix(toMask, fromMask, alpha, 1.0 - alpha);
        }
    };
    DayNightEngine.prototype.on_render = function () {
        prim.fill(screen, this.currentMask);
    };
    return DayNightEngine;
}(threads_1.Thread));
exports.DayNightEngine = DayNightEngine;
var InGameTime = (function () {
    function InGameTime(hour, minute, second) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }
    InGameTime.prototype.toString = function () {
        var hourText = ("0" + this.hour).slice(-2);
        var minuteText = ("0" + this.minute).slice(-2);
        var secondText = ("0" + this.second).slice(-2);
        return hourText + ":" + minuteText;
    };
    return InGameTime;
}());
exports.InGameTime = InGameTime;
//# sourceMappingURL=data:application/json;base64,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