/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
RequireScript("menuStrip.js");
var GameOverAction = {
    Retry: 1,
    Quit: 2,
};
var GameOverScreen = (function () {
    function GameOverScreen() {
        this.fadeness = 1.0;
        this.image = new Texture('images/gameOverScreen.png');
        this.transition = null;
    }
    GameOverScreen.prototype.show = function () {
        this.action = null;
        this.mode = 'transitionIn';
        if (Sphere.Game.disableAnimations) {
            this.fadeness = 0.0;
        }
        music.play(null);
        this.transition = new Scene()
            .pushBGM('gameOver')
            .adjustBGM(1.0)
            .tween(this, 300, 'linear', { fadeness: 0.0 })
            .run();
        return threads.create(this);
    };
    GameOverScreen.prototype.update = function () {
        switch (this.mode) {
            case 'idle':
                return true;
            case 'transitionIn':
                if (!this.transition.isRunning()) {
                    this.mode = 'idle';
                    var menu = new MenuStrip("Game Over", false);
                    menu.addItem("Retry Battle", GameOverAction.Retry);
                    menu.addItem("Give Up", GameOverAction.Quit);
                    this.action = menu.open();
                    if (Sphere.Game.disableAnimations) {
                        this.fadeness = 1.0;
                    }
                    this.transition = new Scene()
                        .fork()
                        .adjustBGM(0.0, 120)
                        .end()
                        .tween(this, 120, 'linear', { fadeness: 1.0 })
                        .run();
                    this.mode = 'transitionOut';
                }
                break;
            case 'transitionOut':
                if (!this.transition.isRunning()) {
                    music.pop();
                    music.adjust(1.0);
                }
                return this.transition.isRunning();
        }
        return true;
    };
    GameOverScreen.prototype.render = function () {
        prim.blit(screen, 0, 0, this.image);
        prim.fill(screen, Color.Black.fade(this.fadeness));
    };
    return GameOverScreen;
}());
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2FtZU92ZXJTY3JlZW4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJnYW1lT3ZlclNjcmVlbi5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7O0lBR0k7QUFFSixhQUFhLENBQUMsY0FBYyxDQUFDLENBQUM7QUFFOUIsSUFBTSxjQUFjLEdBQ3BCO0lBQ0MsS0FBSyxFQUFFLENBQUM7SUFDUixJQUFJLEVBQUcsQ0FBQztDQUNSLENBQUM7QUFFRjtJQUVDO1FBRUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxHQUFHLENBQUM7UUFDcEIsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLE9BQU8sQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ3RELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO0lBQ3hCLENBQUM7SUFFRCw2QkFBSSxHQUFKO1FBRUMsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUM7UUFDbkIsSUFBSSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUM7UUFDM0IsRUFBRSxDQUFDLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7WUFDbkMsSUFBSSxDQUFDLFFBQVEsR0FBRyxHQUFHLENBQUM7UUFDckIsQ0FBQztRQUNELEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDakIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLEtBQUssRUFBRTthQUMzQixPQUFPLENBQUMsVUFBVSxDQUFDO2FBQ25CLFNBQVMsQ0FBQyxHQUFHLENBQUM7YUFDZCxLQUFLLENBQUMsSUFBSSxFQUFFLEdBQUcsRUFBRSxRQUFRLEVBQUUsRUFBRSxRQUFRLEVBQUUsR0FBRyxFQUFFLENBQUM7YUFDN0MsR0FBRyxFQUFFLENBQUM7UUFDUixNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUM3QixDQUFDO0lBRUQsK0JBQU0sR0FBTjtRQUVDLE1BQU0sQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO1lBQ25CLEtBQUssTUFBTTtnQkFDVixNQUFNLENBQUMsSUFBSSxDQUFDO1lBQ2IsS0FBSyxjQUFjO2dCQUNsQixFQUFFLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsU0FBUyxFQUFFLENBQUMsQ0FBQyxDQUFDO29CQUNsQyxJQUFJLENBQUMsSUFBSSxHQUFHLE1BQU0sQ0FBQztvQkFDbkIsSUFBSSxJQUFJLEdBQUcsSUFBSSxTQUFTLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQyxDQUFDO29CQUM3QyxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ25ELElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxFQUFFLGNBQWMsQ0FBQyxJQUFJLENBQUMsQ0FBQztvQkFDN0MsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7b0JBQzFCLEVBQUUsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO3dCQUNuQyxJQUFJLENBQUMsUUFBUSxHQUFHLEdBQUcsQ0FBQztvQkFDckIsQ0FBQztvQkFDRCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksS0FBSyxFQUFFO3lCQUMzQixJQUFJLEVBQUU7eUJBQ0wsU0FBUyxDQUFDLEdBQUcsRUFBRSxHQUFHLENBQUM7eUJBQ3BCLEdBQUcsRUFBRTt5QkFDTCxLQUFLLENBQUMsSUFBSSxFQUFFLEdBQUcsRUFBRSxRQUFRLEVBQUUsRUFBRSxRQUFRLEVBQUUsR0FBRyxFQUFFLENBQUM7eUJBQzdDLEdBQUcsRUFBRSxDQUFDO29CQUNSLElBQUksQ0FBQyxJQUFJLEdBQUcsZUFBZSxDQUFDO2dCQUM3QixDQUFDO2dCQUNELEtBQUssQ0FBQztZQUNQLEtBQUssZUFBZTtnQkFDbkIsRUFBRSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUMsQ0FBQztvQkFDbEMsS0FBSyxDQUFDLEdBQUcsRUFBRSxDQUFDO29CQUNaLEtBQUssQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQ25CLENBQUM7Z0JBQ0QsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsU0FBUyxFQUFFLENBQUM7UUFDckMsQ0FBQztRQUNELE1BQU0sQ0FBQyxJQUFJLENBQUM7SUFDYixDQUFDO0lBRUQsK0JBQU0sR0FBTjtRQUVDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLEtBQUssQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRixxQkFBQztBQUFELENBQUMsQUFoRUQsSUFnRUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKioqXG4gKiBTcGVjcyBFbmdpbmUgdjY6IFNwZWN0YWNsZXMgU2FnYSBHYW1lIEVuZ2luZVxuICAqICAgICAgICAgICBDb3B5cmlnaHQgKGMpIDIwMTcgUG93ZXItQ29tbWFuZFxuKioqL1xuXG5SZXF1aXJlU2NyaXB0KFwibWVudVN0cmlwLmpzXCIpO1xuXG5jb25zdCBHYW1lT3ZlckFjdGlvbiA9XG57XG5cdFJldHJ5OiAxLFxuXHRRdWl0OiAgMixcbn07XG5cbmNsYXNzIEdhbWVPdmVyU2NyZWVuXG57XG5cdGNvbnN0cnVjdG9yKClcblx0e1xuXHRcdHRoaXMuZmFkZW5lc3MgPSAxLjA7XG5cdFx0dGhpcy5pbWFnZSA9IG5ldyBUZXh0dXJlKCdpbWFnZXMvZ2FtZU92ZXJTY3JlZW4ucG5nJyk7XG5cdFx0dGhpcy50cmFuc2l0aW9uID0gbnVsbDtcblx0fVxuXG5cdHNob3coKVxuXHR7XG5cdFx0dGhpcy5hY3Rpb24gPSBudWxsO1xuXHRcdHRoaXMubW9kZSA9ICd0cmFuc2l0aW9uSW4nO1xuXHRcdGlmIChTcGhlcmUuR2FtZS5kaXNhYmxlQW5pbWF0aW9ucykge1xuXHRcdFx0dGhpcy5mYWRlbmVzcyA9IDAuMDtcblx0XHR9XG5cdFx0bXVzaWMucGxheShudWxsKTtcblx0XHR0aGlzLnRyYW5zaXRpb24gPSBuZXcgU2NlbmUoKVxuXHRcdFx0LnB1c2hCR00oJ2dhbWVPdmVyJylcblx0XHRcdC5hZGp1c3RCR00oMS4wKVxuXHRcdFx0LnR3ZWVuKHRoaXMsIDMwMCwgJ2xpbmVhcicsIHsgZmFkZW5lc3M6IDAuMCB9KVxuXHRcdFx0LnJ1bigpO1xuXHRcdHJldHVybiB0aHJlYWRzLmNyZWF0ZSh0aGlzKTtcblx0fVxuXG5cdHVwZGF0ZSgpXG5cdHtcblx0XHRzd2l0Y2ggKHRoaXMubW9kZSkge1xuXHRcdFx0Y2FzZSAnaWRsZSc6XG5cdFx0XHRcdHJldHVybiB0cnVlO1xuXHRcdFx0Y2FzZSAndHJhbnNpdGlvbkluJzpcblx0XHRcdFx0aWYgKCF0aGlzLnRyYW5zaXRpb24uaXNSdW5uaW5nKCkpIHtcblx0XHRcdFx0XHR0aGlzLm1vZGUgPSAnaWRsZSc7XG5cdFx0XHRcdFx0dmFyIG1lbnUgPSBuZXcgTWVudVN0cmlwKFwiR2FtZSBPdmVyXCIsIGZhbHNlKTtcblx0XHRcdFx0XHRtZW51LmFkZEl0ZW0oXCJSZXRyeSBCYXR0bGVcIiwgR2FtZU92ZXJBY3Rpb24uUmV0cnkpO1xuXHRcdFx0XHRcdG1lbnUuYWRkSXRlbShcIkdpdmUgVXBcIiwgR2FtZU92ZXJBY3Rpb24uUXVpdCk7XG5cdFx0XHRcdFx0dGhpcy5hY3Rpb24gPSBtZW51Lm9wZW4oKTtcblx0XHRcdFx0XHRpZiAoU3BoZXJlLkdhbWUuZGlzYWJsZUFuaW1hdGlvbnMpIHtcblx0XHRcdFx0XHRcdHRoaXMuZmFkZW5lc3MgPSAxLjA7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHRcdHRoaXMudHJhbnNpdGlvbiA9IG5ldyBTY2VuZSgpXG5cdFx0XHRcdFx0XHQuZm9yaygpXG5cdFx0XHRcdFx0XHRcdC5hZGp1c3RCR00oMC4wLCAxMjApXG5cdFx0XHRcdFx0XHQuZW5kKClcblx0XHRcdFx0XHRcdC50d2Vlbih0aGlzLCAxMjAsICdsaW5lYXInLCB7IGZhZGVuZXNzOiAxLjAgfSlcblx0XHRcdFx0XHRcdC5ydW4oKTtcblx0XHRcdFx0XHR0aGlzLm1vZGUgPSAndHJhbnNpdGlvbk91dCc7XG5cdFx0XHRcdH1cblx0XHRcdFx0YnJlYWs7XG5cdFx0XHRjYXNlICd0cmFuc2l0aW9uT3V0Jzpcblx0XHRcdFx0aWYgKCF0aGlzLnRyYW5zaXRpb24uaXNSdW5uaW5nKCkpIHtcblx0XHRcdFx0XHRtdXNpYy5wb3AoKTtcblx0XHRcdFx0XHRtdXNpYy5hZGp1c3QoMS4wKTtcblx0XHRcdFx0fVxuXHRcdFx0XHRyZXR1cm4gdGhpcy50cmFuc2l0aW9uLmlzUnVubmluZygpO1xuXHRcdH1cblx0XHRyZXR1cm4gdHJ1ZTtcblx0fVxuXG5cdHJlbmRlcigpXG5cdHtcblx0XHRwcmltLmJsaXQoc2NyZWVuLCAwLCAwLCB0aGlzLmltYWdlKTtcblx0XHRwcmltLmZpbGwoc2NyZWVuLCBDb2xvci5CbGFjay5mYWRlKHRoaXMuZmFkZW5lc3MpKTtcblx0fVxufVxuIl19