/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2015 Power-Command
***/
Game.skillCategories =
    {
        attack: "Attack",
        magic: "Magic",
        heal: "Heal",
        strategy: "Strategy"
    };
Game.skills =
    {
        // Sword/slashing techniques
        berserkCharge: {
            name: "Berserk Charge",
            category: 'attack',
            weaponType: 'sword',
            targetType: 'allEnemies',
            actions: [
                {
                    announceAs: "Charging Up...",
                    rank: 2,
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'user',
                            type: 'addStatus',
                            status: 'offGuard'
                        }
                    ]
                },
                {
                    announceAs: "Berserk Charge",
                    rank: 4,
                    accuracyType: 'sword',
                    isMelee: false,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'sword',
                            power: 100
                        }
                    ]
                }
            ]
        },
        chargeSlash: {
            name: "Charge Slash",
            category: 'attack',
            weaponType: 'sword',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Charge",
                    rank: 1,
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'user',
                            type: 'addStatus',
                            status: 'offGuard'
                        }
                    ]
                },
                {
                    announceAs: "Sword Slash",
                    rank: 2,
                    accuracyType: 'sword',
                    isMelee: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'sword',
                            power: 22.5,
                        }
                    ]
                }
            ]
        },
        desperationSlash: {
            name: "Desperation Slash",
            category: 'attack',
            weaponType: 'sword',
            targetType: 'single',
            actions: [
                {
                    announceAs: "#9's Desperation...",
                    rank: 3,
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'user',
                            type: 'addStatus',
                            status: 'offGuard'
                        }
                    ]
                },
                {
                    announceAs: "Desperation Slash",
                    rank: 5,
                    accuracyType: 'sword',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'instaKill',
                            damageType: 'sword'
                        }
                    ]
                }
            ]
        },
        quickstrike: {
            name: "Quickstrike",
            category: 'attack',
            weaponType: 'sword',
            targetType: 'single',
            chargeable: false,
            actions: [
                {
                    announceAs: "Quickstrike",
                    isMelee: true,
                    preserveGuard: true,
                    rank: 1,
                    accuracyType: 'sword',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'sword',
                            power: 10,
                        }
                    ]
                }
            ]
        },
        swordSlash: {
            name: "Sword Slash",
            category: 'attack',
            weaponType: 'sword',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Sword Slash",
                    rank: 2,
                    accuracyType: 'sword',
                    isMelee: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'sword',
                            power: 15,
                        }
                    ]
                }
            ]
        },
        // Bow & Arrow techniques
        archery: {
            name: "Archery",
            category: 'attack',
            weaponType: 'bow',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Archery",
                    rank: 2,
                    accuracyType: 'bow',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'bow',
                            power: 15,
                        }
                    ],
                }
            ]
        },
        chillShot: {
            name: "Chill Shot",
            category: 'attack',
            weaponType: 'bow',
            targetType: 'single',
            baseMPCost: 10,
            actions: [
                {
                    announceAs: "Chill Shot",
                    rank: 2,
                    accuracyType: 'bow',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'bow',
                            power: 10,
                            element: 'ice',
                            addStatus: 'frostbite',
                            statusChance: 25
                        }
                    ],
                }
            ]
        },
        flareShot: {
            name: "Flare Shot",
            category: 'attack',
            weaponType: 'bow',
            targetType: 'single',
            baseMPCost: 10,
            actions: [
                {
                    announceAs: "Flare Shot",
                    rank: 2,
                    accuracyType: 'bow',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'bow',
                            power: 10,
                            element: 'fire',
                            addStatus: 'ignite',
                            statusChance: 25
                        }
                    ],
                }
            ]
        },
        joltShot: {
            name: "Jolt Shot",
            category: 'attack',
            weaponType: 'bow',
            targetType: 'single',
            baseMPCost: 10,
            actions: [
                {
                    announceAs: "Jolt Shot",
                    rank: 2,
                    accuracyType: 'bow',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'bow',
                            power: 10,
                            element: 'lightning',
                            addStatus: 'zombie',
                            statusChance: 25
                        }
                    ],
                }
            ]
        },
        seismicShot: {
            name: "Seismic Shot",
            category: 'attack',
            weaponType: 'bow',
            targetType: 'single',
            baseMPCost: 10,
            actions: [
                {
                    announceAs: "Seismic Shot",
                    rank: 2,
                    accuracyType: 'bow',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'bow',
                            power: 10,
                            element: 'earth',
                            addStatus: 'disarray',
                            statusChance: 25
                        }
                    ],
                }
            ]
        },
        tripleShot: {
            name: "Triple Shot",
            category: 'attack',
            weaponType: 'bow',
            targetType: 'allEnemies',
            actions: [
                {
                    announceAs: "Triple Shot",
                    animation: 'tripleShot',
                    rank: 2,
                    accuracyType: 'bow',
                    accuracyRate: 1 / Game.bonusMultiplier,
                    effects: [
                        {
                            targetHint: 'random',
                            type: 'damage',
                            damageType: 'bow',
                            power: 25
                        },
                        {
                            targetHint: 'random',
                            type: 'damage',
                            damageType: 'bow',
                            power: 25
                        },
                        {
                            targetHint: 'random',
                            type: 'damage',
                            damageType: 'bow',
                            power: 25
                        },
                    ],
                }
            ]
        },
        // Gun techniques
        potshot: {
            name: "Potshot",
            category: 'attack',
            weaponType: 'gun',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Potshot",
                    rank: 2,
                    accuracyType: 'gun',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'gun',
                            power: 15
                        }
                    ]
                }
            ]
        },
        sharpshooter: {
            name: "Sharpshooter",
            category: 'attack',
            weaponType: 'gun',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Lining Up...",
                    rank: 2,
                    effects: [
                        {
                            targetHint: 'user',
                            type: 'addStatus',
                            status: 'sniper'
                        }
                    ]
                },
                {
                    announceAs: "Sharpshooter",
                    rank: 3,
                    accuracyRate: Infinity,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'gun',
                            power: 80
                        }
                    ]
                }
            ]
        },
        shootout: {
            name: "Shootout",
            category: 'attack',
            weaponType: 'gun',
            targetType: 'allEnemies',
            actions: [
                {
                    announceAs: "Shootout",
                    rank: 3,
                    accuracyType: 'gun',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'gun',
                            power: 15
                        }
                    ]
                }
            ]
        },
        // Shuriken (throwing star) techniques
        starToss: {
            name: "Star Toss",
            category: 'attack',
            weaponType: 'shuriken',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Star Toss",
                    rank: 1,
                    accuracyType: 'shuriken',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'shuriken',
                            power: 15
                        }
                    ]
                }
            ]
        },
        starVolley: {
            name: "Star Volley",
            category: 'attack',
            weaponType: 'shuriken',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Star Volley",
                    rank: 2,
                    accuracyType: 'shuriken',
                    hits: 5,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'shuriken',
                            power: 10
                        }
                    ]
                }
            ]
        },
        // standard Tier 1 magic
        chill: {
            name: "Chill",
            category: 'magic',
            targetType: 'single',
            baseMPCost: 5,
            actions: [
                {
                    announceAs: "Chill",
                    rank: 2,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 20,
                            element: 'ice',
                        }
                    ],
                }
            ]
        },
        flare: {
            name: "Flare",
            category: 'magic',
            targetType: 'single',
            baseMPCost: 5,
            actions: [
                {
                    announceAs: "Flare",
                    rank: 2,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 20,
                            element: 'fire',
                        }
                    ],
                }
            ]
        },
        lightning: {
            name: "Lightning",
            category: 'magic',
            targetType: 'single',
            baseMPCost: 5,
            actions: [
                {
                    announceAs: "Lightning",
                    rank: 2,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 20,
                            element: 'lightning',
                        }
                    ],
                }
            ]
        },
        quake: {
            name: "Quake",
            category: 'magic',
            targetType: 'single',
            baseMPCost: 5,
            actions: [
                {
                    announceAs: "Quake",
                    rank: 2,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 20,
                            element: 'earth',
                        }
                    ]
                }
            ]
        },
        // special Tier 1 magic (inflict status)
        frostbite: {
            name: "Frostbite",
            category: 'strategy',
            targetType: 'single',
            baseMPCost: 10,
            actions: [
                {
                    announceAs: "Frostbite",
                    rank: 2,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 5,
                            element: 'ice',
                            addStatus: 'frostbite',
                            statusChance: 100,
                        }
                    ],
                }
            ]
        },
        ignite: {
            name: "Ignite",
            category: 'strategy',
            targetType: 'single',
            baseMPCost: 10,
            actions: [
                {
                    announceAs: "Ignite",
                    rank: 2,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 5,
                            element: 'fire',
                            addStatus: 'ignite',
                            statusChance: 100,
                        }
                    ],
                }
            ]
        },
        bolt: {
            name: "Bolt",
            category: 'strategy',
            targetType: 'single',
            baseMPCost: 10,
            actions: [
                {
                    announceAs: "Bolt",
                    rank: 2,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 5,
                            element: 'lightning',
                            addStatus: 'zombie',
                            statusChance: 100,
                        }
                    ],
                }
            ]
        },
        tremor: {
            name: "Tremor",
            category: 'strategy',
            targetType: 'single',
            baseMPCost: 10,
            actions: [
                {
                    announceAs: "Tremor",
                    rank: 2,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 5,
                            element: 'earth',
                            addStatus: 'disarray',
                            statusChance: 100,
                        }
                    ]
                }
            ]
        },
        // second-tier magic
        electrocute: {
            name: "Electrocute",
            category: 'magic',
            targetType: 'single',
            baseMPCost: 15,
            actions: [
                {
                    announceAs: "Electrocute",
                    rank: 3,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 40,
                            element: 'lightning',
                            addStatus: 'zombie',
                            statusChance: 0,
                        }
                    ]
                }
            ]
        },
        hellfire: {
            name: "Hellfire",
            category: 'magic',
            targetType: 'single',
            baseMPCost: 15,
            actions: [
                {
                    announceAs: "Hellfire",
                    rank: 3,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 40,
                            element: 'fire',
                            addStatus: 'ignite',
                            statusChance: 0,
                        }
                    ]
                }
            ]
        },
        upheaval: {
            name: "Upheaval",
            category: 'magic',
            targetType: 'single',
            baseMPCost: 15,
            actions: [
                {
                    announceAs: "Upheaval",
                    rank: 3,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 40,
                            element: 'earth',
                            addStatus: 'disarray',
                            statusChance: 0,
                        }
                    ]
                }
            ]
        },
        windchill: {
            name: "Windchill",
            category: 'magic',
            targetType: 'single',
            baseMPCost: 15,
            actions: [
                {
                    announceAs: "Windchill",
                    rank: 3,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 40,
                            element: 'ice',
                            addStatus: 'frostbite',
                            statusChance: 0,
                        }
                    ]
                }
            ]
        },
        // Rank 4 magic - damage + field condition, group-cast
        inferno: {
            name: "Inferno",
            category: 'magic',
            targetType: 'allEnemies',
            baseMPCost: 35,
            actions: [
                {
                    announceAs: "Inferno",
                    rank: 4,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 40,
                            element: 'fire'
                        },
                        {
                            targetHint: 'selected',
                            type: 'addCondition',
                            condition: 'inferno'
                        }
                    ]
                }
            ]
        },
        subzero: {
            name: "Subzero",
            category: 'magic',
            targetType: 'allEnemies',
            baseMPCost: 35,
            actions: [
                {
                    announceAs: "Subzero",
                    rank: 4,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 40,
                            element: 'ice'
                        },
                        {
                            targetHint: 'selected',
                            type: 'addCondition',
                            condition: 'subzero'
                        }
                    ]
                }
            ]
        },
        tenPointFive: {
            name: "10.5",
            category: 'magic',
            targetType: 'allEnemies',
            baseMPCost: 35,
            actions: [
                {
                    announceAs: "10.5",
                    rank: 4,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 40,
                            element: 'earth'
                        },
                        {
                            targetHint: 'selected',
                            type: 'addCondition',
                            condition: 'generalDisarray'
                        }
                    ]
                }
            ]
        },
        discharge: {
            name: "Discharge",
            category: 'magic',
            targetType: 'allEnemies',
            baseMPCost: 35,
            actions: [
                {
                    announceAs: "Discharge",
                    rank: 4,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 40,
                            element: 'lightning'
                        },
                        {
                            targetHint: 'selected',
                            type: 'addCondition',
                            condition: 'thunderstorm'
                        }
                    ]
                }
            ]
        },
        // Omni - Rank 4 non-elemental magic
        omni: {
            name: "Omni",
            category: 'magic',
            targetType: 'single',
            baseMPCost: 100,
            actions: [
                {
                    announceAs: "Omni",
                    rank: 4,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 100,
                            element: 'omni'
                        },
                        {
                            targetHint: 'user',
                            type: 'addStatus',
                            status: 'offGuard'
                        },
                    ]
                }
            ]
        },
        // Curative/healing magicks
        convalesce: {
            name: "Convalesce",
            category: 'heal',
            targetType: 'ally',
            baseMPCost: 75,
            allowAsCounter: false,
            actions: [
                {
                    announceAs: "Convalesce",
                    rank: 3,
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'addStatus',
                            status: 'reGen',
                            element: 'cure'
                        }
                    ]
                }
            ]
        },
        dispel: {
            name: "Dispel",
            category: 'heal',
            targetType: 'single',
            baseMPCost: 25,
            allowAsCounter: false,
            actions: [
                {
                    announceAs: "Dispel",
                    rank: 3,
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'liftStatusTags',
                            tags: ['buff']
                        }
                    ]
                }
            ]
        },
        heal: {
            name: "Heal",
            category: 'heal',
            targetType: 'ally',
            baseMPCost: 25,
            actions: [
                {
                    announceAs: "Heal",
                    rank: 2,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'heal',
                            power: 25,
                            element: 'cure',
                            addStatus: 'reGen',
                            statusChance: 0,
                        }
                    ]
                }
            ]
        },
        lazarus: {
            name: "Lazarus",
            category: 'heal',
            targetType: 'ally',
            allowDeadTarget: true,
            baseMPCost: 150,
            actions: [
                {
                    announceAs: "Lazarus",
                    rank: 3,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'revive',
                            healToFull: false,
                            element: 'cure'
                        }
                    ]
                }
            ]
        },
        purify: {
            name: "Purify",
            category: 'heal',
            targetType: 'single',
            baseMPCost: 50,
            actions: [
                {
                    announceAs: "Purify",
                    rank: 3,
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'liftStatusTags',
                            tags: ['undead']
                        }
                    ]
                }
            ]
        },
        rejuvenate: {
            name: "Rejuvenate",
            category: 'heal',
            targetType: 'ally',
            baseMPCost: 50,
            actions: [
                {
                    announceAs: "Rejuvenate",
                    rank: 3,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'heal',
                            power: 60,
                            element: 'cure',
                        }
                    ]
                }
            ]
        },
        renewal: {
            name: "Renewal",
            category: 'heal',
            targetType: 'allAllies',
            baseMPCost: 85,
            actions: [
                {
                    announceAs: "Renewal",
                    rank: 4,
                    accuracyType: 'magic',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'heal',
                            power: 100,
                            element: 'cure'
                        },
                        {
                            targetHint: 'selected',
                            type: 'addCondition',
                            condition: 'healingAura'
                        }
                    ]
                }
            ]
        },
        // Status-inducing techniques
        crackdown: {
            name: "Crackdown",
            category: 'strategy',
            targetType: 'single',
            baseMPCost: 50,
            allowAsCounter: false,
            chargeable: false,
            actions: [
                {
                    announceAs: "Crackdown",
                    rank: 3,
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'addStatus',
                            status: 'crackdown'
                        }
                    ]
                }
            ]
        },
        curse: {
            name: "Curse",
            category: 'strategy',
            targetType: 'single',
            baseMPCost: 70,
            allowAsCounter: false,
            chargeable: false,
            actions: [
                {
                    announceAs: "Curse",
                    rank: 3,
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'addStatus',
                            status: 'curse'
                        }
                    ]
                }
            ]
        },
        necromancy: {
            name: "Necromancy",
            category: 'strategy',
            targetType: 'single',
            baseMPCost: 10,
            allowAsCounter: false,
            chargeable: false,
            actions: [
                {
                    announceAs: "Necromancy",
                    rank: 3,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'addStatus',
                            status: 'zombie'
                        }
                    ]
                }
            ]
        },
        protectiveAura: {
            name: "Protective Aura",
            category: 'strategy',
            targetType: 'allAllies',
            baseMPCost: 40,
            allowAsCounter: false,
            chargeable: false,
            actions: [
                {
                    announceAs: "Protective Aura",
                    rank: 3,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'addStatus',
                            status: 'protect'
                        }
                    ]
                }
            ]
        },
        // Physical-contact techniques
        fatSlam: {
            name: "Fat Slam",
            category: 'attack',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Fat Slam",
                    rank: 3,
                    accuracyType: 'physical',
                    isMelee: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'physical',
                            power: 75,
                            element: 'fat'
                        }
                    ]
                }
            ]
        },
        fatseat: {
            name: "Fatseat",
            category: 'attack',
            targetType: 'allEnemies',
            actions: [
                {
                    announceAs: "Fatseat",
                    rank: 2,
                    accuracyType: 'physical',
                    isMelee: false,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'physical',
                            power: 25,
                            element: 'fat'
                        }
                    ]
                }
            ]
        },
        munch: {
            name: "Munch",
            category: 'attack',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Munch",
                    animation: 'munch',
                    rank: 5,
                    accuracyType: 'devour',
                    isMelee: true,
                    effects: [
                        {
                            element: 'fat',
                            targetHint: 'selected',
                            type: 'devour',
                            successRate: 1.0
                        }
                    ]
                }
            ]
        },
        // Enemy techniques
        bite: {
            name: "Bite",
            category: 'attack',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Bite",
                    rank: 2,
                    accuracyType: 'physical',
                    isMelee: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'physical',
                            power: 30
                        }
                    ]
                }
            ]
        },
        deathBite: {
            name: "Death Bite",
            category: 'attack',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Death Bite",
                    rank: 1,
                    accuracyType: 'physical',
                    isMelee: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'physical',
                            power: 10,
                            addStatus: 'zombie'
                        }
                    ]
                }
            ]
        },
        delusion: {
            name: "Delusion",
            category: 'strategy',
            targetType: 'single',
            allowAsCounter: false,
            actions: [
                {
                    announceAs: "Delusion",
                    rank: 3,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'addStatus',
                            status: 'delusion'
                        }
                    ]
                }
            ]
        },
        flameBreath: {
            name: "Flame Breath",
            category: 'magic',
            targetType: 'allEnemies',
            baseMPCost: 25,
            actions: [
                {
                    announceAs: "Flame Breath",
                    rank: 2,
                    accuracyType: 'breath',
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'breath',
                            power: 20,
                            element: 'fire',
                            addStatus: 'ignite'
                        }
                    ]
                }
            ]
        },
        flareUp: {
            name: "Flare Up",
            category: 'attack',
            targetType: 'allEnemies',
            actions: [
                {
                    announceAs: "Flare Up",
                    rank: 2,
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'user',
                            type: 'addStatus',
                            status: 'ignite',
                        },
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'magic',
                            power: 15,
                            element: 'fire',
                        },
                    ],
                }
            ],
        },
        rearingKick: {
            name: "Rearing Kick",
            category: 'attack',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Rear Up",
                    rank: 1,
                    preserveGuard: true,
                    effects: [
                        {
                            targetHint: 'user',
                            type: 'addStatus',
                            status: 'rearing'
                        }
                    ]
                },
                {
                    announceAs: "Rearing Kick",
                    rank: 2,
                    accuracyType: 'physical',
                    isMelee: true,
                    effects: [
                        {
                            targetHint: 'user',
                            type: 'liftStatus',
                            statuses: ['ghost']
                        },
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'physical',
                            power: 25
                        }
                    ]
                }
            ]
        },
        spectralReversion: {
            name: "Spectral Reversion",
            category: 'strategy',
            targetType: 'ally',
            baseMPCost: 50,
            actions: [
                {
                    announceAs: "Spectral Reversion",
                    rank: 3,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'addStatus',
                            status: 'ghost',
                        },
                    ],
                },
            ],
        },
        spectralKick: {
            name: "Spectral Kick",
            category: 'attack',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Spectral Kick",
                    rank: 3,
                    accuracyType: 'physical',
                    isMelee: true,
                    effects: [
                        {
                            targetHint: 'user',
                            type: 'liftStatus',
                            status: 'ghost'
                        },
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'physical',
                            power: 50
                        }
                    ]
                }
            ]
        },
        tackle: {
            name: "Tackle",
            category: 'attack',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Tackle",
                    rank: 2,
                    accuracyType: 'physical',
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'damage',
                            damageType: 'physical',
                            power: 15
                        }
                    ]
                }
            ]
        },
        trample: {
            name: "Trample",
            category: 'physical',
            targetType: 'single',
            actions: [
                {
                    announceAs: "Trample",
                    rank: 2,
                    accuracyType: 'physical',
                    isMelee: true,
                    effects: [
                        {
                            targetHint: 'selected',
                            type: 'instaKill',
                            damageType: 'physical'
                        }
                    ]
                }
            ]
        }
    };
//# sourceMappingURL=data:application/json;base64,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