/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
Game.elements =
    {
        fire: { name: "Fire", color: CreateColor(255, 0, 0, 255) },
        ice: { name: "Ice", color: CreateColor(0, 128, 255, 255) },
        lightning: { name: "Lightning", color: CreateColor(255, 192, 0, 255) },
        earth: { name: "Earth", color: CreateColor(255, 128, 0, 255) },
        cure: { name: "Cure", color: CreateColor(64, 255, 128, 255) },
        omni: { name: "Omni", color: CreateColor(255, 255, 255, 255) },
        fat: { name: "Fat", color: CreateColor(255, 0, 255, 255) },
        zombie: { name: "Zombie", color: CreateColor(128, 255, 0, 255) }
    };
Game.moveEffects =
    {
        addCondition: function (actor, targets, effect) {
            actor.battle.addCondition(effect.condition);
        },
        addStatus: function (actor, targets, effect) {
            from(targets).each(function (unit) {
                unit.addStatus(effect.status);
            });
        },
        damage: function (actor, targets, effect) {
            var userInfo = actor.battlerInfo;
            for (var i = 0; i < targets.length; ++i) {
                var targetInfo = targets[i].battlerInfo;
                var damageTags = [effect.damageType];
                if ('element' in effect) {
                    damageTags.push(effect.element);
                }
                var damage = Math.max(Math.round(Game.math.damage[effect.damageType](userInfo, targetInfo, effect.power)), 1);
                var tolerance = Math.round(damage / 10);
                targets[i].takeDamage(Math.max(random.uniform(damage, tolerance), 1), damageTags);
                var recoilFunction = effect.damageType + "Recoil";
                if (recoilFunction in Game.math.damage) {
                    var recoil = Math.round(Game.math.damage[recoilFunction](userInfo, targetInfo, effect.power));
                    var tolerance = Math.round(recoil / 10);
                    actor.takeDamage(Math.max(random.uniform(recoil, tolerance), 1), ['recoil'], true);
                }
                if ('addStatus' in effect) {
                    var statusChance = 'statusChance' in effect ? effect.statusChance / 100 : 1.0;
                    if (random.chance(statusChance)) {
                        targets[i].addStatus(effect.addStatus, true);
                    }
                }
            }
        },
        devour: function (actor, targets, effect) {
            for (var i = 0; i < targets.length; ++i) {
                if (!targets[i].isPartyMember()) {
                    var munchData = targets[i].enemyInfo.munchData;
                    var experience = Game.math.experience.skill(munchData.skill, actor.battlerInfo, [targets[i].battlerInfo]);
                    actor.growSkill(munchData.skill, experience);
                }
                term.print(targets[i].fullName + " got eaten by " + actor.name);
                targets[i].die();
            }
            actor.heal(actor.maxHP - actor.hp, [], true);
        },
        fullRecover: function (actor, targets, effect) {
            from(targets)
                .where(function (it) { return !it.hasStatus('zombie'); })
                .each(function (unit) {
                unit.heal(unit.maxHP - unit.hp, ['cure']);
            });
        },
        heal: function (actor, targets, effect) {
            var userInfo = actor.battlerInfo;
            for (var i = 0; i < targets.length; ++i) {
                var targetInfo = targets[i].battlerInfo;
                var healing = Math.max(Math.round(Game.math.healing(userInfo, targetInfo, effect.power)), 1);
                var tolerance = Math.round(healing / 10);
                targets[i].heal(Math.max(random.uniform(healing, tolerance), 1), ['cure']);
                if ('addStatus' in effect) {
                    var statusChance = 'statusChance' in effect ? effect.statusChance / 100 : 1.0;
                    if (random.chance(statusChance)) {
                        targets[i].addStatus(effect.addStatus);
                    }
                }
            }
        },
        instaKill: function (actor, targets, effect) {
            for (var i = 0; i < targets.length; ++i) {
                targets[i].takeDamage(Math.max(targets[i].hp, 1), [effect.damageType, 'deathblow']);
            }
        },
        liftStatus: function (actor, targets, effect) {
            for (var i = 0; i < targets.length; ++i) {
                for (var i2 = 0; i2 < effect.statuses.length; ++i2) {
                    targets[i].liftStatus(effect.statuses[i2]);
                }
            }
        },
        liftStatusTags: function (actor, targets, effect) {
            from(targets).each(function (unit) {
                unit.liftStatusTags(effect.tags);
            });
        },
        recoverHP: function (actor, targets, effect) {
            for (var i = 0; i < targets.length; ++i) {
                var unitInfo = targets[i].battlerInfo;
                var cap = Game.math.hp(unitInfo, unitInfo.level, 1);
                targets[i].heal(effect.strength * cap / 100, ['cure']);
            }
        },
        recoverMP: function (actor, targets, effect) {
            from(targets).each(function (unit) {
                var amount = Math.round(Game.math.mp.capacity(unit.battlerInfo));
                unit.restoreMP(amount);
            });
        },
        revive: function (actor, targets, effect) {
            from(targets).each(function (unit) {
                unit.resurrect(effect.healToFull);
            });
        }
    };
//# sourceMappingURL=data:application/json;base64,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