/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
Game.math =
    {
        accuracy: {
            bow: function (userInfo, targetInfo) {
                return userInfo.stats.foc / targetInfo.stats.agi;
            },
            breath: function (userInfo, targetInfo) {
                return 1.0;
            },
            devour: function (userInfo, targetInfo) {
                return (100 - targetInfo.health * targetInfo.tier) / 100
                    * userInfo.stats.agi / targetInfo.stats.agi;
            },
            gun: function (userInfo, targetInfo) {
                return 1.0;
            },
            magic: function (userInfo, targetInfo) {
                return 1.0;
            },
            physical: function (userInfo, targetInfo) {
                return 1.0;
            },
            shuriken: function (userInfo, targetInfo) {
                return 1.0;
            },
            sword: function (userInfo, targetInfo) {
                return userInfo.stats.agi * 1.5 / targetInfo.stats.agi;
            }
        },
        damage: {
            calculate: function (power, level, targetTier, attack, defense) {
                return power * Math.pow(level, 0.5) * attack / defense;
            },
            bow: function (userInfo, targetInfo, power) {
                return Game.math.damage.calculate(power, userInfo.level, targetInfo.tier, userInfo.stats.str, Game.math.statValue(0, targetInfo.level));
            },
            breath: function (userInfo, targetInfo, power) {
                return Game.math.damage.calculate(power, userInfo.level, targetInfo.tier, Math.round((userInfo.stats.vit * 2 + userInfo.stats.mag) / 3), targetInfo.stats.vit);
            },
            magic: function (userInfo, targetInfo, power) {
                return Game.math.damage.calculate(power, userInfo.level, targetInfo.tier, Math.round((userInfo.stats.mag * 2 + userInfo.stats.foc) / 3), targetInfo.stats.foc);
            },
            gun: function (userInfo, targetInfo, power) {
                return Game.math.damage.calculate(power, userInfo.level, targetInfo.tier, Game.math.statValue(100, userInfo.level), targetInfo.stats.def);
            },
            physical: function (userInfo, targetInfo, power) {
                return Game.math.damage.calculate(power, userInfo.level, targetInfo.tier, userInfo.stats.str, Math.round((targetInfo.stats.def * 2 + targetInfo.stats.str) / 3));
            },
            physicalRecoil: function (userInfo, targetInfo, power) {
                return Game.math.damage.calculate(power / 2, userInfo.level, targetInfo.tier, targetInfo.stats.str, userInfo.stats.str);
            },
            shuriken: function (userInfo, targetInfo, power) {
                return Game.math.damage.calculate(power, userInfo.level, targetInfo.tier, userInfo.stats.foc, targetInfo.stats.def);
            },
            sword: function (userInfo, targetInfo, power) {
                return Game.math.damage.calculate(power, userInfo.level, targetInfo.tier, userInfo.stats.str, targetInfo.stats.def);
            }
        },
        experience: {
            skill: function (skillInfo, userInfo, targetsInfo) {
                var levelSum = 0;
                var statSum = 0;
                for (var i = 0; i < targetsInfo.length; ++i) {
                    levelSum += targetsInfo[i].level;
                    statSum += targetsInfo[i].baseStatAverage;
                }
                var levelAverage = Math.round(levelSum / targetsInfo.length);
                var statAverage = Math.round(statSum / targetsInfo.length);
                return levelAverage * statAverage;
            },
            stat: function (statID, enemyUnitInfo) {
                return enemyUnitInfo.level * enemyUnitInfo.baseStats[statID];
            }
        },
        guardStance: {
            damageTaken: function (baseDamage, tags) {
                if (from(tags).anyIs('deathblow')) {
                    return baseDamage - 1;
                }
                else if (from(tags).anyIn(['bow', 'omni', 'special', 'zombie'])) {
                    return baseDamage;
                }
                else {
                    return baseDamage / 2;
                }
            }
        },
        healing: function (userInfo, targetInfo, power) {
            return Game.math.damage.calculate(power, userInfo.level, targetInfo.tier, Math.round((userInfo.stats.mag * 2 + userInfo.stats.foc) / 3), Game.math.statValue(0, targetInfo.level));
        },
        hp: function (unitInfo, level, tier) {
            var statAverage = Math.round((unitInfo.baseStats.vit * 10
                + unitInfo.baseStats.str
                + unitInfo.baseStats.def
                + unitInfo.baseStats.foc
                + unitInfo.baseStats.mag
                + unitInfo.baseStats.agi) / 15);
            statAverage = Game.math.statValue(statAverage, level);
            return 25 * Math.pow(tier, 2) * statAverage;
        },
        mp: {
            capacity: function (unitInfo) {
                var statAverage = Math.round((unitInfo.baseStats.mag * 10
                    + unitInfo.baseStats.vit
                    + unitInfo.baseStats.str
                    + unitInfo.baseStats.def
                    + unitInfo.baseStats.foc
                    + unitInfo.baseStats.agi) / 15);
                statAverage = Game.math.statValue(statAverage, unitInfo.level);
                return 10 * unitInfo.tier * statAverage;
            },
            usage: function (skill, level, userInfo) {
                var baseCost = 'baseMPCost' in skill ? skill.baseMPCost : 0;
                return baseCost * Math.pow(level, 0.5) * userInfo.baseStats.mag / 100;
            }
        },
        retreatChance: function (enemyUnitsInfo) {
            return 1.0;
        },
        skillRank: function (skill) {
            var rankTotal = 0;
            for (var i = 0; i < skill.actions.length; ++i) {
                rankTotal += skill.actions[i].rank;
            }
            return rankTotal;
        },
        statValue: function (baseStat, level) {
            return Math.round((50 + 0.5 * baseStat) * (10 + level) / 110);
        },
        timeUntilNextTurn: function (unitInfo, rank) {
            return rank * 10000 / unitInfo.stats.agi;
        }
    };
//# sourceMappingURL=data:application/json;base64,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