/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
Game.maps =
    {
        main: {
            onEnter: function () {
                new Scene()
                    .fadeTo(Color.Black, 0)
                    .playBGM('BruceTellsHisStory')
                    .pause(60)
                    .talk("Bruce", false, 1.0, 2.0, "I tried so hard to make him understand, but for so long, he refused to listen...", "So many times I said to myself, \"Bruce, why do you even bother?\" Anything to prove to myself that I wasn't the one at fault--that the reason he wouldn't listen was because of his own denial, not because I was pushing far too hard...", "I was so intent on convincing him of Spellbinder's dishonesty that I didn't step back to take a look at the bigger picture. I refused to. And in the end, I wasn't the one hurt by it.")
                    .pause(60)
                    .talk("Bruce", false, 1.0, 2.0, "He was.")
                    .pause(120)
                    .talk("Bruce", false, 1.0, 2.0, "The thing that amazes me most, though...")
                    .pause(60)
                    .adjustBGM(0.0, 300)
                    .pause(60)
                    .changeMap('Testville.rmp')
                    .fork()
                    .playBGM('ThePromise')
                    .adjustBGM(1.0, 120)
                    .end()
                    .fadeTo(Color.Transparent, 120)
                    .resync()
                    .talk("Robert", true, 2.0, Infinity, "There must be some other way, Amanda...")
                    .pause(120) // TODO: Amanda looks into the distance
                    .talk("Amanda", true, 2.0, Infinity, "Circumstances beyond my control long ago forced my hand. Frankly, I don't see that I have any other choice. At times I wonder if I ever did...")
                    .talk("Robert", true, 2.0, Infinity, "I get it, I really do. It's just... well, I just wish you didn't have to leave Lucida to do it.")
                    .pause(60) // TODO: Amanda faces house
                    .talk("Amanda", true, 2.0, Infinity, "It's not as though I can't imagine how you feel. We all have a lot of memories here... it's home. But I can't just linger about the manor pretending the prophecy will magically go away.", "Robert, if I don't do something...")
                    .pause(60) // TODO: Amanda uses Flare to set the house ablaze
                    .talk("Amanda", true, 2.0, Infinity, "Lucida would be destroyed.")
                    .pause(30) // TODO: Robert steps away from burning house
                    .talk("Robert", true, 2.0, Infinity, "So this is it? You're just going to walk out on all of us?")
                    .talk("Amanda", true, 2.0, Infinity, "Remember something for me, Robert. Not once have I ever left you to fend for yourself. No matter what's happened, I've always come back. Always.")
                    .talk("Robert", true, 2.0, Infinity, "Maybe it's nothing. I don't know. But I can't help thinking I'll never see you again. I'm worried, Amanda. More worried than I've ever been about anything. What if something happens? What if you don't return?")
                    .talk("Amanda", true, 2.0, Infinity, "I'll come back, Robert. I promise.")
                    .fork()
                    .pause(30)
                    .pause(60) // TODO: Amanda walks away
                    .end()
                    .pause(120)
                    .fork()
                    .adjustBGM(0.0, 300)
                    .end()
                    .fadeTo(Color.Black, 120)
                    .talk("Bruce", false, 1.0, 2.0, "...is that it all began with a promise.")
                    .pause(120)
                    .changeMap('Portentia.rmp')
                    .resetBGM()
                    .adjustBGM(1.0)
                    .fadeTo(Color.Transparent, 300)
                    .pause(300)
                    .pause(120) // TODO: Scott walks out of his house
                    .talk("Scott", true, 2.0, Infinity, "The lights are out...", "What's going on?")
                    .run(true);
            }
        },
        testville: {
            bgm: 'LucidaByNight',
            encounterRate: 0.005,
            battleBGM: 'CreepFight',
            canvasColor: CreateColor(0, 96, 0, 255),
            onEnter: function () {
            }
        }
    };
//# sourceMappingURL=data:application/json;base64,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