/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
Game.items =
    {
        alcohol: {
            name: "Alcohol",
            tags: ['drink', 'curative'],
            uses: 1,
            action: {
                announceAs: "Alcohol",
                effects: [
                    {
                        targetHint: 'selected',
                        type: 'fullRecover'
                    },
                    {
                        targetHint: 'selected',
                        type: 'recoverMP',
                        strength: 100
                    },
                    {
                        targetHint: 'selected',
                        type: 'addStatus',
                        status: 'drunk'
                    }
                ]
            }
        },
        holyWater: {
            name: "Holy Water",
            tags: ['remedy'],
            uses: 5,
            action: {
                announceAs: "Holy Water",
                effects: [
                    {
                        targetHint: 'selected',
                        type: 'liftStatusTags',
                        tags: ['undead']
                    }
                ]
            }
        },
        lazarusPotion: {
            name: "Lazarus Potion",
            tags: ['drink', 'curative'],
            allowDeadTarget: true,
            uses: 3,
            action: {
                announceAs: "Lazarus Potion",
                effects: [
                    {
                        targetHint: 'selected',
                        type: 'revive',
                        healToFull: true
                    }
                ]
            }
        },
        tonic: {
            name: "Tonic",
            tags: ['drink', 'curative'],
            uses: 10,
            action: {
                announceAs: "Tonic",
                effects: [
                    {
                        targetHint: 'selected',
                        type: 'recoverHP',
                        strength: 33,
                    }
                ]
            }
        },
        powerTonic: {
            name: "Power Tonic",
            tags: ['drink', 'curative'],
            uses: 5,
            action: {
                announceAs: "Power Tonic",
                effects: [
                    {
                        targetHint: 'selected',
                        type: 'recoverHP',
                        strength: 66,
                    }
                ]
            }
        },
        fullTonic: {
            name: "Full Tonic",
            tags: ['drink', 'curative'],
            uses: 2,
            action: {
                announceAs: "Full Tonic",
                effects: [
                    {
                        targetHint: 'selected',
                        type: 'recoverHP',
                        strength: 100,
                    },
                    {
                        targetHint: 'selected',
                        type: 'addStatus',
                        status: 'reGen',
                    },
                ]
            }
        },
        redBull: {
            name: "Red Bull",
            tags: ['drink', 'curative'],
            uses: 3,
            action: {
                announceAs: "Red Bull",
                effects: [
                    {
                        targetHint: 'selected',
                        type: 'recoverMP',
                        strength: 100
                    }
                ]
            }
        },
        vaccine: {
            name: "Vaccine",
            tags: ['drink'],
            uses: 1,
            action: {
                announceAs: "Vaccine",
                effects: [
                    {
                        targetHint: 'selected',
                        type: 'liftStatusTags',
                        tags: ['ailment']
                    },
                    {
                        targetHint: 'selected',
                        type: 'addStatus',
                        status: 'immune'
                    }
                ]
            }
        }
    };
//# sourceMappingURL=data:application/json;base64,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