/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
Game.initialParty =
    [
        'scott'
    ];
Game.characters =
    {
        // Amanda Spellbinder
        amanda: {
            name: "Amanda",
            fullName: "Amanda Spellbinder",
            baseStats: {
                vit: 65,
                str: 60,
                def: 75,
                foc: 80,
                mag: 100,
                agi: 50
            },
            skills: [
                'flare',
                'chill',
                'lightning',
                'quake',
                'hellfire',
                'inferno',
                'omni',
                'dispel',
                'protectiveAura',
                'curse'
            ]
        },
        // Bruce Arsen
        bruce: {
            name: "Bruce",
            fullName: "Bruce Arsen",
            baseStats: {
                vit: 65,
                str: 100,
                def: 50,
                foc: 80,
                mag: 30,
                agi: 55
            },
            autoScan: true,
            startingWeapon: 'arsenRifle',
            skills: [
                'potshot',
                'shootout',
                'sharpshooter',
                'flare',
                'chill',
                'lightning',
                'quake',
                'heal',
                'rejuvenate',
                'renewal',
                'protectiveAura'
            ]
        },
        // Elysia Ilapse
        elysia: {
            name: "Elysia",
            fullName: "Elysia Ilapse",
            baseStats: {
                vit: 40,
                str: 50,
                def: 50,
                foc: 90,
                mag: 65,
                agi: 100
            },
            startingWeapon: 'fireAndIce',
            skills: [
                'archery',
                'tripleShot',
                'flareShot',
                'chillShot',
                'joltShot',
                'seismicShot',
                'flare',
                'chill',
                'lightning',
                'quake',
                'hellfire',
                'windchill',
                'electrocute',
                'upheaval',
                'inferno',
                'subzero',
                'discharge',
                'tenPointFive',
                'heal',
                'rejuvenate',
                'renewal',
                'lazarus'
            ]
        },
        // Justin Ilapse
        // Father of Elysia Ilapse. Justin has good intentions, but doesn't always know the right
        // way to act on them and often makes poor decisions as a result. In battle, he plays the
        // dual role of healer and saboteur, removing the enemy's enhancements while piling on
        // status afflictions of his own.
        justin: {
            name: "Justin",
            fullName: "Justin Ilapse",
            baseStats: {
                vit: 50,
                str: 35,
                def: 60,
                foc: 75,
                mag: 100,
                agi: 60
            },
            autoScan: true,
            skills: [
                'flare',
                'chill',
                'lightning',
                'quake',
                'heal',
                'electrocute',
                'upheaval',
                'rejuvenate',
                'dispel',
                'necromancy',
                'crackdown',
                'curse'
            ]
        },
        // Katelyn Hippofoood
        // Doesn't actually exist.
        katelyn: {
            name: "Katelyn",
            fullName: "Katelyn Hippofoood",
            baseStats: {
                vit: 40,
                str: 5,
                def: 30,
                foc: 80,
                mag: 65,
                agi: 50
            },
            skills: [
                'potshot',
                'inferno',
                'subzero',
                'discharge',
                'tenPointFive',
                'omni'
            ],
        },
        // Lauren Adora
        // Scott's love interest and one of the three initial party members. She tends keep to herself
        // (except where maggie is involved) and often keeps quiet about things she really should
        // divulge in a misguided attempt to prevent what she sees as unnecessary turmoil. In battle,
        // she assails her enemies with throwing stars.
        lauren: {
            name: "Lauren",
            fullName: "Lauren Tusgafas",
            baseStats: {
                vit: 30,
                str: 60,
                def: 40,
                foc: 90,
                mag: 70,
                agi: 70
            },
            skills: [
                'starToss',
                'starVolley',
                'flare',
                'chill',
                'lightning',
                'quake'
            ],
        },
        // maggie
        // An overweight hunger-pig and former leader of the neo-Hippos. She has renounced her role in the
        // group due to disagreement over their methods, particularly her sister's stubborn persecution of
        // Elysia Ilapse. In battle, maggie can devour her enemies, often gaining new skills in the process.
        maggie: {
            name: "maggie",
            baseStats: {
                vit: 100,
                str: 90,
                def: 85,
                foc: 65,
                mag: 30,
                agi: 35
            },
            skills: [
                'munch',
                'fatseat',
                'fatSlam',
                'flameBreath'
            ]
        },
        // Robert Spellbinder
        robert: {
            name: "Robert",
            fullName: "Robert Spellbinder",
            baseStats: {
                vit: 75,
                str: 75,
                def: 75,
                foc: 75,
                mag: 75,
                agi: 75
            },
            startingWeapon: 'rsbSword',
            skills: [
                'swordSlash',
                'quickstrike',
                'flare',
                'chill',
                'lightning',
                'quake',
                'hellfire',
                'windchill',
                'electrocute',
                'upheaval',
                'omni',
                'protectiveAura',
                'necromancy',
                'crackdown'
            ]
        },
        // Scott Starcross
        // The protagonist of the Spectacles Saga. Always tries to do what's right, but is
        // naive to a fault. In battle, Scott wields a balanced set of sword techniques,
        // elemental and status-inducing magicks.
        scott: {
            name: "Scott",
            fullName: "Scott Starcross",
            baseStats: {
                vit: 70,
                str: 70,
                def: 70,
                foc: 70,
                mag: 70,
                agi: 70
            },
            startingWeapon: 'heirloom',
            skills: [
                'swordSlash',
                'quickstrike',
                'flare',
                'chill',
                'lightning',
                'quake',
                'hellfire',
                'windchill',
                'electrocute',
                'upheaval',
                'ignite',
                'frostbite',
                'bolt',
                'tremor',
                'necromancy',
                'crackdown'
            ]
        }
    };
//# sourceMappingURL=data:application/json;base64,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