/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
RequireScript('battleAI/headlessHorse.js');
RequireScript('battleAI/robertII.js');
// boss and miniboss battle definitions.
// random field battles don't have specific definitions as the
// game composes them on-the-fly, ex nihilo.
Game.battles =
    {
        headlessHorse: {
            title: "Headless Horse",
            bgm: 'manorBoss',
            battleLevel: 8,
            enemies: [
                'headlessHorse',
            ],
            onStart: function () {
                var theHorse = this.findUnit('headlessHorse');
                theHorse.addStatus('zombie');
                new Scene()
                    .talk("the pig", true, 1.0, Infinity, "Keep your guard up if you want to beat this thing.  It won't hesitate to roast " +
                    "you alive--and then I'd have to eat you!")
                    .talk("Lauren", true, 1.0, Infinity, "Yeah, because I totally always wanted to get " +
                    "burnt to a crisp by a fire-breathing horse BEFORE GETTING EATEN BY A FREAKING PIG.  " +
                    "Awesome.")
                    .talk("Scott", true, 1.0, Infinity, "Stupid pig")
                    .run(true);
                var themaggie = this.findUnit('maggie');
                themaggie.turnIntoAHippo();
            }
        },
        rsbFinal: {
            title: "Robert Spellbinder",
            isFinalBattle: true,
            bgm: 'thePromise',
            battleLevel: 50,
            enemies: [
                'robert2'
            ],
            onStart: function () {
                var scottUnit = this.findUnit('scott');
                if (scottUnit !== null) {
                    scottUnit.addStatus('specsAura');
                    new Scene()
                        .talk("Robert", true, 1.0, Infinity, "Bruce's death changed nothing.  Hell, if anything, it's made you far too reckless. Look around, "
                        + "Scott!  Where are your friends?  Did they abandon you in your most desperate hour, or are you truly "
                        + "so brazen as to face me alone?")
                        .talk("Scott", true, 1.0, Infinity, "I owe Bruce my life, Robert! To let his story end here... that's something I won't allow.  "
                        + "Not now. Not when I know just what my world would become if I did!")
                        .pause(120)
                        .talk("Robert", true, 1.0, Infinity, "What makes you so sure you have a choice?")
                        .run(true);
                }
            },
        },
    };
// enemy definitions.
// this includes boss and miniboss battlers as well as
// field enemies.
Game.enemies =
    {
        headlessHorse: {
            name: "H. Horse",
            fullName: "Headless Horse",
            aiClass: HeadlessHorseAI,
            hasLifeBar: true,
            tier: 3,
            turnRatio: 3.0,
            baseStats: {
                vit: 50,
                str: 10,
                def: 55,
                foc: 65,
                mag: 30,
                agi: 80,
            },
            damageModifiers: {
                'fire': -1.0,
                'earth': Game.bonusMultiplier,
            },
            immunities: [],
            munchData: {
                skill: 'flameBreath',
            },
        },
        robert2: {
            name: "Robert",
            fullName: "Robert Spellbinder",
            aiClass: Robert2AI,
            hasLifeBar: true,
            tier: 3,
            turnRatio: 1.0,
            baseStats: {
                vit: 75,
                str: 75,
                def: 75,
                foc: 75,
                mag: 75,
                agi: 75,
            },
            immunities: [],
            weapon: 'rsbSword',
            munchData: {
                skill: 'omni',
            },
            items: [
                'tonic',
                'powerTonic',
                'redBull',
                'holyWater',
                'vaccine',
                'alcohol',
            ],
        },
    };
//# sourceMappingURL=data:application/json;base64,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