/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
Game.animations =
    {
        // Move Animations
        // Each animation is implemented by a function which is called with
        // 'this' bound to a context object used to manage the timing of attack
        // effects, and the following arguments:
        //     user:     The BattleUnit performing the move.
        //     targets:  The BattleUnit(s) targeted by the move.
        //     doesMiss: true if the move was determined to have missed, false otherwise.
        munch: function (user, targets, doesMiss) {
            new Scene()
                .playSound('sounds/Munch.wav')
                .run();
            this.nextEffect();
        },
        tripleShot: function (user, targets, doesMiss) {
            for (var i = 0; i < 3; ++i) {
                this.nextEffect();
            }
        },
    };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYW5pbWF0aW9ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFuaW1hdGlvbnMuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7OztJQUdJO0FBRUosSUFBSSxDQUFDLFVBQVU7SUFDZjtRQUNDLGtCQUFrQjtRQUNsQixtRUFBbUU7UUFDbkUsdUVBQXVFO1FBQ3ZFLHdDQUF3QztRQUN4QyxvREFBb0Q7UUFDcEQsd0RBQXdEO1FBQ3hELGlGQUFpRjtRQUVqRixLQUFLLEVBQUUsVUFBUyxJQUFJLEVBQUUsT0FBTyxFQUFFLFFBQVE7WUFDdEMsSUFBSSxLQUFLLEVBQUU7aUJBQ1QsU0FBUyxDQUFDLGtCQUFrQixDQUFDO2lCQUM3QixHQUFHLEVBQUUsQ0FBQztZQUNSLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQztRQUNuQixDQUFDO1FBRUQsVUFBVSxFQUFFLFVBQVMsSUFBSSxFQUFFLE9BQU8sRUFBRSxRQUFRO1lBQzNDLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxFQUFFLENBQUM7Z0JBQzVCLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQztZQUNuQixDQUFDO1FBQ0YsQ0FBQztLQUNELENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKioqXG4gKiBTcGVjcyBFbmdpbmUgdjY6IFNwZWN0YWNsZXMgU2FnYSBHYW1lIEVuZ2luZVxuICAqICAgICAgICAgICBDb3B5cmlnaHQgKGMpIDIwMTcgUG93ZXItQ29tbWFuZFxuKioqL1xuXG5HYW1lLmFuaW1hdGlvbnMgPVxue1xuXHQvLyBNb3ZlIEFuaW1hdGlvbnNcblx0Ly8gRWFjaCBhbmltYXRpb24gaXMgaW1wbGVtZW50ZWQgYnkgYSBmdW5jdGlvbiB3aGljaCBpcyBjYWxsZWQgd2l0aFxuXHQvLyAndGhpcycgYm91bmQgdG8gYSBjb250ZXh0IG9iamVjdCB1c2VkIHRvIG1hbmFnZSB0aGUgdGltaW5nIG9mIGF0dGFja1xuXHQvLyBlZmZlY3RzLCBhbmQgdGhlIGZvbGxvd2luZyBhcmd1bWVudHM6XG5cdC8vICAgICB1c2VyOiAgICAgVGhlIEJhdHRsZVVuaXQgcGVyZm9ybWluZyB0aGUgbW92ZS5cblx0Ly8gICAgIHRhcmdldHM6ICBUaGUgQmF0dGxlVW5pdChzKSB0YXJnZXRlZCBieSB0aGUgbW92ZS5cblx0Ly8gICAgIGRvZXNNaXNzOiB0cnVlIGlmIHRoZSBtb3ZlIHdhcyBkZXRlcm1pbmVkIHRvIGhhdmUgbWlzc2VkLCBmYWxzZSBvdGhlcndpc2UuXG5cblx0bXVuY2g6IGZ1bmN0aW9uKHVzZXIsIHRhcmdldHMsIGRvZXNNaXNzKSB7XG5cdFx0bmV3IFNjZW5lKClcblx0XHRcdC5wbGF5U291bmQoJ3NvdW5kcy9NdW5jaC53YXYnKVxuXHRcdFx0LnJ1bigpO1xuXHRcdHRoaXMubmV4dEVmZmVjdCgpO1xuXHR9LFxuXG5cdHRyaXBsZVNob3Q6IGZ1bmN0aW9uKHVzZXIsIHRhcmdldHMsIGRvZXNNaXNzKSB7XG5cdFx0Zm9yIChsZXQgaSA9IDA7IGkgPCAzOyArK2kpIHtcblx0XHRcdHRoaXMubmV4dEVmZmVjdCgpO1xuXHRcdH1cblx0fSxcbn07XG4iXX0=