/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var WeaponUsable = (function () {
    function WeaponUsable(weaponID) {
        if (!(weaponID in Game.weapons))
            throw new ReferenceError("no weapon definition for '" + weaponID + "'");
        this.givesExperience = false;
        this.isUnlimited = true;
        this.weaponDef = clone(Game.weapons[weaponID]);
        this.isGroupCast = false;
        this.weaponID = weaponID;
        this.name = this.weaponDef.name;
        this.useAiming = false;
        this.allowDeadTarget = false;
    }
    WeaponUsable.prototype.clone = function () {
        var newCopy = new WeaponUsable(this.weaponID);
        return newCopy;
    };
    WeaponUsable.prototype.defaultTargets = function (user) {
        return [user];
    };
    WeaponUsable.prototype.getRank = function () {
        return Game.equipWeaponRank;
    };
    WeaponUsable.prototype.isUsable = function (user, stance) {
        if (stance === void 0) { stance = Stance.Attack; }
        return stance == Stance.Attack;
    };
    WeaponUsable.prototype.mpCost = function (user) {
        return 0;
    };
    WeaponUsable.prototype.use = function (unit, targets) {
        if (!this.isUsable(unit, unit.stance)) {
            Abort("WeaponUsable.use(): " + unit.name + " tried to change weapons, which is not currently possible.");
        }
        term.print(unit.name + " is equipping " + this.name, "targ: " + (targets.length > 1 ? "[multi]" : targets[0].name));
        from(targets).each(function (x) {
            x.setWeapon(this.weaponID);
        }.bind(this));
        return null;
    };
    return WeaponUsable;
}());
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid2VhcG9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsid2VhcG9uLmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7SUFHSTtBQUVKO0lBRUMsc0JBQVksUUFBUTtRQUVuQixFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUMvQixNQUFNLElBQUksY0FBYyxDQUFDLCtCQUE2QixRQUFRLE1BQUcsQ0FBQyxDQUFDO1FBRXBFLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO1FBQzdCLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDO1FBQ3hCLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztRQUMvQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztRQUN6QixJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztRQUN6QixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDO1FBQ2hDLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFFRCw0QkFBSyxHQUFMO1FBRUMsSUFBSSxPQUFPLEdBQUcsSUFBSSxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQzlDLE1BQU0sQ0FBQyxPQUFPLENBQUM7SUFDaEIsQ0FBQztJQUVELHFDQUFjLEdBQWQsVUFBZSxJQUFJO1FBRWxCLE1BQU0sQ0FBQyxDQUFFLElBQUksQ0FBRSxDQUFDO0lBQ2pCLENBQUM7SUFFRCw4QkFBTyxHQUFQO1FBRUMsTUFBTSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDN0IsQ0FBQztJQUVELCtCQUFRLEdBQVIsVUFBUyxJQUFJLEVBQUUsTUFBc0I7UUFBdEIsdUJBQUEsRUFBQSxTQUFTLE1BQU0sQ0FBQyxNQUFNO1FBRXBDLE1BQU0sQ0FBQyxNQUFNLElBQUksTUFBTSxDQUFDLE1BQU0sQ0FBQztJQUNoQyxDQUFDO0lBRUQsNkJBQU0sR0FBTixVQUFPLElBQUk7UUFFVixNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ1YsQ0FBQztJQUVELDBCQUFHLEdBQUgsVUFBSSxJQUFJLEVBQUUsT0FBTztRQUVoQixFQUFFLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDdkMsS0FBSyxDQUFDLHNCQUFzQixHQUFHLElBQUksQ0FBQyxJQUFJLEdBQUcsNERBQTRELENBQUMsQ0FBQztRQUMxRyxDQUFDO1FBQ0QsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxHQUFHLGdCQUFnQixHQUFHLElBQUksQ0FBQyxJQUFJLEVBQ2xELFFBQVEsR0FBRyxDQUFDLE9BQU8sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxHQUFHLFNBQVMsR0FBRyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztRQUNoRSxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDLFVBQVMsQ0FBQztZQUM1QixDQUFDLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUM1QixDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7UUFDZCxNQUFNLENBQUMsSUFBSSxDQUFDO0lBQ2IsQ0FBQztJQUNGLG1CQUFDO0FBQUQsQ0FBQyxBQXZERCxJQXVEQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKipcbiAqIFNwZWNzIEVuZ2luZSB2NjogU3BlY3RhY2xlcyBTYWdhIEdhbWUgRW5naW5lXG4gICogICAgICAgICAgIENvcHlyaWdodCAoYykgMjAxNyBQb3dlci1Db21tYW5kXG4qKiovXG5cbmNsYXNzIFdlYXBvblVzYWJsZVxue1xuXHRjb25zdHJ1Y3Rvcih3ZWFwb25JRClcblx0e1xuXHRcdGlmICghKHdlYXBvbklEIGluIEdhbWUud2VhcG9ucykpXG5cdFx0XHR0aHJvdyBuZXcgUmVmZXJlbmNlRXJyb3IoYG5vIHdlYXBvbiBkZWZpbml0aW9uIGZvciAnJHt3ZWFwb25JRH0nYCk7XG5cblx0XHR0aGlzLmdpdmVzRXhwZXJpZW5jZSA9IGZhbHNlO1xuXHRcdHRoaXMuaXNVbmxpbWl0ZWQgPSB0cnVlO1xuXHRcdHRoaXMud2VhcG9uRGVmID0gY2xvbmUoR2FtZS53ZWFwb25zW3dlYXBvbklEXSk7XG5cdFx0dGhpcy5pc0dyb3VwQ2FzdCA9IGZhbHNlO1xuXHRcdHRoaXMud2VhcG9uSUQgPSB3ZWFwb25JRDtcblx0XHR0aGlzLm5hbWUgPSB0aGlzLndlYXBvbkRlZi5uYW1lO1xuXHRcdHRoaXMudXNlQWltaW5nID0gZmFsc2U7XG5cdFx0dGhpcy5hbGxvd0RlYWRUYXJnZXQgPSBmYWxzZTtcblx0fVxuXG5cdGNsb25lKClcblx0e1xuXHRcdHZhciBuZXdDb3B5ID0gbmV3IFdlYXBvblVzYWJsZSh0aGlzLndlYXBvbklEKTtcblx0XHRyZXR1cm4gbmV3Q29weTtcblx0fVxuXG5cdGRlZmF1bHRUYXJnZXRzKHVzZXIpXG5cdHtcblx0XHRyZXR1cm4gWyB1c2VyIF07XG5cdH1cblxuXHRnZXRSYW5rKClcblx0e1xuXHRcdHJldHVybiBHYW1lLmVxdWlwV2VhcG9uUmFuaztcblx0fVxuXG5cdGlzVXNhYmxlKHVzZXIsIHN0YW5jZSA9IFN0YW5jZS5BdHRhY2spXG5cdHtcblx0XHRyZXR1cm4gc3RhbmNlID09IFN0YW5jZS5BdHRhY2s7XG5cdH1cblxuXHRtcENvc3QodXNlcilcblx0e1xuXHRcdHJldHVybiAwO1xuXHR9XG5cblx0dXNlKHVuaXQsIHRhcmdldHMpXG5cdHtcblx0XHRpZiAoIXRoaXMuaXNVc2FibGUodW5pdCwgdW5pdC5zdGFuY2UpKSB7XG5cdFx0XHRBYm9ydChcIldlYXBvblVzYWJsZS51c2UoKTogXCIgKyB1bml0Lm5hbWUgKyBcIiB0cmllZCB0byBjaGFuZ2Ugd2VhcG9ucywgd2hpY2ggaXMgbm90IGN1cnJlbnRseSBwb3NzaWJsZS5cIik7XG5cdFx0fVxuXHRcdHRlcm0ucHJpbnQodW5pdC5uYW1lICsgXCIgaXMgZXF1aXBwaW5nIFwiICsgdGhpcy5uYW1lLFxuXHRcdFx0XCJ0YXJnOiBcIiArICh0YXJnZXRzLmxlbmd0aCA+IDEgPyBcIlttdWx0aV1cIiA6IHRhcmdldHNbMF0ubmFtZSkpO1xuXHRcdGZyb20odGFyZ2V0cykuZWFjaChmdW5jdGlvbih4KSB7XG5cdFx0XHR4LnNldFdlYXBvbih0aGlzLndlYXBvbklEKTtcblx0XHR9LmJpbmQodGhpcykpO1xuXHRcdHJldHVybiBudWxsO1xuXHR9XG59XG4iXX0=