/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var StatusEffect = (function () {
    function StatusEffect(statusID, unit) {
        if (!(statusID in Game.statuses))
            throw new ReferenceError("no such status '" + statusID + "'");
        this.context = {};
        this.name = Game.statuses[statusID].name;
        this.statusDef = Game.statuses[statusID];
        this.statusID = statusID;
        this.unit = unit;
        term.print("initialize status effect " + unit.name + "->" + this.name);
        if ('overrules' in this.statusDef) {
            for (var i = 0; i < this.statusDef.overrules.length; ++i)
                this.unit.liftStatus(this.statusDef.overrules[i]);
        }
        if ('initialize' in this.statusDef)
            this.statusDef.initialize.call(this.context, this.unit);
    }
    StatusEffect.prototype.beginCycle = function () {
        if ('statModifiers' in this.statusDef) {
            for (var stat in Game.namedStats) {
                var multiplier = stat in this.statusDef.statModifiers
                    ? this.statusDef.statModifiers[stat]
                    : 1.0;
                this.unit.battlerInfo.stats[stat] = Math.round(multiplier * this.unit.battlerInfo.stats[stat]);
            }
        }
    };
    StatusEffect.prototype.invoke = function (eventID, data) {
        if (data === void 0) { data = null; }
        if (!(eventID in this.statusDef))
            return; // no-op if no handler
        term.print("invoke " + this.unit.name + "->" + this.name, "evt: " + eventID);
        this.unit.battle.suspend();
        this.statusDef[eventID].call(this.context, this.unit, data);
        this.unit.battle.resume();
    };
    StatusEffect.prototype.overrules = function (statusID) {
        if (!('overrules' in this.statusDef))
            return false;
        for (var i = 0; i < this.statusDef.overrules.length; ++i) {
            if (statusID == this.statusDef.overrules[i])
                return true;
        }
        return false;
    };
    return StatusEffect;
}());
//# sourceMappingURL=data:application/json;base64,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