/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var Stat = (function () {
    function Stat(baseValue, level, enableGrowth, growthRate) {
        if (level === void 0) { level = 1; }
        if (enableGrowth === void 0) { enableGrowth = true; }
        if (growthRate === void 0) { growthRate = 1.0; }
        this.baseValue = baseValue;
        this.levelUpTable = [];
        for (var i = 1; i <= 100; ++i) {
            var expNeeded = i > 1 ? Math.ceil(Math.pow(i, 3) / growthRate) : 0;
            this.levelUpTable[i] = expNeeded;
        }
        this.experience = this.levelUpTable[level];
        this.isGrowable = enableGrowth;
    }
    Object.defineProperty(Stat.prototype, "level", {
        get: function () {
            for (var level = 100; level >= 2; --level) {
                if (this.experience >= this.levelUpTable[level])
                    return level;
            }
            return 1;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Stat.prototype, "value", {
        get: function () {
            return Math.round(Math.max(Game.math.statValue(this.baseValue, this.level), 1));
        },
        enumerable: true,
        configurable: true
    });
    Stat.prototype.grow = function (experience) {
        this.experience = Math.min(Math.max(this.experience + experience, 0), this.levelUpTable[100]);
    };
    return Stat;
}());
//# sourceMappingURL=data:application/json;base64,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