/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var SpriteImage = (function () {
    function SpriteImage(filename) {
        this.spriteset = LoadSpriteset(filename);
        this.xOff = 0; //-(this.spriteset.base.x1 + Math.round((this.spriteset.base.x2 + 1 - this.spriteset.base.x1) / 2));
        this.yOff = 0; //-(this.spriteset.base.y2 + 1);
        this.directionID = 0;
        this.frameID = 0;
        this.elapsedFrames = 0;
        this.stopped = false;
    }
    Object.defineProperty(SpriteImage.prototype, "direction", {
        get: function () {
            return this.spriteset.directions[this.directionID].name;
        },
        set: function (value) {
            var index = this.spriteset.directions.length;
            var wasFound = false;
            while (--index >= 0) {
                if (this.spriteset.directions[index].name == value) {
                    wasFound = true;
                    this.directionID = index;
                    this.reset();
                    break;
                }
            }
            if (!wasFound)
                throw new ReferenceError("direction '" + value + "' not found in spriteset!");
        },
        enumerable: true,
        configurable: true
    });
    SpriteImage.prototype.blit = function (x, y, alpha) {
        if (alpha === void 0) { alpha = 255; }
        this.spriteset.images[this.spriteset.directions[this.directionID].frames[this.frameID].index]
            .blitMask(x + this.xOff, y + this.yOff, CreateColor(255, 255, 255, alpha));
    };
    SpriteImage.prototype.reset = function () {
        this.frameID = 0;
        this.elapsedFrames = 0;
    };
    SpriteImage.prototype.resume = function () {
        this.stopped = false;
    };
    SpriteImage.prototype.stop = function () {
        this.stopped = true;
    };
    SpriteImage.prototype.update = function () {
        if (this.stopped)
            return;
        var frames = this.spriteset.directions[this.directionID].frames;
        if (this.elapsedFrames >= frames[this.frameID].delay) {
            this.frameID = (this.frameID + 1) % frames.length;
            this.elapsedFrames = 0;
        }
        else {
            ++this.elapsedFrames;
        }
    };
    return SpriteImage;
}());
//# sourceMappingURL=data:application/json;base64,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