/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var MPPool = (function () {
    function MPPool(id, capacity, availableMP) {
        if (availableMP === void 0) { availableMP = capacity; }
        this.id = id;
        this.availableMP = Math.min(availableMP, capacity);
        this.capacity = capacity;
        term.print("create MP pool '" + this.id + "'", "cap: " + this.capacity, "now: " + this.availableMP);
        // handler function signature:
        //     function(pool, mpLeft)
        this.gainedMP = new Delegate();
        this.lostMP = new Delegate();
    }
    MPPool.prototype.restore = function (amount) {
        amount = Math.round(amount);
        this.availableMP = Math.min(this.availableMP + amount, this.capacity);
        this.gainedMP.invoke(this, this.availableMP);
        if (amount != 0) {
            term.print("restore " + amount + " MP to pool '" + this.id + "'", "now: " + this.availableMP);
        }
    };
    MPPool.prototype.use = function (amount) {
        amount = Math.round(amount);
        if (amount > this.availableMP)
            throw new Error("'" + this.id + "' MP overdraft");
        this.availableMP -= amount;
        this.lostMP.invoke(this, this.availableMP);
        if (amount != 0) {
            term.print("use " + Math.round(amount) + " MP from pool '" + this.id + "'", "left: " + this.availableMP);
        }
    };
    return MPPool;
}());
//# sourceMappingURL=data:application/json;base64,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