/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var ItemUsable = (function () {
    function ItemUsable(itemID) {
        if (!(itemID in Game.items))
            throw new ReferenceError("no such item '" + itemID + "'");
        this.givesExperience = false;
        this.isUnlimited = false;
        this.itemDef = clone(Game.items[itemID]);
        if (!('rank' in this.itemDef.action))
            this.itemDef.action.rank = Game.defaultItemRank;
        this.isGroupCast = false;
        this.itemID = itemID;
        this.name = this.itemDef.name;
        this.useAiming = false;
        this.allowDeadTarget = 'allowDeadTarget' in this.itemDef
            ? this.itemDef.allowDeadTarget
            : false;
        this.usesLeft = 'uses' in this.itemDef ? this.itemDef.uses : 1;
    }
    ItemUsable.prototype.clone = function () {
        var newCopy = new ItemUsable(this.itemID);
        newCopy.usesLeft = this.usesLeft;
        return newCopy;
    };
    ItemUsable.prototype.defaultTargets = function (user) {
        var target = user;
        var allies = user.battle.alliesOf(user);
        if (this.allowDeadTarget && from(allies).any(function (unit) { return !unit.isAlive(); })) {
            target = from(allies)
                .where(function (unit) { return !unit.isAlive(); })
                .sample(1).first();
        }
        return [target];
    };
    ItemUsable.prototype.getRank = function () {
        return 'rank' in this.itemDef.action ? this.itemDef.action.rank
            : Game.defaultItemRank;
    };
    ItemUsable.prototype.isUsable = function (user, stance) {
        if (stance === void 0) { stance = Stance.Attack; }
        return (this.isUnlimited || this.usesLeft > 0)
            && stance == Stance.Attack;
    };
    ItemUsable.prototype.mpCost = function (user) {
        return 0;
    };
    ItemUsable.prototype.peekActions = function () {
        return [this.itemDef.action];
    };
    ItemUsable.prototype.use = function (unit, targets) {
        if (!this.isUsable(unit, unit.stance))
            throw new Error(unit.name + " tried to use unusable item " + this.name);
        --this.usesLeft;
        term.print(unit.name + " is using " + this.name, "targ: " + (targets.length > 1 ? "[multi]" : targets[0].name), "left: " + this.usesLeft);
        var eventData = { item: clone(this.itemDef) };
        unit.raiseEvent('useItem', eventData);
        unit.battle.notifyAIs('itemUsed', unit.id, this.itemID, from(targets).select(function (v) { return v.id; }).toArray());
        return [eventData.item.action];
    };
    return ItemUsable;
}());
//# sourceMappingURL=data:application/json;base64,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