/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var FieldCondition = (function () {
    function FieldCondition(conditionID, battle) {
        if (!(conditionID in Game.conditions))
            throw new ReferenceError("no such field condition '" + conditionID + "'");
        this.battle = battle;
        this.context = {};
        this.name = Game.conditions[conditionID].name;
        this.conditionDef = Game.conditions[conditionID];
        this.conditionID = conditionID;
        term.print("initialize FC context " + this.name);
        if ('overrules' in this.conditionDef) {
            for (var i = 0; i < this.conditionDef.overrules.length; ++i)
                this.battle.liftCondition(this.conditionDef.overrules[i]);
        }
        if ('initialize' in this.conditionDef)
            this.conditionDef.initialize.call(this.context, this.battle);
    }
    FieldCondition.prototype.beginCycle = function () {
        // TODO: implement me? maybe?
    };
    FieldCondition.prototype.invoke = function (eventID, data) {
        if (data === void 0) { data = null; }
        if (!(eventID in this.conditionDef))
            return;
        term.print("invoke FC " + this.name, "evt: " + eventID);
        this.conditionDef[eventID].call(this.context, this.battle, data);
    };
    return FieldCondition;
}());
//# sourceMappingURL=data:application/json;base64,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