/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2012 Power-Command
***/
RequireScript('battleEngine/battleActor.js');
RequireScript('battleEngine/battleHUD.js');
var BattleScreen = (function () {
    function BattleScreen(partyMaxMP) {
        this.actorTypes = {
            enemy: { isEnemy: true },
            party: { isEnemy: false }
        };
        this.actors = {};
        for (var type in this.actorTypes)
            this.actors[type] = [];
        this.background = new Texture('images/battleBackground.png');
        this.hud = new BattleHUD(partyMaxMP);
        this.startRunning = function () {
            term.print("activate main battle screen");
            this.thread = threads.create(this);
            this.hud.show();
        };
    }
    BattleScreen.prototype.dispose = function () {
        this.hud.dispose();
        threads.kill(this.thread);
    };
    BattleScreen.prototype.update = function () {
        for (var type in this.actorTypes) {
            for (var i = 0; i < this.actors[type].length; ++i) {
                this.actors[type][i].update();
            }
        }
        return true;
    };
    BattleScreen.prototype.render = function () {
        prim.blit(screen, 0, -56, this.background);
        for (var type in this.actorTypes) {
            for (var i = 0; i < this.actors[type].length; ++i)
                this.actors[type][i].render();
        }
    };
    BattleScreen.prototype.announceAction = function (actionName, alignment, bannerColor) {
        if (bannerColor === void 0) { bannerColor = Color.Gray; }
        var announcement = {
            screen: this,
            text: actionName,
            alignment: alignment,
            color: bannerColor,
            font: GetSystemFont(),
            fadeness: 1.0,
            render: function () {
                var width = this.font.getStringWidth(this.text) + 20;
                var height = this.font.getHeight() + 10;
                var x = GetScreenWidth() / 2 - width / 2;
                var y = 112;
                var textY = y + height / 2 - this.font.getHeight() / 2;
                var boxColor = this.color.fade(1.0 - this.fadeness);
                prim.rect(screen, x, y, width, height, boxColor);
                prim.lineRect(screen, x, y, width, height, 1, Color.Black.fade(0.25 * (1.0 - this.fadeness)));
                drawTextEx(this.font, x + width / 2, textY, this.text, CreateColor(255, 255, 255, 255 * (1.0 - this.fadeness)), 1, 'center');
            },
            update: function () {
                return true;
            }
        };
        var thread = threads.create(announcement, 10);
        new Scene()
            .tween(announcement, 7, 'easeInOutSine', { fadeness: 0.0 })
            .pause(46)
            .tween(announcement, 7, 'easeInOutSine', { fadeness: 1.0 })
            .run(true);
        threads.kill(thread);
    };
    BattleScreen.prototype.createActor = function (name, position, row, alignment, alreadyThere) {
        if (alreadyThere === void 0) { alreadyThere = false; }
        if (!(alignment in this.actorTypes))
            throw new Error("invalid actor alignment '" + alignment + "'");
        var isEnemy = this.actorTypes[alignment].isEnemy;
        var actor = new BattleActor(name, position, row, isEnemy, alreadyThere);
        this.actors[alignment].push(actor);
        return actor;
    };
    BattleScreen.prototype.fadeOut = function (duration) {
        if (Sphere.Game.disableAnimations) {
            this.dispose();
            return;
        }
        new Scene()
            .fadeTo(Color.Black, duration)
            .call(this.dispose.bind(this))
            .fadeTo(Color.Transparent, 0.5)
            .run(true);
    };
    BattleScreen.prototype.go = function (title) {
        if (title === void 0) { title = null; }
        this.title = title;
        new Scene()
            .doIf(function () { return !Sphere.Game.disableAnimations; })
            .fadeTo(Color.White, 15)
            .fadeTo(Color.Transparent, 30)
            .fadeTo(Color.White, 15)
            .end()
            .call(this.startRunning.bind(this))
            .doIf(function () { return !Sphere.Game.disableAnimations; })
            .fadeTo(Color.Transparent, 60)
            .end()
            .run(true);
    };
    BattleScreen.prototype.showTitle = function () {
        if (this.title === null || Sphere.Game.disableAnimations)
            return;
        new Scene()
            .marquee(this.title, Color.Black.fade(0.5))
            .run(true);
    };
    return BattleScreen;
}());
//# sourceMappingURL=data:application/json;base64,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