/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
RequireScript('battleEngine/battleAI.js');
var Robert2AI = (function (_super) {
    __extends(Robert2AI, _super);
    function Robert2AI(unit, battle) {
        var _this = _super.call(this, unit, battle) || this;
        _this.definePhases([9000, 6000, 3000, 1000], 50);
        _this.defaultSkill = 'swordSlash';
        _this.doChargeSlashNext = false;
        _this.hasZombieHealedSelf = false;
        _this.isAlcoholPending = false;
        _this.isComboStarted = false;
        _this.isNecroTonicItemPending = false;
        _this.isNecromancyPending = false;
        _this.isScottZombie = false;
        _this.necroTonicItem = null;
        _this.necromancyChance = 0.0;
        _this.nextElementalMove = null;
        _this.scottStance = Stance.Attack;
        _this.scottImmuneTurnsLeft = 0;
        _this.zombieHealAlertLevel = 0.0;
        _this.zombieHealFixState = null;
        return _this;
    }
    Robert2AI.prototype.strategize = function () {
        switch (this.phase) {
            case 1:
                var magicks = ['hellfire', 'windchill', 'electrocute', 'upheaval'];
                if (this.doChargeSlashNext) {
                    this.queueSkill('chargeSlash');
                    this.doChargeSlashNext = false;
                }
                else if (this.scottStance == Stance.Attack || this.isComboStarted) {
                    qsTurns = this.predictSkillTurns('quickstrike');
                    if (qsTurns[0].unit === this.unit) {
                        this.queueSkill('quickstrike');
                        this.isComboStarted = true;
                    }
                    else {
                        if (this.isComboStarted) {
                            this.queueSkill('swordSlash');
                            this.doChargeSlashNext = true;
                            this.isComboStarted = false;
                        }
                        else {
                            var skillID_1 = random.sample(magicks);
                            if (this.isSkillUsable(skillID_1))
                                this.queueSkill(skillID_1);
                            else
                                this.queueSkill('swordSlash');
                        }
                    }
                }
                else {
                    var skillID_2 = random.sample(magicks);
                    if (this.isSkillUsable(skillID_2))
                        this.queueSkill(skillID_2);
                    else
                        this.queueSkill('swordSlash');
                }
                break;
            case 2:
                this.isStatusHealPending =
                    (this.unit.hasStatus('frostbite') || this.unit.hasStatus('ignite'))
                        && this.isStatusHealPending;
                var qsTurns = this.predictSkillTurns('quickstrike');
                if (this.isStatusHealPending && this.hasZombieHealedSelf
                    && !this.wasHolyWaterUsed && this.unit.hasStatus('zombie') && this.isItemUsable('holyWater')) {
                    var holyWaterTurns = this.predictItemTurns('holyWater');
                    if (holyWaterTurns[0].unit === this.unit && this.isItemUsable('tonic')) {
                        this.queueItem('holyWater');
                        this.queueItem('tonic');
                        this.wasTonicUsed = true;
                    }
                    else {
                        this.queueItem('holyWater');
                        this.wasTonicUsed = false;
                    }
                    this.wasHolyWaterUsed = true;
                }
                else if (this.isStatusHealPending && (this.unit.hasStatus('frostbite') || this.unit.hasStatus('ignite'))) {
                    var skillID = this.unit.hasStatus('frostbite') ? 'ignite' : 'frostbite';
                    var spellTurns = this.predictSkillTurns(skillID);
                    var isTonicUsable = (!this.unit.hasStatus('zombie') || this.wasHolyWaterUsed || !this.hasZombieHealedSelf)
                        && this.isItemUsable('tonic');
                    if (spellTurns[0].unit === this.unit && isTonicUsable || this.wasTonicUsed) {
                        this.queueSkill(skillID, Stance.Attack, 'robert2');
                        if (!this.wasTonicUsed && isTonicUsable) {
                            this.queueItem('tonic');
                        }
                        else {
                            this.queueSkill(this.nextElementalMove !== null ? this.nextElementalMove
                                : skillID == 'chill' ? 'ignite' : 'frostbite');
                        }
                    }
                    else if (!this.wasTonicUsed && isTonicUsable) {
                        this.queueItem('tonic');
                    }
                    else {
                        this.queueSkill(this.nextElementalMove !== null ? this.nextElementalMove
                            : skillID == 'chill' ? 'ignite' : 'frostbite');
                    }
                    this.isStatusHealPending = false;
                    this.wasHolyWaterUsed = false;
                }
                else if ((random.chance(0.5) || this.isComboStarted) && qsTurns[0].unit === this.unit) {
                    this.queueSkill('quickstrike');
                    this.isComboStarted = true;
                    this.wasHolyWaterUsed = false;
                }
                else if (this.isComboStarted) {
                    var skillToUse = random.chance(0.5)
                        ? random.sample(['hellfire', 'windchill', 'electrocute', 'upheaval'])
                        : 'chargeSlash';
                    this.queueSkill(skillToUse);
                    if (skillToUse == 'upheaval')
                        this.queueSkill('tremor');
                    this.isComboStarted = false;
                    this.isStatusHealPending = skillToUse == 'upheaval';
                    this.wasHolyWaterUsed = false;
                }
                else {
                    var skillToUse = random.sample(['hellfire', 'windchill', 'electrocute', 'upheaval']);
                    this.queueSkill(skillToUse);
                    if (skillToUse == 'upheaval')
                        this.queueSkill('tremor');
                    this.isStatusHealPending = skillToUse == 'upheavel';
                    this.wasHolyWaterUsed = false;
                }
                break;
            case 3:
                var holyWaterTurns = this.predictItemTurns('holyWater');
                if (this.isChargeSlashPending && !this.unit.hasStatus('protect')) {
                    this.queueSkill('chargeSlash');
                    this.isChargeSlashPending = false;
                }
                else if (this.unit.hasStatus('zombie') && this.hasZombieHealedSelf
                    && this.isItemUsable('holyWater') && this.isItemUsable('tonic')
                    && holyWaterTurns[0].unit === this.unit) {
                    this.queueItem('holyWater');
                    this.queueItem('tonic');
                }
                else if ((this.unit.hasStatus('ignite') || this.unit.hasStatus('frostbite')) && this.elementalsTillRevenge > 0) {
                    --this.elementalsTillRevenge;
                    if (this.elementalsTillRevenge <= 0) {
                        this.queueSkill('bolt');
                        this.necroTonicItem = 'powerTonic';
                    }
                    else {
                        if (this.unit.hasStatus('ignite')) {
                            this.queueSkill('frostbite', Stance.Attack, 'robert2');
                        }
                        else if (this.unit.hasStatus('frostbite')) {
                            this.queueSkill('ignite', Stance.Attack, 'robert2');
                        }
                    }
                }
                else if (random.chance(0.5) || this.isComboStarted) {
                    var forecast = this.predictSkillTurns('chargeSlash');
                    if ((forecast[0].unit === this.unit && !this.isComboStarted) || this.doChargeSlashNext) {
                        this.isComboStarted = false;
                        if (forecast[0].unit === this.unit) {
                            this.queueSkill('chargeSlash');
                        }
                        else {
                            this.queueSkill(this.nextElementalMove !== null
                                ? this.nextElementalMove
                                : random.sample(['ignite', 'frostbite']));
                        }
                    }
                    else {
                        this.isComboStarted = true;
                        forecast = this.predictSkillTurns('quickstrike');
                        if (forecast[0].unit === this.unit) {
                            this.queueSkill('quickstrike');
                        }
                        else {
                            var skillToUse = random.chance(0.5) ? 'upheaval' : 'swordSlash';
                            if (this.isSkillUsable(skillToUse)) {
                                this.queueSkill(skillToUse);
                                if (skillToUse == 'upheaval')
                                    this.queueSkill('tremor');
                                this.doChargeSlashNext = skillID == 'swordSlash';
                                this.isComboStarted = false;
                            }
                            else {
                                this.queueSkill('swordSlash');
                                this.doChargeSlashNext = true;
                                this.isComboStarted = false;
                            }
                        }
                    }
                }
                else {
                    var skillID = random.sample(['hellfire', 'windchill', 'electrocute', 'upheaval']);
                    this.queueSkill(skillID);
                    if (skillID == 'upheaval')
                        this.queueSkill('tremor');
                }
                break;
            case 4:
                var skillID = random.sample(['hellfire', 'windchill', 'electrocute', 'upheaval']);
                var finisherID = this.isSkillUsable(skillID) ? skillID : 'swordSlash';
                var qsTurns = this.predictSkillTurns('quickstrike');
                this.queueSkill(qsTurns[0].unit == this.unit ? 'quickstrike' : finisherID);
                if (this.isSkillQueued(finisherID) && this.scottStance == Stance.Guard)
                    this.queueSkill('chargeSlash');
                break;
            case 5:
                if (this.isAlcoholPending) {
                    this.isAlcoholPending = false;
                    if (!this.unit.hasStatus('zombie')) {
                        this.queueItem('alcohol');
                        this.queueSkill('chargeSlash');
                        this.queueSkill('hellfire');
                        this.queueSkill('upheaval');
                        this.queueSkill('windchill');
                        this.queueSkill('electrocute');
                        this.queueSkill('omni', Stance.Charge);
                    }
                    else {
                        if (this.isSkillUsable('omni'))
                            this.queueSkill('omni', Stance.Charge);
                        this.queueSkill('chargeSlash');
                    }
                }
                else {
                    var qsTurns = this.predictSkillTurns('quickstrike');
                    var moves = this.unit.mpPool.availableMP >= 200
                        ? ['flare', 'chill', 'lightning', 'quake', 'quickstrike', 'chargeSlash']
                        : ['quickstrike', 'chargeSlash'];
                    var skillID = random.sample(moves);
                    if (skillID == 'quickstrike' || this.isComboStarted) {
                        skillID = qsTurns[0].unit === this.unit ? 'quickstrike' : 'swordSlash';
                        this.isComboStarted = skillID == 'quickstrike';
                        this.queueSkill(skillID);
                    }
                    else {
                        this.queueSkill(skillID);
                    }
                }
        }
    };
    ;
    Robert2AI.prototype.on_itemUsed = function (userID, itemID, targetIDs) {
        if (this.unit.hasStatus('drunk') || this.unit.hasStatus('offGuard'))
            return;
        term.print(userID, itemID, targetIDs);
        var curativeIDs = ['tonic', 'powerTonic'];
        if (userID == 'robert2' && from(curativeIDs).anyIs(itemID) && this.unit.hasStatus('zombie')
            && from(targetIDs).anyIs('robert2') && this.phase <= 4) {
            if (this.zombieHealFixState === null && this.isItemUsable('holyWater')) {
                this.queueItem('holyWater');
                this.hasZombieHealedSelf = true;
            }
        }
        else if (userID == 'robert2' && itemID == 'alcohol' && from(targetIDs).anyIs('robert2')) {
            this.unit.addStatus('finalStand');
            new Scene()
                .adjustBGM(0.5, 300)
                .talk("Scott", true, 2.0, Infinity, "Robert! Tell me what we're accomplishing fighting like this! You HAVE to "
                + "realize by now that no matter what any of us do, Amanda is the Primus! None of us--nothing can "
                + "change that now!")
                .talk("Robert", true, 2.0, Infinity, "...")
                .talk("Scott", true, 2.0, Infinity, "You think I haven't come just as far as you? Is that it, Robert? You believe I "
                + "chose to be in the position I'm in? No... instead I can only stand here wishing it were so simple.", "None of us chose our lots, Robert, not one. Not Bruce, Lauren, Amanda... not even you or me. All of us, "
                + "in the end, left with no choice but to try to play with the absurd hand we were dealt.")
                .talk("Robert", true, 1.0, Infinity, "...")
                .fork()
                .adjustBGM(0.0, 300)
                .end()
                .talk("Scott", true, 2.0, Infinity, "Let the cards fall how they may. I'm not backing down now. I owe myself far too much.")
                .resync()
                .pause(60)
                .changeBGM('basicInstinct')
                .adjustBGM(1.0)
                .talk("Robert", true, 2.0, Infinity, "If that's what you want, then so be it.")
                .run(true);
        }
        else if (userID == 'scott' && from(targetIDs).anyIs('robert2')) {
            if (from(curativeIDs).anyIs(itemID) && this.unit.hasStatus('zombie')
                && !this.isSkillQueued('electrocute')) {
                if (this.phase <= 4 && this.zombieHealFixState === null) {
                    this.zombieHealFixState = 'fixStatus';
                    if (this.zombieHealAlertLevel > 1.0 || !this.isItemUsable('vaccine') && !this.isItemUsable('holyWater'))
                        this.zombieHealFixState = 'retaliate';
                }
                else if (this.phase == 5 && !this.hasMovesQueued()) {
                    if ((this.isItemUsable('powerTonic') || this.isItemUsable('tonic'))
                        && this.unit.mpPool.availableMP >= 300) {
                        this.queueSkill('electrocute');
                        this.queueItem(this.isItemUsable('powerTonic') ? 'powerTonic' : 'tonic', 'scott');
                    }
                }
            }
        }
        else if (userID == 'scott' && from(targetIDs).anyIs('scott')) {
            if (itemID == 'vaccine' && this.scottImmuneTurnsLeft == 0) {
                this.isScottZombie = false;
                this.scottImmuneTurnsLeft = 6;
            }
            else if (itemID == 'holyWater' && this.isScottZombie) {
                this.isScottZombie = false;
            }
            else if (this.phase <= 3 && from(curativeIDs).anyIs(itemID) && !this.isNecromancyPending
                && !this.isScottZombie && !this.isSkillQueued('necromancy') && !this.isSkillQueued('electrocute')
                && this.zombieHealFixState === null) {
                this.necromancyChance += 0.25;
                if (random.chance(this.necromancyChance) && !this.isNecroTonicItemPending) {
                    this.queueSkill(this.phase <= 2 ? 'necromancy' : 'bolt');
                    this.necromancyChance = 0.0;
                }
            }
        }
    };
    Robert2AI.prototype.on_phaseChanged = function (newPhase, lastPhase) {
        switch (newPhase) {
            case 1:
                this.queueSkill('omni');
                this.doChargeSlashNext = true;
                this.isComboStarted = false;
                this.isNecromancyPending = true;
                break;
            case 2:
                this.queueSkill('upheaval', Stance.Charge);
                this.isComboStarted = false;
                this.isStatusHealPending = true;
                this.wasHolyWaterUsed = false;
                this.wasTonicUsed = false;
                break;
            case 3:
                this.queueSkill('protectiveAura');
                this.queueSkill(this.nextElementalMove !== null ? this.nextElementalMove : 'bolt', Stance.Charge);
                this.necroTonicItem = this.nextElementalMove === null ? 'tonic' : null;
                this.doChargeSlashNext = false;
                this.elementalsTillRevenge = 2;
                this.isChargeSlashPending = true;
                this.isComboStarted = false;
                break;
            case 4:
                this.queueSkill('crackdown');
                break;
            case 5:
                this.queueSkill('desperationSlash');
                if (this.unit.hasStatus('zombie') && this.isItemUsable('vaccine'))
                    this.queueItem('vaccine');
                this.isAlcoholPending = true;
                this.isComboStarted = false;
                break;
        }
    };
    Robert2AI.prototype.on_skillUsed = function (userID, skillID, stance, targetIDs) {
        if (this.unit.hasStatus('drunk') || this.unit.hasStatus('offGuard'))
            return;
        if (userID == 'robert2') {
            if (skillID == this.nextElementalMove) {
                this.nextElementalMove = null;
            }
            else if (skillID == 'ignite') {
                this.nextElementalMove = 'windchill';
            }
            else if (skillID == 'frostbite') {
                this.nextElementalMove = 'hellfire';
            }
            else if (skillID == 'necromancy' || skillID == 'bolt') {
                this.isScottZombie = (skillID == 'necromancy' || skillID == 'bolt' && this.scottStance != Stance.Guard)
                    && this.scottImmuneTurnsLeft <= 0;
                this.isNecroTonicItemPending = this.isScottZombie && this.necroTonicItem !== null
                    && this.isItemUsable(this.necroTonicItem);
            }
        }
        else if (userID == 'scott' && from(targetIDs).anyIs('scott')) {
            if (((skillID == 'ignite' || skillID == 'hellfire') && this.nextElementalMove == 'hellfire')
                || ((skillID == 'frostbite' || skillID == 'windchill') && this.nextElementalMove == 'windchill')) {
                this.nextElementalMove = null;
            }
        }
    };
    Robert2AI.prototype.on_stanceChanged = function (unitID, stance) {
        if (this.unit.hasStatus('drunk'))
            return;
        if (unitID == 'scott')
            this.scottStance = stance;
    };
    ;
    Robert2AI.prototype.on_unitReady = function (unitID) {
        if (this.unit.hasStatus('drunk'))
            return;
        if (this.zombieHealFixState === null)
            this.zombieHealAlertLevel = Math.max(0.0, this.zombieHealAlertLevel - 0.1);
        if (unitID == 'robert2' && !this.hasMovesQueued()) {
            if (this.isNecromancyPending && this.scottImmuneTurnsLeft <= 0) {
                if (!this.isScottZombie)
                    this.queueSkill('necromancy');
                this.isNecromancyPending = false;
            }
            else if (this.unit.mpPool.availableMP < 0.25 * this.unit.mpPool.capacity && this.isItemUsable('redBull') && this.phase <= 4) {
                this.queueItem('redBull');
            }
            else if (this.isNecroTonicItemPending) {
                if (this.isItemUsable(this.necroTonicItem)) {
                    var itemTarget = this.isScottZombie ? 'scott' : 'robert2';
                    this.queueItem(this.necroTonicItem, itemTarget);
                }
                this.isNecroTonicItemPending = false;
                this.necroTonicItem = null;
            }
            else if (this.zombieHealFixState !== null) {
                switch (this.zombieHealFixState) {
                    case 'fixStatus':
                        var itemID = (this.zombieHealAlertLevel > 0.0 || !this.isItemUsable('holyWater')) && this.isItemUsable('vaccine')
                            ? 'vaccine' : 'holyWater';
                        this.queueItem(itemID);
                        this.zombieHealFixState = 'retaliate';
                        break;
                    case 'retaliate':
                        switch (Math.ceil(this.zombieHealAlertLevel)) {
                            case 0.0:
                                if (this.isSkillUsable('bolt')) {
                                    this.queueSkill('bolt');
                                    this.necroTonicItem = 'tonic';
                                }
                                break;
                            case 1.0:
                                if (this.nextElementalMove === null) {
                                    this.queueSkill('ignite');
                                    this.queueSkill('windchill', Stance.Charge);
                                }
                                else {
                                    var firstMoveID = this.nextElementalMove != 'hellfire' ? 'hellfire' : 'windchill';
                                    this.queueSkill(firstMoveID);
                                    this.queueSkill(this.nextElementalMove);
                                }
                                break;
                            default:
                                if (this.isItemUsable('redBull'))
                                    this.queueItem('redBull');
                                this.queueSkill('omni');
                                break;
                        }
                        this.zombieHealFixState = 'finish';
                        break;
                    case 'finish':
                        this.zombieHealAlertLevel += 1.0;
                        this.zombieHealFixState = null;
                        break;
                }
            }
        }
        else if (unitID == 'scott') {
            if (this.scottImmuneTurnsLeft > 0)
                --this.scottImmuneTurnsLeft;
            this.necromancyChance = Math.max(this.necromancyChance - 0.05, 0.0);
        }
    };
    return Robert2AI;
}(BattleAI));
//# sourceMappingURL=data:application/json;base64,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