/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
RequireScript('battleEngine/battleAI.js');
var Robert2AI = (function (_super) {
    __extends(Robert2AI, _super);
    function Robert2AI(unit, battle) {
        var _this = _super.call(this, unit, battle) || this;
        _this.definePhases([9000, 6000, 3000, 1000], 50);
        _this.defaultSkill = 'swordSlash';
        _this.immuneTurns = 0;
        _this.scottIsZombie = false;
        return _this;
    }
    Robert2AI.prototype.strategize = function () {
    };
    Robert2AI.prototype.on_phaseChanged = function (newPhase, lastPhase) {
        switch (newPhase) {
            case 1:
                this.queueSkill('omni');
                break;
            case 2:
                this.queueSkill('upheaval', Stance.Charge);
                break;
            case 3:
                this.queueSkill('protectiveAura');
                this.queueSkill('electrocute', Stance.Charge);
                break;
            case 4:
                this.queueSkill('crackdown');
                break;
            case 5:
                this.queueSkill('desperationSlash');
        }
    };
    Robert2AI.prototype.on_skillUsed = function (userID, skillID, stance, targetIDs) {
        if (userID === 'robert2' && from(targetIDs).anyIs('scott')) {
            if ((skillID === 'electrocute' && stance === Stance.Charge)
                || skillID === 'bolt' || skillID === 'necromancy') {
                if (this.immuneTurns <= 0)
                    this.scottIsZombie = true;
            }
        }
    };
    Robert2AI.prototype.on_itemUsed = function (userID, itemID, targetIDs) {
        var Curatives = ['tonic', 'powerTonic', 'fullTonic'];
        if (itemID === 'holyWater' && from(targetIDs).anyIs('scott'))
            this.scottIsZombie = false;
        if (itemID === 'vaccine' && from(targetIDs).anyIs('scott')) {
            this.immuneTurns = 5;
            this.scottIsZombie = false;
        }
        if (userID === 'scott' && from(targetIDs).anyIs('scott')) {
            if (from(Curatives).anyIs(itemID)) {
                var zombieChance = this.phase <= 2 ? 1.0
                    : this.phase === 3 ? 0.5
                        : 0.0;
                var skill = this.phase < 2 ? 'necromancy' : 'bolt';
                if (random.chance(zombieChance) && !this.hasMovesQueued())
                    this.queueSkill(skill);
            }
        }
        if (userID === 'scott' && from(targetIDs).anyIs('robert2') && from(Curatives).anyIs(itemID)
            && this.unit.hasStatus('zombie')) {
            if (this.isItemUsable('vaccine'))
                this.queueItem('vaccine');
            else {
                this.queueSkill('bolt');
                this.queueItem('tonic', 'scott');
            }
        }
    };
    return Robert2AI;
}(BattleAI));
//# sourceMappingURL=data:application/json;base64,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