/***
 * Specs Engine v6: Spectacles Saga Game Engine
  *           Copyright (c) 2017 Power-Command
***/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
RequireScript('battleEngine/battleAI.js');
var HeadlessHorseAI = (function (_super) {
    __extends(HeadlessHorseAI, _super);
    function HeadlessHorseAI(unit, battle) {
        var _this = _super.call(this, unit, battle) || this;
        _this.definePhases([1000], 50);
        _this.defaultSkill = 'flare';
        return _this;
    }
    HeadlessHorseAI.prototype.on_phaseChanged = function (newPhase, lastPhase) {
        switch (newPhase) {
            case 1:
                this.queueSkill('trample', Stance.Attack, 'maggie');
                this.queueSkill('flareUp');
                break;
            case 2:
                this.queueSkill('spectralReversion');
                this.defaultSkill = 'flameBreath';
                break;
        }
    };
    HeadlessHorseAI.prototype.on_skillUsed = function (userID, skillID, targetIDs) {
        if (from(targetIDs).anyIs('headlessHorse')
            && this.unit.hasStatus('ignite')
            && skillID === 'chill') {
            if (this.unit.hasStatus('ghost'))
                this.queueSkill('spectralKick', Stance.Charge, userID);
            else
                this.queueSkill('trample', Stance.Attack, userID);
        }
    };
    return HeadlessHorseAI;
}(BattleAI));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGVhZGxlc3NIb3JzZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImhlYWRsZXNzSG9yc2UuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7OztJQUdJOzs7Ozs7Ozs7OztBQUVKLGFBQWEsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0FBRTFDO0lBQThCLG1DQUFRO0lBRXJDLHlCQUFZLElBQUksRUFBRSxNQUFNO1FBQXhCLFlBRUMsa0JBQU0sSUFBSSxFQUFFLE1BQU0sQ0FBQyxTQUluQjtRQUZBLEtBQUksQ0FBQyxZQUFZLENBQUMsQ0FBRSxJQUFJLENBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNoQyxLQUFJLENBQUMsWUFBWSxHQUFHLE9BQU8sQ0FBQzs7SUFDN0IsQ0FBQztJQUVELHlDQUFlLEdBQWYsVUFBZ0IsUUFBUSxFQUFFLFNBQVM7UUFFbEMsTUFBTSxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztZQUNsQixLQUFLLENBQUM7Z0JBQ0wsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLEVBQUUsTUFBTSxDQUFDLE1BQU0sRUFBRSxRQUFRLENBQUMsQ0FBQztnQkFDcEQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQztnQkFDM0IsS0FBSyxDQUFDO1lBQ1AsS0FBSyxDQUFDO2dCQUNMLElBQUksQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQztnQkFDckMsSUFBSSxDQUFDLFlBQVksR0FBRyxhQUFhLENBQUM7Z0JBQ2xDLEtBQUssQ0FBQztRQUNSLENBQUM7SUFDRixDQUFDO0lBRUQsc0NBQVksR0FBWixVQUFhLE1BQU0sRUFBRSxPQUFPLEVBQUUsU0FBUztRQUV0QyxFQUFFLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQztlQUNuQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUM7ZUFDN0IsT0FBTyxLQUFLLE9BQU8sQ0FBQyxDQUMzQixDQUFDO1lBQ0EsRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLENBQUM7Z0JBQ2hDLElBQUksQ0FBQyxVQUFVLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUM7WUFDeEQsSUFBSTtnQkFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBQ3BELENBQUM7SUFDRixDQUFDO0lBQ0Ysc0JBQUM7QUFBRCxDQUFDLEFBcENELENBQThCLFFBQVEsR0FvQ3JDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqKlxuICogU3BlY3MgRW5naW5lIHY2OiBTcGVjdGFjbGVzIFNhZ2EgR2FtZSBFbmdpbmVcbiAgKiAgICAgICAgICAgQ29weXJpZ2h0IChjKSAyMDE3IFBvd2VyLUNvbW1hbmRcbioqKi9cblxuUmVxdWlyZVNjcmlwdCgnYmF0dGxlRW5naW5lL2JhdHRsZUFJLmpzJyk7XG5cbmNsYXNzIEhlYWRsZXNzSG9yc2VBSSBleHRlbmRzIEJhdHRsZUFJXG57XG5cdGNvbnN0cnVjdG9yKHVuaXQsIGJhdHRsZSlcblx0e1xuXHRcdHN1cGVyKHVuaXQsIGJhdHRsZSk7XG5cblx0XHR0aGlzLmRlZmluZVBoYXNlcyhbIDEwMDAgXSwgNTApO1xuXHRcdHRoaXMuZGVmYXVsdFNraWxsID0gJ2ZsYXJlJztcblx0fVxuXG5cdG9uX3BoYXNlQ2hhbmdlZChuZXdQaGFzZSwgbGFzdFBoYXNlKVxuXHR7XG5cdFx0c3dpdGNoIChuZXdQaGFzZSkge1xuXHRcdFx0Y2FzZSAxOlxuXHRcdFx0XHR0aGlzLnF1ZXVlU2tpbGwoJ3RyYW1wbGUnLCBTdGFuY2UuQXR0YWNrLCAnbWFnZ2llJyk7XG5cdFx0XHRcdHRoaXMucXVldWVTa2lsbCgnZmxhcmVVcCcpO1xuXHRcdFx0XHRicmVhaztcblx0XHRcdGNhc2UgMjpcblx0XHRcdFx0dGhpcy5xdWV1ZVNraWxsKCdzcGVjdHJhbFJldmVyc2lvbicpO1xuXHRcdFx0XHR0aGlzLmRlZmF1bHRTa2lsbCA9ICdmbGFtZUJyZWF0aCc7XG5cdFx0XHRcdGJyZWFrO1xuXHRcdH1cblx0fVxuXG5cdG9uX3NraWxsVXNlZCh1c2VySUQsIHNraWxsSUQsIHRhcmdldElEcylcblx0e1xuXHRcdGlmIChmcm9tKHRhcmdldElEcykuYW55SXMoJ2hlYWRsZXNzSG9yc2UnKVxuXHRcdCAgICAmJiB0aGlzLnVuaXQuaGFzU3RhdHVzKCdpZ25pdGUnKVxuXHRcdCAgICAmJiBza2lsbElEID09PSAnY2hpbGwnKVxuXHRcdHtcblx0XHRcdGlmICh0aGlzLnVuaXQuaGFzU3RhdHVzKCdnaG9zdCcpKVxuXHRcdFx0XHR0aGlzLnF1ZXVlU2tpbGwoJ3NwZWN0cmFsS2ljaycsIFN0YW5jZS5DaGFyZ2UsIHVzZXJJRCk7XG5cdFx0XHRlbHNlXG5cdFx0XHRcdHRoaXMucXVldWVTa2lsbCgndHJhbXBsZScsIFN0YW5jZS5BdHRhY2ssIHVzZXJJRCk7XG5cdFx0fVxuXHR9XG59XG4iXX0=