/**
 * TestIsland map script.
 * Loaded automatically by persist.js.
 */

/** We can put normal code up here! */

// Herb person template.
// picked and destroyMe are custom added.
function makeHerb()
{
    return {
        picked: false,
        destroyMe: function () {
            DestroyPerson(GetCurrentPerson());
        },
        create: function (world, map, person) {
            if (person.picked) person.destroyMe();
        },
        talk: function (world, map, person) {
            TextBox("Picking a herb...");
            person.picked = true;
            map.herbs_picked++;
            person.destroyMe();
        },
    };
}

/** Map script starts here */

({
// A single variable in our map state
herbs_picked: 0,

// Map events (all optional)
enter: function (world, map) {},
leave: function (world, map) {},
leaveNorth: function (world, map) {},
leaveSouth: function (world, map) {},
leaveEast: function (w, m) { // parameters can be named anything
    ChangeMap("BlockMaze.rmp");
    SetPersonX("Facey", 8);
},
leaveWest: function (world, map) {},

// Facey_1: remembers how many times you've talked to him.
Facey_1: {
    talk_count: 0,
    
    create: function (world, map, person) {
        faceInitial('south');
    },
    
    talk: function (w, m, p) {
        p.talk_count++;
        TextBox("You've talked to me " + p.talk_count + " time(s).");
    },
    
    // you can leave out empty functions if you want
    destroy: function (w, m, p) {},
    touch: function (w, m, p) {},
    generator: function (w, m, p) {},
},

// HerbKeeper: he watches the herbs.
HerbKeeper: {
    create: function (w, m, p) {
        faceInitial('south');
    },
    
    talk: function (w, m, p) {
        if (m.herbs_picked == 0)
            TextBox("Don't pick those herbs.");
        else if (m.herbs_picked == 3)
            TextBox("YOU TOOK ALL OF THE HERBS?!");
        else if (m.herbs_picked == 1)
            TextBox("Hey, you took a herb...");
        else
            TextBox("Hey, why did you take those " + m.herbs_picked + " herbs?");
    },
},

// Herbs: they're made from the template function at the top.
Herb_1: makeHerb(),
Herb_2: makeHerb(),
Herb_3: makeHerb(),

})