/**
 * persist.js demo
 *
 * persist.js is a framework that lets you set and preserve values
 * with persons, maps or the whole game world.  Very neat! :)
 */

RequireScript("persist.js");

function game()
{
    persist.init();
    
    CreatePerson("Facey", "Facey.rss", false);
    AttachInput("Facey");
    AttachCamera("Facey");
    MapEngine("TestIsland.rmp", 60);
}

var font = GetSystemFont();
var windowstyle = GetSystemWindowStyle();

/**
 * Show a text box and wait for a key press.
 */
function TextBox(text) {
    var width = GetScreenWidth() * 0.8;
    var height = font.getHeight() * 3;
    var x = (GetScreenWidth() - width) / 2.0;
    var y = GetScreenHeight() - height - font.getHeight() * 2;

    RenderMap();
    windowstyle.drawWindow(x, y, width, height);
    font.drawTextBox(x, y, width, height, 0, text);
    FlipScreen();
    GetKey();
}

/**
 * Set an initial direction on person creation.
 * Best run in a person create script.
 */
function faceInitial(direction) {
    var p = GetCurrentPerson();
    QueuePersonScript(p, "SetPersonDirection('" + p + "', '" + direction + "'); ", false);
}