EvaluateSystemScript("screen.js");
EvaluateSystemScript("audio.js");
EvaluateSystemScript("time.js");
EvaluateScript("oldsphere.js"); // different from the system script
EvaluateSystemScript("menu.js");


var flag = 0;
var contact = Math.round(1 + (100 * Math.random()));
var meeting = 0;

var last_x = 0;
var last_y = 0;
 
var player = new Object();
player.hp = 15;
player.maxhp = 30;
player.mp = 0;
player.maxmp = 5;

var monster = new Object();
monster.hp = 0;
monster.maxhp = 0;
monster.mp = 0;
monster.maxmp = 0;
monster.image = LoadImage("slimeking.png");

var battle_has_finished = false;

function game()
{    
  SetFont("dq2.rfn");
  SetWindowStyle("menu.rws");
  CreatePerson("girl", "girl.rss", false);  
  AttachInput("girl");
  AttachCamera("girl");
  // RenderMap();
  // FadeFromColor(1000,Black);
  SetUpdateScript("test()");
  MapEngine("test.rmp", 60);
}


function test()
{
  var has_moved = false;
  if (last_x != GetPersonX("girl") || last_y != GetPersonY("girl"))
  {
    last_x = GetPersonX("girl");
    last_y = GetPersonY("girl");
    has_moved = true;
  }

  if (has_moved)
  {
    if (flag == 0)
    {
      contact = tile(contact);
      ++flag;
    }
    else
    {
      contact = tile(contact);
      if (contact < 0)
      {
        meet();
      }
    }
  }
}

function tile(x)
{
  var c = GetTile(Math.floor(GetPersonX("girl") / GetTileWidth()), Math.floor(GetPersonX("girl") / GetTileHeight()), 0);
    
  switch (c)
  {
    case 1:
      x--;
    break;
        
    case 2:
      x -=1;
    break;
        
    case 9:
      x -=5;
    break;
        
    case 13:
      x -=5;
    break;
        
    case 14:
      x -=3;
    break;
  }
      
  return x;
}

function debug(text)
{
  // ClearScreen();
  DrawText(0,0, text);
  FlipScreen();
  Delay(1500);
}

function meet()
{
  // set up monster details
  monster.name = "King Slime";
  monster.hp = 5;
  monster.maxhp = 5;

  var myTest = "~King Slime Appeared!";
  // testing();
  // ChangeMusic("Battle2.mp3");
  FadeFromColor(500, White);
  FadeOut(1500);

    render_battle();
    FadeIn(1000);
    Delay(500);
    DrawWindow(90,160,220,30);   
    DrawTextBox(90,160,220,30,3, myTest);

  battle();
  contact = Math.round(1+ (100*Math.random()));
  flag = 0;
  return contact;
}

var img = LoadImage("forest.png");

function battle()
{
  battle_has_finished = false;  
  // PlaySound("beep.wav");
  while (!battle_has_finished)
  {
    check_player_monster_stats()  

    render_battle();
    var m = new Menu();
    m.addItem("Fight", function() { fight(); });
    m.addItem("Magic", function() { magic(); });
    m.addItem("Item",  function() {  });
    m.addItem("Run",   function() { run(); });

    m.execute(9,145,65,60,15);

    check_player_monster_stats();
    if (battle_has_finished)
      break;

    // you've just taken your turn
    EnemyAttacks();
  }
}

function fight()
{
  render_battle();
  // PlaySound("chancehit.wav");
  var fight_msg = "";  
  
  var dmg = Math.round(6*Math.random());
  if (dmg == 0)
  {
    Delay(500);
    //PlaySound("miss.wav");
    fight_msg = "~You missed with your attack.";
  }
      
  else
  {
    Delay(500);
    //PlaySound("hit.wav");
    fight_msg = "~You hit for " + dmg + " damage.";
  }

  monster.hp -= dmg;
      
  check_player_monster_stats();

  DrawWindow(23,160,275,60);
  DrawTextBox(23,160,275,60,3, fight_msg);
  FlipScreen();
  Delay(1000);
    
  fight_msg = "~Next Command?";
            
  Delay(1000);
}

function EnemyAttacks()
{ 
  // PlaySound("ehit.wav");
  render_battle();
  
  var fight_msg_1 = "";
  var fight_msg_2 = "";
  var exhit = (Math.round(1 + (50+ (Math.random()))));
  var dmg = Math.round(6*Math.random());
  if (exhit == 50)
  {
    Delay(500);
    dmg = (Math.round(6*Math.random()))*2;
    // PlaySound("exhit.wav");
    fight_msg_2 = "~Excellent Hit!";
    Delay(500);
  }
  
  if (dmg == 0)
  {
    Delay(500);
    if (exhit == 50)
    {
      // PlaySound("exmiss.wav");
    }
    else
    {
      // PlaySound("miss.wav");
    }
    fight_msg_1 = "~King Slime missed with its attack!";
  }
      
  else
  {
    Delay(500);
    if (exhit == 50)
    {
      // PlaySound("exhithit.wav");
    }
    else
    {
      // PlaySound("hit.wav");
    }
    fight_msg_1 = "~King Slime hit for "+ dmg + " damage!";
  }

  DrawWindow(23,160,275,60);
  if (exhit == 50)
  {
    DrawTextBox(23,160,275,60,3, fight_msg_2);
    DrawTextBox(23,173,275,60,3, fight_msg_1);
  }
  else
  {
    DrawTextBox(23,160,275,60,3, fight_msg_1);
  }
  
  player.hp -= dmg;

  FlipScreen();
  Delay(1000);
    
  fight_msg_1 = "";
  fight_msg_2 = "";
}

function check_player_monster_stats()
{
  if (player.hp <= 0)
  {
    battle_has_finished = true;
    FadeOut(1000);
    player.hp = 0;
    // ChangeMusic("dead.mp3");
    // Delay(7000);
    // ChangeMusic("nothing.mp3");
    // render_battle();
    DrawTextBox(23,160,275,60,3, "~You have died in battle.");
    FlipScreen();
    Delay(7000);
    Exit();
  }
  else if (monster.hp <= 0)
  {
    battle_has_finished = true;
  }
}

function render_battle()
{
  // draw stats
  if (player.maxhp < Math.round(player.hp / 3))
  {
    SetTextColor(Red);
  }
  else
  {
    SetTextColor(White);
  }
  DrawWindow(9,50,300,100);
  img.blit(0, -20);
  DrawWindow(9,14,52,40);
  DrawTextBox(9,14,52,40,3,"~`Gwen");
  DrawTextBox(9,24,52,40,3,"~HP]]:]]" + player.hp);
  DrawTextBox(9,34,52,40,3,"~MP]]:]]" + player.mp);
  SetTextColor(White);

  // draw the monster
  DrawText(75, 75, monster.name + " has " + monster.hp + " hp");
  monster.image.blit((GetScreenWidth() - monster.image.width) / 2, (GetScreenHeight() - monster.image.height) / 2)
}

function end()
{
  ClearScreen();
  FlipScreen();
  debug("YOU WON!");
  Delay(1500);
}

function magic()
{
  for (var a = 0; a < 10; ++a)
  {
    ApplyColorMask(White)
    FlipScreen();
    Delay(100);
    ApplyColorMask(Black)
    FlipScreen();
  }
}

function testing()
{ /*
  var img = new Object();
  //img.surface=GrabImage(0,0,200,200);
  img.surface=CreateSurface(200,200);
  img.surface.clone();
  img.surface.blit(50,50);
  FlipScreen();
  img.surface.blit(50,50);
  //img.surface.flipHorizontally();
  //Delay(1000);
  */
}

function run()
{
  battle_has_finished = true;
}

  