//******************************************************
//* jonboy_sprite.js
//******************************************************

function jonboy_sprite(CommonName, SpriteSet, X, Y, Direction, Speed) {
  // Ensure whatever is returned is an actual instance of a class
  if ( !(this instanceof jonboy_sprite) ) return new jonboy_sprite();
  var _ID = NewObjID();
  var _name = CommonName;
  var _direction = Direction;
  var _speed = Speed;
  var _X = X;
  var _Y = Y;
  var _spriteset = LoadSpriteset(SpriteSet);
  var _rectX1 = _spriteset.base.x1;
  var _rectX2 = _spriteset.base.x2;
  var _rectY1 = _spriteset.base.y1;
  var _rectY2 = _spriteset.base.y2;
  var _roundX = Math.round((_spriteset.base.x1+_spriteset.base.x2)/2);
  var _roundY = Math.round((_spriteset.base.y1+_spriteset.base.y2)/2);
  var _roundRadius = Math.round((_spriteset.base.y2-_spriteset.base.y1)/2);

  // READ ONLY Properties
  this.ID = _ID;
  this.name = _name;
  this.X = Math.floor(_X);
  this.Y = Math.floor(_Y);
  this.speed = _speed;
  this.direction = _direction;
  this.roundRadius = _roundRadius;
  this.rectX1 = _rectX1;
  this.rectX2 = _rectX2;
  this.rectY1 = _rectY1;
  this.rectY2 = _rectY2;
  this.roundX = _roundX;
  this.roundY = _roundY;
  this.rectX1abs = this.X + this.rectX1;
  this.rectX2abs = this.X + this.rectX2;
  this.rectY1abs = this.Y + this.rectY1;
  this.rectY2abs = this.Y + this.rectY2;

  // READ/WRITE Properties
  this.direction_set = function(arg1){_direction = arg1; this.direction = _direction;};
  this.speed_set = function(arg1){_speed = arg1; this.speed = _speed;};
  this.X_set = function(arg1){_X = Math.floor(arg1); this.X=_X;};
  this.Y_set = function(arg1){_Y = Math.floor(arg1); this.Y=_Y;};
  this.roundRadius_set = function(arg1){_roundRadius = Math.floor(arg1); this.roundRadius = _roundRadius;};

  // Functions
  
  var SectX1Y1;
  var BumpX, BumpY;
  
  this.registerinsectors = function(tempnum) {
    BumpX = false;
    BumpY = false;
    SectX = Math.floor(this.rectX1abs/ctest_sector_width);
    SectY = Math.floor(this.rectY1abs/ctest_sector_height);
    SectX1Y1 = SectX + (SectY * ctest_Xsectors);   
    // jdw(10,"Sprite #" + tempnum + ": SectX=" + SectX + " SectY=" + SectY + " SectX1Y1=" + SectX1Y1);
    ctest_sector_sprite[SectX1Y1][ctest_sector_spritecount[SectX1Y1]] = tempnum;	
    ctest_sector_spritecount[SectX1Y1]++;		
    // Check "one over"
    if (this.rectX2abs > ((SectX + 1) * ctest_sector_width)) {
      if (this.rectX2abs < CONST_VIEW_WIDTH) {
        ctest_sector_sprite[SectX1Y1+1][ctest_sector_spritecount[SectX1Y1+1]] = tempnum;	
        ctest_sector_spritecount[SectX1Y1+1]++;		
        BumpX = true;
      }
    }
    // Check "one down"
    if (this.rectY2abs > ((SectY + 1) * ctest_sector_height)) {
      if (this.rectY2abs < CONST_VIEW_HEIGHT) {
        ctest_sector_sprite[SectX1Y1+ctest_Xsectors][ctest_sector_spritecount[SectX1Y1+ctest_Xsectors]] = tempnum;	
        ctest_sector_spritecount[SectX1Y1+ctest_Xsectors]++;		
        BumpY = true;
      }
    }
    if (BumpX && BumpY) {
        ctest_sector_sprite[SectX1Y1+ctest_Xsectors+1][ctest_sector_spritecount[SectX1Y1+ctest_Xsectors+1]] = tempnum;	
        ctest_sector_spritecount[SectX1Y1+ctest_Xsectors+1]++;		    
    }
  }
  
  this.update = function(){
    var z = _speed/60;  //Oops: 60/_speed sometimes yields INFINITY!!!
    var x = z * Math.sin(_direction);
    var y = z * Math.cos(_direction);
    //jdw(10,"Calc values: x:" + x + ", y:" + y + ", z:" + z + ", direction:" + radtodegree(_direction));  
    //jdw(10,"Old values: _X:" + _X + ", _Y:" + _Y);  
    _X = _X + x;
    _Y = _Y + y;
    // "Wrap" sprites around screen
    if (_X < 0) {_X=_X + CONST_VIEW_WIDTH;}
    if (_X >= CONST_VIEW_WIDTH) {_X=_X - CONST_VIEW_WIDTH;}
    if (_Y < 0) {_Y=_Y + CONST_VIEW_HEIGHT;}
    if (_Y >= CONST_VIEW_HEIGHT) {_Y=_Y - CONST_VIEW_HEIGHT;}
    this.X = Math.floor(_X);
    this.Y = Math.floor(_Y);
    this.rectX1abs = this.X + this.rectX1;
    this.rectX2abs = this.X + this.rectX2;
    this.rectY1abs = this.Y + this.rectY1;
    this.rectY2abs = this.Y + this.rectY2;
    //jdw(10,"New values: _X:" + _X + ", _Y:" + _Y);  
  };

  this.render = function(){
//    jdw(10,"Render values: this.X:" + this.X + ", this.Y:" + this.Y);  
//    _spriteset.images[0].blit(this.X,this.Y);
    try {
      _spriteset.images[0].blit(Math.floor(_X),Math.floor(_Y));
    } catch(e) {
      jdw(1,"Error: #" + e.number + " " + e.description);
      jdw(1,"Render error _spriteset.images[0].blit(Math.floor(" + _X +  "),Math.floor(" + _Y +  "))");
    };

  }
  
}

function radtodegree(radval){
  return (radval*180/Math.PI);
}

// Returns a 12-char string representing an object ID
// (Approximately 95,428,956,661,682,176 possible combos!)
function NewObjID() {
    var NewID = "";
    var i;
    for (i=0;i<12;i++) {
      NewID = NewID + CreateStringFromCode(Math.floor(Math.random()*26) + 65);  
    }
    jdw(10,"Generated new ID:" + NewID);
    return NewID;
}