//******************************************************
//* collisiontest.js
//******************************************************

// * * * Global Variables * * *
var ctest_timebegin;
var ctest_timecollisionelapsed = 0;
var ctest_collisionsdetected = 0;
var ctest_comparisonsmade = 0;
var ctest_scount;
var ctest_totalsectors = 0;
var ctest_Xsectors = 0;
var ctest_Ysectors = 0;
ctest_spa = new Array();
ctest_sector_spritecount = new Array();
ctest_sector_sprite = new Array();
var ctest_sector_width = 0;
var ctest_sector_height = 0;
ctest_coll_raw = new Array();
ctest_coll_final = new Array();
ctest_coll_rawcount = 0;
ctest_coll_finalcount = 0;

// Called to initiate a single collision test
function CTestPerform(SWidth, SHeight, SCount, SUpdates) {
    jdw(8,"Performing Test with parms: " + SWidth + "," + SHeight + "," + SCount + "," + SUpdates);  
    // Work variables
    var i, j, randX, randY, randDir, randSpeed, randSprite;
    var timestart;
    // Set frame rate
   SetFrameRate(60);
   // Build the sectors
   ctest_sector_width = SWidth;
   ctest_sector_height = SHeight;
   ctest_buildsectors();
    // Build the sprites
    ctest_scount = SCount;
    for (i=0;i<SCount;i++) {
      randX = Math.floor(Math.random()*CONST_VIEW_WIDTH);
      randY = Math.floor(Math.random()*CONST_VIEW_HEIGHT);
      randDir = (Math.random() * Math.PI * 2) - (Math.PI);
      randSpeed = Math.floor(Math.random()*CONST_MAX_SPEED);
      switch (Math.floor(Math.random()*4)) {
        case 0: randSprite = "rock_tiny.rss"; break;
        case 1: randSprite = "rock_small.rss"; break;
        case 2: randSprite = "rock_big.rss"; break;
        default: randSprite = "rock_huge.rss"; break;
      }            
      // TESTING ONLY WITH 8 SPRITES (checks the "corners")
      //switch (i) {
      //  case 0: randX = 0; randY = 0; randSprite = "rock_tiny.rss"; break;
      //  case 1: randX = 120; randY = 90; randSprite = "rock_huge.rss"; break;
      //  case 2: randX = 250; randY = 190; randSprite = "rock_tiny.rss"; break;
      //  case 3: randX = 250; randY = 0; randSprite = "rock_tiny.rss"; break;
      //  case 4: randX = 0; randY = 190; randSprite = "rock_big.rss"; break;
      //  case 5: randX = 510; randY = 0; randSprite = "rock_tiny.rss"; break;
      //  case 6: randX = 0; randY = 380; randSprite = "rock_tiny.rss"; break;
      //  case 7: randX = 510; randY = 380; randSprite = "rock_tiny.rss"; break;
      // }
      ctest_spa[i] = new jonboy_sprite("Rock #" + i, randSprite, randX, randY, randDir, randSpeed);
      jdw(7,"Created sprite with properties: X:" + ctest_spa[i].X + ", Y:" + ctest_spa[i].Y + ", direction:" + ctest_spa[i].direction + ", speed:" + ctest_spa[i].speed );  
    }
    // Clear test variables
   ctest_collisionsdetected = 0; 
   ctest_comparisonsmade = 0;    
   ctest_timecollisionelapsed = 0;
    // Start timing collision code
    ctest_timebegin = GetTime();
    // Launch the test (control will be returned to "TestComplete" later)
    for (i=0;i<SUpdates;i++) {      
      //jdw(9,"Render round #" + i);  
     timestart = GetTime();

      // Clear sectors
      ctest_clearsectors();
      // Clear collision counter
      ctest_coll_rawcount = 0;
      // Force sprites to be registered in sectors
      // ctest_dumpsprites();
      for (j=0;j<ctest_scount;j++) {
        ctest_spa[j].registerinsectors(j);
      }    
      // ctest_dumpsectors();
      // Check each sector for collisions
      for (j=0;j<ctest_totalsectors;j++) {
        ctest_checksector(j);
      }	
      // Remove duplicates from collision queue 
      ctest_processcollisionqueue();      
      // Stop timing collision code
      ctest_timecollisionelapsed = ctest_timecollisionelapsed + (GetTime() - timestart);
      ClearScreen();
      for (j=0;j<ctest_scount;j++) {
        ctest_spa[j].update();
        ctest_spa[j].render();
      }    
      FlipScreen();
    }    
    TestComplete();
}

// Dumps a list of all sectors to the debug log
function ctest_dumpsectors(){
  var i,j;
  for (i=0;i<ctest_totalsectors;i++){
    jdw(9, "Sector #" + i + ": " + ctest_sector_spritecount[i] + " sprites total");
    for (j=0;j<ctest_sector_spritecount[i];j++){
      jdw(10, "...SectorSprite #" + j + " is really Sprite #" + ctest_sector_sprite[i][j] + "");
    }
  }
}

// Dumps a list of all sprites to the debug log
function ctest_dumpsprites(){
  var i;
  for (i=0;i<ctest_scount;i++){
    jdw(10,"Sprite #" + i + ": " + ctest_spa[i].ID + " (" + ctest_spa[i].name + ")" );
    jdw(10,"...direction:" + ctest_spa[i].direction + "  speed:" + ctest_spa[i].speed  + "  X:" + ctest_spa[i].X  + "  Y:" + ctest_spa[i].Y );
    jdw(10,"...rectX1abs:" + ctest_spa[i].rectX1abs + "  rectX2abs:" + ctest_spa[i].rectX2abs  + "  rectY1abs:" + ctest_spa[i].rectY1abs  + "  rectY2abs:" + ctest_spa[i].rectY2abs );
  }
}

// Simply set sector sprite counts to zero
// (because we don't use array lengths, this effectively clears out the sprites)
function ctest_clearsectors() {
  var i;
  for (i=0;i<ctest_totalsectors;i++) {
    ctest_sector_spritecount[i] = 0;
  }
}

// Process raw collision queue - spit out final queue
// Notify each sprite
function ctest_processcollisionqueue() {
  ctest_coll_finalcount = 0;
  ctest_coll_raw.sort();
  var i;
  var lastcoll = "";
  for (i=0;i<ctest_coll_rawcount;i++) {
    if (lastcoll == ctest_coll_raw[i]) {
      // Ignore duplicate collisions
    } else {
      ctest_coll_final[ctest_coll_finalcount] = ctest_coll_raw[i];
      ctest_coll_finalcount++;
      lastcoll = ctest_coll_raw[i];    
    }  
  }
  // Okay, now issue collisions to the various sprites
  for (i=0;i<ctest_coll_finalcount;i++) {
    collarr = ctest_coll_final[i].split("|");
    ctest_spa[collarr[0]].direction_set(bouncedir(ctest_spa[collarr[0]].direction));
    ctest_spa[collarr[1]].direction_set(bouncedir(ctest_spa[collarr[1]].direction));
  }  
}


function ctest_buildsectors() {
  ctest_Xsectors = CONST_VIEW_WIDTH/ctest_sector_width;
  ctest_Ysectors = CONST_VIEW_HEIGHT/ctest_sector_height;
  ctest_totalsectors = ctest_Xsectors * ctest_Ysectors;
  jdw(6,"Need to create " + ctest_totalsectors + " new sectors.");
  var i;
  for (i=0;i<ctest_totalsectors;i++) {
    ctest_sector_sprite[i] = new Array();
  }
  jdw(6,"Created " + ctest_totalsectors + " new sectors OK.");
//  ctest_sector_sprite[0][0] = "Frog";
//  ctest_sector_sprite[0][1] = "Dog";
//  ctest_sector_sprite[0][2] = "Bog";
//  ctest_sector_sprite[0][3] = "Log";
//  jdw(10,"Test...ctest_sector_sprite[0][2]=" + ctest_sector_sprite[0][2]);
}


// Called to check sprite collisions in this sector
function ctest_checksector(sectnum) { 
  var i,j;
//  jdw(7,"Checking for collisions in sector " + sectnum + ".");
  // Check for collisions among all sprites in the sector
  for (i=0;i<ctest_sector_spritecount[sectnum]-1;i++) {
    for (j=i+1;j<ctest_sector_spritecount[sectnum];j++){
      ctest_comparisonsmade = ctest_comparisonsmade + 1;
      if (sprites_overlap_rect(ctest_sector_sprite[sectnum][i],ctest_sector_sprite[sectnum][j])) {
        ctest_collisionsdetected = ctest_collisionsdetected + 1;
        // Simple change of course...simply "bounce" directions of sprites
        ctest_spa[ctest_sector_sprite[sectnum][i]].direction_set(bouncedir(ctest_spa[ctest_sector_sprite[sectnum][i]].direction));
        ctest_spa[ctest_sector_sprite[sectnum][j]].direction_set(bouncedir(ctest_spa[ctest_sector_sprite[sectnum][j]].direction));
      }
    }      
  }
}

// Called to try several RECTANGULAR collision tests
function ctest_rectcollisiontest(SpriteNum){
  var i;
  var timestart = GetTime();
  for (i=SpriteNum+1;i<ctest_scount;i++){
    ctest_comparisonsmade = ctest_comparisonsmade + 1;
    if (sprites_overlap_rect(SpriteNum,i)) {
      ctest_collisionsdetected = ctest_collisionsdetected + 1;
      // Simple change of course...simply "bounce" directions of sprites
      // ctest_spa[SpriteNum].direction_set(bouncedir(ctest_spa[SpriteNum].direction));
      // ctest_spa[i].direction_set(bouncedir(ctest_spa[i].direction));
      ctest_coll_raw[ctest_coll_rawcount] = SpriteNum + "|" +i;
      ctest_coll_rawcount = ctest_coll_rawcount + 1;
    }
  }
  ctest_timecollisionelapsed = ctest_timecollisionelapsed + (GetTime() - timestart);
}

// "Bounces" a direction at right angles
function bouncedir(OrigDir){
  return OrigDir + (Math.PI/2);
}

// Called to perform a RECTANGULAR collision test with two sprites
function sprites_overlap_rect(S1,S2) {
  if ((ctest_spa[S1].rectX1abs > ctest_spa[S2].rectX2abs) 
	  || (ctest_spa[S2].rectX1abs > ctest_spa[S1].rectX2abs) 
	  || (ctest_spa[S1].rectY1abs > ctest_spa[S2].rectY2abs) 
	  || (ctest_spa[S2].rectY1abs > ctest_spa[S1].rectY2abs)) {
    return false;
  } else {
    return true;
  }
}

// Called to complete a collision test
function TestComplete(){
  // Stop timing
  var ctest_timeend = GetTime();
  var ctest_delta = ctest_timeend - ctest_timebegin;
  // Log test results
  jdw(2,"Test completed in " + ctest_delta + " milliseconds");      
  jdw(3,"...collision detection performed in " + ctest_timecollisionelapsed + " milliseconds");      
  jdw(3,"...made " + ctest_comparisonsmade + " detection attempts");      
  jdw(3,"...detected " + ctest_collisionsdetected + " collisions");      
  // NEW - write out results in CSV format
  //  sprites, checks, collisions, totaltime, collisiontime
  StatLog.write("," + ctest_scount + "," + ctest_comparisonsmade + "," + ctest_collisionsdetected + "," + ctest_delta + "," + ctest_timecollisionelapsed)
}

