//******************************************************
//* jonboy_sprite.js
//******************************************************

function jonboy_sprite(CommonName, SpriteSet, X, Y, Direction, Speed) {
  // Ensure whatever is returned is an actual instance of a class
  if ( !(this instanceof jonboy_sprite) ) return new jonboy_sprite();
  var _ID = NewObjID();
  var _name = CommonName;
  var _direction = Direction;
  var _speed = Speed;
  var _X = X;
  var _Y = Y;
  var _spriteset = LoadSpriteset(SpriteSet);
  var _rectX1 = _spriteset.base.x1;
  var _rectX2 = _spriteset.base.x2;
  var _rectY1 = _spriteset.base.y1;
  var _rectY2 = _spriteset.base.y2;
  var _roundX = Math.round((_spriteset.base.x1+_spriteset.base.x2)/2);
  var _roundY = Math.round((_spriteset.base.y1+_spriteset.base.y2)/2);
  var _roundRadius = Math.round((_spriteset.base.y2-_spriteset.base.y1)/2);

  // READ ONLY Properties
  this.ID = _ID;
  this.name = _name;
  this.rectX1 = _rectX1;
  this.rectX2 = _rectX2;
  this.rectY1 = _rectY1;
  this.rectY2 = _rectY2;
  this.roundX = _roundX;
  this.roundY = _roundY;

  // READ/WRITE Properties
  this.direction_set = function(arg1){_direction = arg1; this.direction = _direction;};
  this.direction = _direction;
  this.speed_set = function(arg1){_speed = arg1; this.speed = _speed;};
  this.speed = _speed;
  this.X_set = function(arg1){_X = floor(arg1); this.X=_X;};
  this.X = Math.floor(_X);
  this.Y_set = function(arg1){_Y = floor(arg1); this.Y=_Y;};
  this.Y = Math.floor(_Y);
  this.roundRadius_set = function(arg1){_roundRadius = floor(arg1); this.roundRadius = _roundRadius;};
  this.roundRadius = _roundRadius;

  // Functions
  this.update = function(){
    // var z = 60/_speed;  - BUG!!! (May yield INFINITY!)
    var z = _speed/60;
    var x = z * Math.sin(_direction);
    var y = z * Math.cos(_direction);
    //jdw(10,"Calc values: x:" + x + ", y:" + y + ", z:" + z + ", direction:" + radtodegree(_direction));  
    //jdw(10,"Old values: _X:" + _X + ", _Y:" + _Y);  
    _X = _X + x;
    _Y = _Y + y;
    // "Wrap" sprites around screen
    if (_X < 0) {_X=_X + CONST_VIEW_WIDTH;}
    if (_X >= CONST_VIEW_WIDTH) {_X=_X - CONST_VIEW_WIDTH;}
    if (_Y < 0) {_Y=_Y + CONST_VIEW_HEIGHT;}
    if (_Y >= CONST_VIEW_HEIGHT) {_Y=_Y - CONST_VIEW_HEIGHT;}
    this.X = Math.floor(_X);
    this.Y = Math.floor(_Y);
    //jdw(10,"New values: _X:" + _X + ", _Y:" + _Y);  
  };

  this.render = function(){
//    jdw(10,"Render values: this.X:" + this.X + ", this.Y:" + this.Y);  
//    _spriteset.images[0].blit(this.X,this.Y);
    _spriteset.images[0].blit(Math.floor(_X),Math.floor(_Y));
  }
  
}

function radtodegree(radval){
  return (radval*180/Math.PI);
}

// Returns a 12-char string representing an object ID
// (Approximately 95,428,956,661,682,176 possible combos!)
function NewObjID() {
    var NewID = "";
    var i;
    for (i=0;i<12;i++) {
      NewID = NewID + CreateStringFromCode(Math.floor(Math.random()*26) + 65);  
    }
    jdw(10,"Generated new ID:" + NewID);
    return NewID;
}