//******************************************************
//* collisiontest.js
//******************************************************

// * * * Global Variables * * *
var ctest_timebegin;
var ctest_timecollisionelapsed = 0;
var ctest_collisionsdetected = 0;
var ctest_comparisonsmade = 0;
var ctest_scount;
//ctest_SOUND_COLLISION = LoadSound("punch.wav");
ctest_spa = new Array();

// Called to initiate a single collision test
function CTestPerform(SWidth, SHeight, SCount, SUpdates) {
    jdw(8,"Performing Test with parms: " + SWidth + "," + SHeight + "," + SCount + "," + SUpdates);  
    // Work variables
    var i, j, randX, randY, randDir, randSpeed, randSprite;
    // Set frame rate
   SetFrameRate(60);
    // Build the sprites
    ctest_scount = SCount;
    for (i=0;i<SCount;i++) {
      randX = Math.floor(Math.random()*CONST_VIEW_WIDTH);
      randY = Math.floor(Math.random()*CONST_VIEW_HEIGHT);
      randDir = (Math.random() * Math.PI * 2) - (Math.PI);
      randSpeed = Math.floor(Math.random()*CONST_MAX_SPEED);
      switch (Math.floor(Math.random()*4)) {
        case 0: randSprite = "rock_tiny.rss"; break;
        case 1: randSprite = "rock_small.rss"; break;
        case 2: randSprite = "rock_big.rss"; break;
        default: randSprite = "rock_huge.rss"; break;
      }            
      ctest_spa[i] = new jonboy_sprite("Rock #" + i, randSprite, randX, randY, randDir, randSpeed);
      jdw(7,"Created sprite with properties: X:" + ctest_spa[i].X + ", Y:" + ctest_spa[i].Y + ", direction:" + ctest_spa[i].direction + ", speed:" + ctest_spa[i].speed );  
    }
    // Clear test variables
   ctest_collisionsdetected = 0; 
   ctest_comparisonsmade = 0;    
   ctest_timecollisionelapsed = 0;
    // Begin timing
    ctest_timebegin = GetTime();
    // Launch the test (control will be returned to "TestComplete" later)
    for (i=0;i<SUpdates;i++) {      
      jdw(9,"Render round #" + i);  
      ClearScreen();
      for (j=0;j<ctest_scount;j++) {
        jdw(10,"Rendering sprite #" + j);
        ctest_rectcollisiontest(j);  
        ctest_spa[j].update();
        ctest_spa[j].render();
      }    
      FlipScreen();
    }    
    TestComplete();
}

// Called to try several RECTANGULAR collision tests
function ctest_rectcollisiontest(SpriteNum){
  var i;
  var timestart = GetTime();
  for (i=SpriteNum+1;i<ctest_scount;i++){
    ctest_comparisonsmade = ctest_comparisonsmade + 1;
    if (sprites_overlap_rect(SpriteNum,i)) {
      // ctest_SOUND_COLLISION.play(false);
      ctest_collisionsdetected = ctest_collisionsdetected + 1;
      // Simple change of course...simply "bounce" directions of sprites
      ctest_spa[SpriteNum].direction_set(bouncedir(ctest_spa[SpriteNum].direction));
      ctest_spa[i].direction_set(bouncedir(ctest_spa[i].direction));
    }
  }
  ctest_timecollisionelapsed = ctest_timecollisionelapsed + (GetTime() - timestart);
}

// "Bounces" a direction at right angles
function bouncedir(OrigDir){
  return OrigDir + (Math.PI/2);
}

// Called to perform a RECTANGULAR collision test with two sprites
function sprites_overlap_rect(S1,S2) {
  jdw(10,"Comparing sprites #" + S1 + " and #" + S2);
  var S1X1 = ctest_spa[S1].X + ctest_spa[S1].rectX1;
  var S1X2 = ctest_spa[S1].X + ctest_spa[S1].rectX2;
  var S2X1 = ctest_spa[S2].X + ctest_spa[S2].rectX1;
  var S2X2 = ctest_spa[S2].X + ctest_spa[S2].rectX2;
  var S1Y1 = ctest_spa[S1].Y + ctest_spa[S1].rectY1;
  var S1Y2 = ctest_spa[S1].Y + ctest_spa[S1].rectY2;
  var S2Y1 = ctest_spa[S2].Y + ctest_spa[S2].rectY1;
  var S2Y2 = ctest_spa[S2].Y + ctest_spa[S2].rectY2;
  jdw(10,"Sprite #" + S1 + " X1:" + S1X1 + " X2:" + S1X2 + " Y1:" + S1Y1 + " Y2:" + S1Y2);
  jdw(10,"Sprite #" + S2 + " X1:" + S2X1 + " X2:" + S2X2 + " Y1:" + S2Y1 + " Y2:" + S2Y2);
  // Perform simple bounds test
  if ((S1X1 > S2X2) || (S2X1 > S1X2) || (S1Y1 > S2Y2) || (S2Y1 > S1Y2)) {
    return false;
  } else {
    jdw(10,"* DETECTED COLLISION *");
    return true;
  }
}

// Called to complete a collision test
function TestComplete(){
  // Stop timing
  var ctest_timeend = GetTime();
  var ctest_delta = ctest_timeend - ctest_timebegin;
  // Log test results
  jdw(2,"Test completed in " + ctest_delta + " milliseconds");      
  jdw(3,"...collision detection performed in " + ctest_timecollisionelapsed + " milliseconds");      
  jdw(3,"...made " + ctest_comparisonsmade + " detection attempts");      
  jdw(3,"...detected " + ctest_collisionsdetected + " collisions");      
}
