max_levels = 40;
maps = new Array()
for (var i=0;i<max_levels;i++)
{
	maps[i] = Object();
	maps[i].name = 'level'+i+'.rmp';
	maps[i].left = undefined;//1, 2, etc.
	maps[i].right = undefined;
	maps[i].up = undefined;
	maps[i].down = undefined;
  maps[i].doors = [[0, 3, 2, -1]]//[[source door number, target level, target_door, required_switch]]
}

maps[1].right = 2;
maps[1].left = 3;
maps[1].down = 6;
maps[1].up = 4;
maps[1].doors = [] 

maps[2].left = 1;
maps[2].up = 5;
maps[2].right = 11

maps[3].right = 1
maps[3].left = 10;

maps[4].right = 5;
maps[4].down = 1
maps[4].left = 8;
maps[4].up = 31

maps[5].left = 4;
maps[5].down = 2;
maps[5].right = 25;
maps[5].doors = [[1, 6, 1, 0]]

maps[6].up = 1;
maps[6].left = 7
maps[6].doors = [[1, 5, 1,0], [2, 14, 1, -2]]

maps[7].right = 6;;

maps[8].right = 4;
maps[8].left = 9;
 
maps[9].right = 8;
maps[9].down = 10;
maps[9].doors = [[1, 9, 2, 0], [2, 9, 1, 0]]

maps[10].up = 9;
maps[10].right = 3;

maps[11].right = 12;
maps[11].left = 2;
maps[11].doors = [[1, 11, 2, 0], [2, 11, 1, 5]]

maps[12].right = 13;
maps[12].left = 11;
maps[12].doors = [[1, 14, 1, 0]]

maps[13].right = 16;
maps[13].left = 12;
maps[13].down = 14;
maps[13].doors = [[1, 15, 1, 0]]

maps[14].up = 13;
maps[14].left = 15;
maps[14].doors = [[1, 12, 1, 0]]

maps[15].up = 13;
maps[15].right = 14;
maps[15].doors = [[1, 13, 1, 5]]

maps[16].left = 13;
maps[16].up = 17;

maps[17].left = 18;
maps[17].down = 16;

maps[18].right = 17;
maps[18].left = 20;
maps[18].up = 19;

maps[19].down = 18;

maps[20].right = 18;
maps[20].left = 25;
maps[20].up = 21;

maps[21].down = 20;
maps[21].up = 22;
maps[21].left = 26;

maps[22].down = 21;
maps[22].right= 23;
maps[22].left= 27

maps[23].left = 22;
maps[23].right = 24;


maps[24].left = 23;

maps[25].left = 5;
maps[25].up = 26;
maps[25].right = 20

maps[26].left = 29;
maps[26].up = 27;
maps[26].right = 21;
maps[26].down = 25;

maps[27].right = 22;
maps[27].left = 28;
maps[27].down = 26;
maps[27].doors = [[1, 30, 1, 0]]

maps[28].down = 29;
maps[28].right = 27;

maps[29].right = 26;
maps[29].up = 28;

maps[30].doors = [[1, 27, 1, 0]]
maps[30].down = 26;
maps[30].left = 28;

maps[31].down = 4;
maps[31].left = 32;
maps[31].right = 33;
maps[31].up = 35;

maps[32].right = 31;
maps[32].up = 36;

maps[33].left = 31;
maps[33].up = 34;

maps[34].left = 35;
maps[34].down = 33;

maps[35].left = 36;
maps[35].right = 34;
maps[35].down = 31

maps[36].right = 35;
maps[36].down = 32;

LAST_LEVEL = 24;

g_current_level = 0;
g_up_pressed = false;

function CheckMapTransitions()
{
	if (!IsKeyPressed(KEY_CUP))
	{
		g_up_pressed = false;
	}
	if (entities[0].x > 27*16-8)
	{
		//check for going right
		entities[0].x = 8;
		ChangeToMap(maps[g_current_level].right)
	}
	else if (entities[0].x < 8)
	{
		//check for going left
		entities[0].x = 27*16-8;
		ChangeToMap(maps[g_current_level].left)
	}
	else if (entities[0].y > 14*16-8)
	{
		//check for going down
		entities[0].y = 8;
		ChangeToMap(maps[g_current_level].down)
	}
	else if (entities[0].y < 8)
	{
		//check for going up.
		entities[0].y = 14*16-8;
		ChangeToMap(maps[g_current_level].up)
	}
	if (IsKeyPressed(KEY_CUP) && g_up_pressed == false && IsEntityOnGround(0))
	{
		g_up_pressed = true;
		//check for doors.
		DoorCheck(0);
	}
}

function DoorCheck(i)
{
	tilex = Math.floor(entities[i].x/16);
	tiley = Math.floor(entities[i].y/16);
  tile = GetTile(tilex, tiley, 0)
  if (tile >= 117 && tile <= 120)
  {

		door_num = tile-116;
		
		for (var k=0;k<maps[g_current_level].doors.length;k++)
		{
		  this_door = maps[g_current_level].doors[k]
		  
			if (this_door[0] == door_num)
			{
				//got the right door, now to see if we can go in:
				if (this_door[3] == 0 || switches[Math.abs(this_door[3])].status == Math.sign(this_door[3]))
				{
					PlaySound(0);
					ChangeToMap(this_door[1], this_door[2])
				}
				else
				{
					PlaySound(7)
					//play "locked" sound
				}
				return
			}
		}
  }
	if (g_current_level == LAST_LEVEL)
	{
		if (tile == 203 || tile == 216)
		{
			WinGame();
		
		}
	
	}
}


function ChangeToMap(map, target_door)
{
	if (g_current_level == 37)
		return;
	if (g_current_level > 1)
	{
		FadeOut();
	}
	g_current_level = map
	list = GetPersonList();
	for (var i=0;i<list.length;i++)
	{
		if (list[i] != "ent0")
		{
			DestroyPerson(list[i])
		}
	}

  blank = LoadImage("blank.png")
	ChangeMap(maps[g_current_level].name);
	for (var k=0; k< 4;k++)
	{
		SetTileImage(195+k, blank);
		SetTileImage(208+k, blank);
	}
	
	
	
	HandleLastScreen();
		
	
	CreatePerson("ent0", "mainchar.rss", true);
	SetPersonScaleFactor("ent0", 2, 2);
	SetPersonLayer("ent0", PLAYER_LAYER);
	for (var i=0;i<GetNumLayers();i++)
	{
		SetLayerScaleFactorX(i, 2);
		SetLayerScaleFactorY(i, 2);
	}
	if (target_door != undefined)
	{
		GoToTargetDoor(target_door);
	}
	UpdateSwitches();
	ProcessMapEntities();
	UpdateEntities();
	UpdateEntities();
	FadeIn();
}

function GoToTargetDoor(target_door)
{
	for (var i=0;i<GetLayerWidth(0);i++)
	{
		for (var j=0;j<GetLayerHeight(0); j++)
		{
			tile_num = GetTile(i,j,0)
			if (tile_num == 116+target_door)
			{
				entities[0].x = i*16+8
				entities[0].y = j*16+8+16
				return
			}
		}
	}
}

function SitEntitiesOnGround()
{
	for (var m=0;m<2;m++)
	{
		for (var k=0;k<max_entities;k++)
		{
			if (entities[k].active == true)
			{
				if (IsEntityOnGround(k) == false)
				{
					sy = entities[k].y
					for (var l=1;l<=8;l++)
					{
						entities[k].y = sy+l;
						if (IsEntityOnGround(k))
						{
							break;
						}
					}
					if (!IsEntityOnGround(k))
					{
						entities[k].y = sy;
					}
				}
			}
		}
	}
}


function EnsureEntity(i)
{
	list = GetPersonList()
	for (var k=0; k<list.length;k++)
	{
		if (list[k] == entities[i].name)
		{
			SetPersonScaleFactor(entities[i].name, 2, 2);
			SetPersonLayer(entities[i].name, ENTITY_LAYER);		
		
			return
		}
	}
	CreatePerson(entities[i].name, types[entities[i].type].spriteset, true)
	SetPersonScaleFactor(entities[i].name, 2, 2);
	SetPersonLayer(entities[i].name, ENTITY_LAYER);
}

function ProcessMapEntities()
{
	ResetEntities(false);

	list = GetPersonList();
	
	seen_active_entities = Object();
	for (var i=1;i<list.length;i++)
	{
		if (entities[i].active == true)
		{
			seen_active_entities[entities[i].name] = 1
		}
	}
	for (var i=0;i<list.length;i++)
	{
		//get person name and set it to
		if (list[i] != 'ent0')
		{
			if (seen_active_entities[list[i]] != 1)
			{
				
				spriteset = GetPersonSpriteset(list[i]).filename.substring(11)
				type = spriteset_to_type[spriteset]
				sx_off = types[type].sx_off;
				sy_off = types[type].sy_off;
				
				if (type == 3 && thropies_found[g_current_level] > 0)
				{
					DestroyPerson(list[i])
				}
				else
				{
				
					AddNewEntity(GetPersonX(list[i])+sx_off,GetPersonY(list[i])+sy_off,0,0, "walkeast", 0, type, list[i], spriteset, 1);
					SetPersonScaleFactor(list[i],2,2)
					SetPersonScaleFactor(list[i],2,2)
					SetPersonLayer(list[i], ENTITY_LAYER)
				}
			}
		}
	}
	if (entities[0].grab == -1)
	{
		for (var k=0;k<max_entities;k++)
		{
			entities[k].grab = -1;
			entities[k].grabbed = -1;
		}
	}
	else
	{
		for (var k=0;k<max_entities;k++)
		{
			if (entities[k].grabbed > -1)
			{
				EnsureEntity(k);
			}
		}
	}
		SitEntitiesOnGround();

}

function HandleLastScreen()
{
	if (g_current_level == LAST_LEVEL)
	{
		number = 0
		total = 0 
		for (var k in thropies_found)
		{
			if (thropies_found[k] == 1)
			{
				number+=1;
			}
			total+=1
		}
		if (number == total)
		{
			SetTile(19,6,1, 203)
			SetTile(19,7,1, 216)
		}
	}
}
