GameMouse = LoadImage("mouse.png");

function MapEditor(filename){
  var b = new Object();
  if (filename != undefined) {
    b.x = 0;
    b.y = 0;
    b.width = 20;
    b.height = 15;
    b.current_layer = 0;
    b.total_layers = 1;
    b.filename = filename;
    b.zoom_factor = 1;
    b.current_tile = 0;
    b.total_tiles = 0;
    b.tile_width = 16;
    b.tile_height = 16
    b.persons = new Array();
 }

  var done = false;
  var show_coords = true;
  var show_editing_details = true;

  var current_map = 0;
  var maps = new Array();
  if (filename != undefined)
    maps.push(b);
  
  var m1 = DefaultMenu();
  m1.preRender = function(){
    if (maps.length > 0)
    {
      UpdateMapEngine();
      RenderMap();
    }
    Rectangle(m1.x, m1.y, GetScreenWidth(), m1.getHeight(), CreateColor(200,200,200));
  }
  m1.vertical = false;
  m1.horizontal = true;
  m1.addText("File", function(){
    var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
    var m2 = DefaultMenu(16, 16);
    m2.preRender = function(){
      bg.blit(0, 0);
      Rectangle(m2.x, m2.y, m2.getWidth(), m2.getHeight(), CreateColor(200, 200, 200));
    }
    m2.addText("Open", function(){
      var file_list = new Array("field.rmp", "castle.rmp");
      var m3 = DefaultMenu(32, 32);
      var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
      m3.preRender = function(){
        bg.blit(0, 0); 
        Rectangle(m3.x, m3.y, m3.getWidth(), m3.getHeight(), CreateColor(200, 200, 200));
      }
      for (var i = 0; i < file_list.length; ++i)
      {
        m3.addText(file_list[i], function(){
          var index = maps.length;
          maps.push(new Object());
          maps[index].x = 0;
          maps[index].y = 0;
          maps[index].filename = file_list[m3.selection];
          maps[index].zoom_factor = 1;
          maps[index].width = 19;
          maps[index].height = 14;
          maps[index].current_tile = 0;
          maps[index].current_layer = 0;
          maps[index].total_layers = 0;
          maps[index].total_tiles = 0;
          maps[index].tile_width = 16;
          maps[index].tile_height = 16 
          maps[index].persons = new Array();
          current_image = index;
          m2.done = true;
          m3.done = true;
          ChangeMap(maps[index].filename);
        });
      }
      m3.execute();
    });    
    m2.addText("Close", function(){
      maps = maps.slice(0, current_map).concat(maps.slice(current_map + 1));
      m2.done = true;
    });
    m2.addText("Exit", function(){
      m2.done = true;
      m1.done = true;
      done = true;
    });
    m2.execute();
    bg.blit(0,0);
  });

  m1.addText("View", function(){
    var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
    var m2 = DefaultMenu(16, 16);
    m2.preRender = function(){
      bg.blit(0, 0);
      Rectangle(m2.x, m2.y, m2.getWidth(), m2.getHeight(), CreateColor(200, 200, 200));
    }
    if (maps.length > 0)
    {
      for (var i = 0; i < maps[current_map].total_layers; ++i)
      {
        m2.addText("Toggle layer " + i, function(){
          SetLayerLayerVisible(!IsLayerVisible(m2.selection));
          m2.done = true;
        });
      }
      m2.addText("Show coords", function(){
        show_coords = !show_coords;
        m2.done = true;
      });
      m2.addText("Show editing details", function(){
        show_editing_details = !show_editing_details;
        m2.done = true;
      });
    }
    if (m2.items.length > 0)
      m2.execute();
  });


  m1.addText("Window", function(){
    var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
    var m2 = DefaultMenu(16, 16);
    m2.preRender = function(){
      bg.blit(0, 0);
      Rectangle(m2.x, m2.y, m2.getWidth(), m2.getHeight(), CreateColor(200, 200, 200));
    }
    for (var i = 0; i < maps.length; ++i)
    {
      m2.addText("window " + i, function(){
        current_map = m2.selection;
        m2.done = true;
        ChangeMap(maps[current_map].filename);
      });
    }
    if (m2.items.length > 0)
      m2.execute();
  });

  m1.addText("About", function()
  {
    var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
    var text = "Flik's Ingame Editor\n\nPress Any Key...";
    var width = 70;
    var x = GetScreenWidth() / 2 - width / 2;
    var y = GetScreenHeight() / 2 - GetSystemFont().getStringHeight(text, width) / 2;
    var height = GetSystemFont().getStringHeight(text, 70);
    Rectangle(x, y, width, height, CreateColor(200, 200, 200)); 
    GetSystemFont().drawTextBox(x, y, width, height, 0, text);
    FlipScreen();
    Wait();
    bg.blit(0,0);
  });

  while (!done)
  {
    m1.preRender();

    for (var i = 0; i < maps.length; ++i)
    {
      if(IsMouseOver(maps[i].x, maps[i].y, (maps[i].width * maps[i].tile_width) * maps[i].zoom_factor, (maps[i].height * maps[i].tile_height) * maps[i].zoom_factor))
      {
        var x = GetMouseXRelevantToMap(maps[i].x, maps[i].width * maps[i].tile_width,  maps[i].zoom_factor);
        var y = GetMouseYRelevantToMap(maps[i].y, maps[i].height * maps[i].tile_height, maps[i].zoom_factor);

        if (i == current_map)
        {
          maps[current_map].persons = GetPersonList();
          if (show_coords)
          {
            var text = "x: " + Math.floor(x / maps[i].tile_width) + " || " + x + "\ny: " + Math.floor(y / maps[i].tile_height) + " || " + y;
            var tx = GetScreenWidth() - 120;
            var ty = GetScreenHeight() - 48;
            var twidth = 100;
            var theight = GetSystemFont().getHeight() * 2;
            GetSystemWindowStyle().drawWindow(tx, ty, twidth, theight);
            GetSystemFont().drawTextBox(tx, ty, twidth, theight, 0, text);
          }

          if (show_editing_details)
          {
            var text = "current layer: " + maps[current_map].current_layer + " / " + maps[current_map].total_layers + "\ncurrent tile: " + maps[current_map].current_tile + " / " + maps[current_map].total_tiles;
            var tx = GetScreenWidth() - 295;
            var ty = GetScreenHeight() - 48;
            var twidth = 150;
            var theight = GetSystemFont().getHeight() * 2;
            GetSystemWindowStyle().drawWindow(tx, ty, twidth, theight);
            GetSystemFont().drawTextBox(tx, ty, twidth, theight, 0, text);
          }

          var mouse_over_person = false;
          for (var j = 0; j < maps[current_map].persons.length; ++j)
          {
            if(IsMouseOver(GetPersonX(maps[current_map].persons[j]),  GetPersonY(maps[current_map].persons[j]), 16, 32))
            {
              mouse_over_person = true;
              var x = GetPersonX(maps[current_map].persons[j]);
              var y = GetPersonY(maps[current_map].persons[j]);
              GetSystemWindowStyle().drawWindow(x, y, GetGameFont().getStringWidth(maps[current_map].persons[j]), GetGameFont().getHeight());
              GetSystemFont().drawText(x, y, maps[current_map].persons[j]);
              break;
            }
          }        

          if (!mouse_over_person)
          {
            if (IsMouseButtonPressed(MOUSE_LEFT))
              SetTile(Math.floor(x / maps[i].tile_width), Math.floor(y / maps[i].tile_height), maps[current_map].current_layer, maps[current_map].current_tile);
            else
             if (IsMouseButtonPressed(MOUSE_RIGHT)) {
               maps[current_map].current_tile =  GetTile(Math.floor(x / maps[i].tile_width), Math.floor(y / maps[i].tile_height), maps[current_map].current_layer);
             }
          }
        }
      }
    }

    if (maps.length > 0)
    {
      //if (IsKeyPressed(KEY_LEFT))
      //  maps[current_map].x -= 1;
      //if (IsKeyPressed(KEY_RIGHT))
      //  maps[current_map].x += 1;
      //if (IsKeyPressed(KEY_UP))
      //  maps[current_map].y += 1;
      //if (IsKeyPressed(KEY_DOWN))
      //  maps[current_map].y -= 1;
      //if (IsKeyPressed(KEY_EQUALS))
      //  maps[current_map].zoom_factor += 0.1;
      //if (IsKeyPressed(KEY_MINUS))
      //  maps[current_map].zoom_factor -= 0.1;

    }
    if (BiosKeyPressed(KEY_ESCAPE))
      done = true;

    m1.go();
    GetGameMouse().blit(GetMouseX(), GetMouseY());
    FlipScreen();
  }

}

function IsMouseOver(x, y, width, height)
{
  if (GetMouseX() >= x && GetMouseX() < x + width)
  if (GetMouseY() >= y && GetMouseY() < y + height)
    return true;
  return false;
}



function GetMouseXRelevantToMap(map_x, map_width, zoom_factor)
{
  var x = GetMouseX();
  x -= map_x;
  x /= zoom_factor;
  x = Math.round(x);
  return x;
}

function GetMouseYRelevantToMap(map_y, map_height, zoom_factor)
{
  var y = GetMouseY();
  y -= map_y;
  y /= zoom_factor;
  y = Math.round(y);
  return y;
}
