GameMouse = LoadImage("mouse.png");

function SurfaceEditor(image){
  var b = new Object();
  if (image != undefined) {
    b.x = 64;
    b.y = 48;
    b.image = image;
    b.zoom_factor = 8;
  }
  var c = LoadSurface("colors.png");

  var done = false;
  var current_color = CreateColor(255, 255, 255, 255);
  var tmp_color = CreateColor(0,0,0,0);

  var current_image = 0;
  var images = new Array();
  if (image != undefined)
    images.push(b);
  
  var c_x = 1;
  var c_y = 20;

  var a_x = c_x + c.width + 2;
  var a_y = 22;
  var a_height = GetScreenHeight() - 34;
  var a_width = 8;


  var m1 = DefaultMenu();
  m1.preRender = function(){
    Rectangle(m1.x, m1.y, GetScreenWidth(), m1.getHeight(), CreateColor(200,200,200));
  }
  m1.vertical = false;
  m1.horizontal = true;
  m1.addText("File", function(){
    var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
    var m2 = DefaultMenu(16, 16);
    m2.preRender = function(){
      bg.blit(0, 0); 
      Rectangle(m2.x, m2.y, m2.getWidth(), m2.getHeight(), CreateColor(200, 200, 200));
    }
    m2.addText("Open", function(){
      var file_list = new Array("moogle.png", "mouse.png", "title.png", "colors.png");
      var m3 = DefaultMenu(32, 32);
      var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
      m3.preRender = function(){
        bg.blit(0, 0); 
        Rectangle(m3.x, m3.y, m3.getWidth(), m3.getHeight(), CreateColor(200, 200, 200));
      }
      for (var i = 0; i < file_list.length; ++i){
        m3.addText(file_list[i], function(){
          var index = images.length;
          images.push(new Object());
          images[index].x = 64;
          images[index].y = 48;
          images[index].image = LoadSurface(file_list[m3.selection]);
          images[index].zoom_factor = 1;
          current_image = index;
          m2.done = true;
          m3.done = true;
        });
      }
      m3.execute();
    });
    m2.addText("Close", function(){
      // remove current_image from the array
      images = images.slice(0, current_image).concat(images.slice(current_image + 1));
      current_image = 0;
      m2.done = true;
    });
    m2.addText("Exit", function(){
      done = true;
      m2.done = true;
    });
    m2.execute();
    bg.blit(0,0);
  });

  m1.addText("Edit", function(){
    var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
    var m2 = DefaultMenu(16, 16);
    m2.preRender = function(){
      bg.blit(0, 0);
      Rectangle(m2.x, m2.y, m2.getWidth(), m2.getHeight(), CreateColor(200, 200, 200));
    }
    if (images.length > 0)
    {
      m2.addText("Flip", function(){
        var m3 = DefaultMenu(32, 32);
        var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
        m3.preRender = function(){
          bg.blit(0, 0);
          Rectangle(m3.x, m3.y, m3.getWidth(), m3.getHeight(), CreateColor(200, 200, 200));
        }
        m3.addText("Horizontally", function()
        {
          images[current_image].image.flipHorizontally();
          m2.done = true;
          m3.done = true;
        });
        m3.addText("Vertically", function()
        {
          images[current_image].image.flipVertically();
          m2.done = true;
          m3.done = true;
        });
        m3.execute();
      });
    }
    if (m2.items.length > 0)
      m2.execute();
  });


  m1.addText("View", function(){
    var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
    var m2 = DefaultMenu(16, 16);
    m2.preRender = function(){
      bg.blit(0, 0);
      Rectangle(m2.x, m2.y, m2.getWidth(), m2.getHeight(), CreateColor(200, 200, 200));
    }
    if (images.length > 0)
    {
      m2.addText("Zoom in", function(){
        images[current_image].zoom_factor += 0.5;
        m2.done = true;
      });
      m2.addText("Zoom out", function(){
        images[current_image].zoom_factor -= 0.5;
        m2.done = true;
      });
      m2.addText("Image Info", function(){
        var text = images[current_image].image.width + " by " + images[current_image].image.height + " pixels.";
        Rectangle(64, 64, 100, GetSystemFont().getStringHeight(text, 100), CreateColor(200, 200, 200));
        GetSystemFont().drawTextBox(64, 64, 100, GetSystemFont().getStringHeight(text, 100), 0, text);
        FlipScreen();
        Wait();
        m2.done = true;
      });
    }
    if (m2.items.length > 0)
      m2.execute();
  });
  m1.addText("Window", function(){
    var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
    var m2 = DefaultMenu(16, 16);
    m2.preRender = function(){
      bg.blit(0, 0);
      Rectangle(m2.x, m2.y, m2.getWidth(), m2.getHeight(), CreateColor(200, 200, 200));
    }
    for (var i = 0; i < images.length; ++i)
    {
      m2.addText("window " + i, function(){
        current_image = m2.selection;
        m2.done = true;
      });
    }
    if (m2.items.length > 0)
      m2.execute();
  });
  m1.addText("About", function()
  {
    var bg = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
    var text = "Flik's Ingame Editor\n\nPress Any Key...";
    var width = 70;
    var x = GetScreenWidth() / 2 - width / 2;
    var y = GetScreenHeight() / 2 - GetSystemFont().getStringHeight(text, width) / 2;
    var height = GetSystemFont().getStringHeight(text, 70);
    Rectangle(x, y, width, height, CreateColor(200, 200, 200)); 
    GetSystemFont().drawTextBox(x, y, width, height, 0, text);
    FlipScreen();
    Wait();
    bg.blit(0,0);
  });

  while (!done) {
    c.blit(c_x, c_y);

    if(IsMouseOver(c_x, c_y, c.width, c.height))
    {
      var x = GetMouseXRelevantToImage(c_x, c.width, 1);
      var y = GetMouseYRelevantToImage(c_y, c.height, 1);
      var tmp_alpha = current_color.alpha;

      tmp_color = c.getPixel(x, y);
      if (IsMouseButtonPressed(MOUSE_LEFT))
      {
        current_color = tmp_color;
        current_color.alpha = tmp_alpha;
      }
      DrawColorInfo(165, 160, tmp_color);
    }

    for (var i = 0; i < images.length; ++i)
    {
      images[i].image.createImage().zoomBlit(images[i].x, images[i].y, images[i].zoom_factor);
      if(IsMouseOver(images[i].x, images[i].y, images[i].image.width * images[i].zoom_factor, images[i].image.height * images[i].zoom_factor))
      {
        var x = GetMouseXRelevantToImage(images[i].x, images[i].image.width,  images[i].zoom_factor);
        var y = GetMouseYRelevantToImage(images[i].y, images[i].image.height, images[i].zoom_factor);
        if (i == current_image)
        {
          GetSystemFont().drawTextBox(GetScreenWidth() - 70, GetScreenHeight() - 25, 70, 70, 0, "x: " + x + "\ny: " + y);
        
          if (IsMouseButtonPressed(MOUSE_LEFT))
            images[current_image].image.setPixel(x, y, current_color);
        }
      }
    }

    if(IsMouseOver(a_x, a_y, a_width, a_height))
    {
      var y = GetMouseYRelevantToImage(a_y, a_height, 1);
      GetSystemFont().drawText(240, 140, "Alpha: " + y);
      if (IsMouseButtonPressed(MOUSE_LEFT))
        current_color.alpha = y * 256 / a_height;
    }

    if (images.length > 0)
    {
      if (IsKeyPressed(KEY_LEFT))
        images[current_image].x -= 1;
      if (IsKeyPressed(KEY_RIGHT))
        images[current_image].x += 1;
      if (IsKeyPressed(KEY_UP))
        images[current_image].y += 1;
      if (IsKeyPressed(KEY_DOWN))
        images[current_image].y -= 1;
      if (IsKeyPressed(KEY_EQUALS))
        images[current_image].zoom_factor += 0.1;
      if (IsKeyPressed(KEY_MINUS))
        images[current_image].zoom_factor -= 0.1;    
    }
    if (BiosKeyPressed(KEY_ESCAPE))
      done = true;

    Rectangle(c_x + 1,  c_y + c.height + 1, 20, 20, current_color);
    Rectangle(c_x + 22, c_y + c.height + 1, 20, 20, tmp_color);

    Rectangle(a_x, a_y, a_width, a_height, CreateColor(150, 150, 150));
    Rectangle(a_x + 2, a_y, a_width - 4, current_color.alpha / 256 * a_height, CreateColor(255, 255, 255));

    DrawColorInfo(240, 160, current_color);

    m1.preRender();
    m1.go();
    GetGameMouse().blit(GetMouseX(), GetMouseY());

    FlipScreen();
  }
}

function CreateSurfaceFromImage(image)
{
  var a = CreateSurface(image.width, image.height, CreateColor(255,255,255));
  a.setPixel(0,0, CreateColor(255, 0, 255));
  a.setPixel(10,10, CreateColor(255, 0, 255));
  a.setPixel(3,3, CreateColor(255, 0, 255));
  a.setPixel(14,4, CreateColor(255, 0, 255));
  return a;
}

function IsMouseOver(x, y, width, height)
{
  if (GetMouseX() >= x && GetMouseX() < x + width)
  if (GetMouseY() >= y && GetMouseY() < y + height)
    return true;
  return false;
}

function DrawColorInfo(x, y, color)
{
  var color_info = "";
  with (color) {
     color_info = "red: " + red + "\ngreen: " + green + "\nblue: " + blue + "\nalpha: " + alpha;
  }
  var width = 70;
  var height = GetSystemFont().getStringHeight(color_info, width);

  Rectangle(x, y, width, height, CreateColor(200, 200, 200));
  GetSystemFont().drawTextBox(x, y, width, height, 0, color_info);
}

function GetMouseXRelevantToImage(image_x, image_width, zoom_factor)
{
  var x = GetMouseX();
  x -= image_x;
  x /= zoom_factor;
  x = Math.round(x);
  return x;
}

function GetMouseYRelevantToImage(image_y, image_height, zoom_factor)
{
  var y = GetMouseY();
  y -= image_y;
  y /= zoom_factor;
  y = Math.round(y);
  return y;
}
