//////////////////////////////////////////////

var GameWindowStyle = GetSystemWindowStyle();
var GameMouseStatus = true;
var GameMouse = CreateSurface(10,10, CreateColor(255,255,255));
var GameFont = GetSystemFont();
var GameArrow = GetSystemArrow();

var ActiveColor = CreateColor(0, 255, 255);
var NonactiveColor = CreateColor(255, 255, 255);

var GameActionKey = KEY_ENTER;
var GameMenuKey = KEY_S;
var GameTalkKey = KEY_SHIFT;
var GameUpKey = KEY_UP;
var GameRightKey = KEY_RIGHT;
var GameDownKey = KEY_DOWN;
var GameLeftKey = KEY_LEFT;
var GameEscapeKey = KEY_ESCAPE;

//////////////////////////////////////////////

function GetGameFont(){
  if(GameFont == undefined)
    return (GameFont = GetSystemFont());
  else
    return GameFont;
}

function GetGameWindowStyle(){
  if(GameWindowStyle == undefined)
    return (GameWindowStyle = GetSystemWindowStyle());
  else
    return GameWindowStyle;
}

function GetGameArrow(){
  if(GameArrow == undefined)
    return (GameArrow = GetSystemArrow());
  else
    return GameArrow;
}

function GetGameFont(){
  if(GameFont == undefined)
    return (GameFont = GetSystemFont());
  else
    return GameFont;
}

function GetGameWindowStyle(){
  if(GameWindowStyle == undefined)
    return (GameWindowStyle = GetSystemWindowStyle());
  else
    return GameWindowStyle;
}

function GetGameMouse(){
  if(GameMouse == undefined)
    return (GameMouse = CreateSurface(10,10, CreateColor(255,255,255)));
  else
    return GameMouse;
}

//////////////////////////////////////////////

function ClearKeyQueue()
{
  while(AreKeysLeft())
    GetKey();
}

function Wait()
{
  ClearKeyQueue(); 
  return GetKey();
}

function Delay(ms)
{
  var until = GetTime() + ms;
  while(GetTime() < until){}
}

function Debug(txt, ms, key)
{
  GrabImage(0,0, GetScreenWidth(), GetScreenHeight()).blit(0,0);
  GetSystemFont().drawTextBox(0,0,GetScreenWidth(),GetScreenHeight(),0, txt);
  FlipScreen();

  if(ms)
    Delay(ms);
  else
    Wait();
}

function BiosKeyPressed(key)
{
  if(AreKeysLeft() && IsKeyPressed(key))
    return true;
  return false;
}

/////////////////////////////////////////

function DefaultMenu(x,y, width, height) // please customise/override this for your games
{
  var menu = new Menu(x, y, width, height);
  menu.defaultMouseSupport(GameMouseStatus, GetGameMouse(), true);
  menu.preRender = function(){
    if (menu.background)
      menu.background.blit(0,0);
    GetGameWindowStyle().drawWindow(menu.x, menu.y, menu.getWidth(), menu.getHeight());
  }
  menu.escapeable = function(){ return true; }
  return menu;
}

/////////////////////////////////////////

function Menu(x,y, width, height)
{
  this.x = x != undefined ? x : 0;
  this.y = y != undefined ? y : 0;
  this.width = width != undefined ? width : GetScreenWidth() - this.x;
  this.height = height != undefined ? height : GetScreenHeight() - this.y;

  this.items = new Array();
  this.escapeable = function(){ return false; }
  ref = this;
  this.escape_function = function(){ ref.done = true; }

  this.done = false;
  this.keys = new Array();
  
  this.mouseSupport = false;
  this.mouseButtons = new Array();
  this.mouse = GetSystemArrow();

  this.selection = 0;
  this.cutOffWidth = true;
  this.cutOffHeight = true;
  this.smooth_scrolling = false;
  
  this.horizontal = false;
  this.vertical = true;

  this.selectionArray = new Array();
  this.multiselection = false;

  this.mouseX = GetMouseX();
  this.mouseY = GetMouseY();

  this.lastMenuItemReturnValue = undefined;
  this.shown_items = new Array();
}


Menu.prototype.addKey = function(KEY, action, delay)
{
  var FoundKey = false;
  if(delay == undefined)
    delay = 200;

  for(var i = 0; i < this.keys.length; ++i)
  {
    if(this.keys[i].name == KEY)
    {
      this.keys[i].action = action;
      this.keys[i].delay = delay;
      FoundKey = true; 
    }
  }

  if(!FoundKey)
  {
    this.keys[this.keys.length] = new Object();
    this.keys[this.keys.length - 1].name = KEY;
    this.keys[this.keys.length - 1].action = action;
    this.keys[this.keys.length - 1].delay = delay;
    this.keys[this.keys.length - 1].lastPressed = GetTime();
  }
}


Menu.prototype.removeKey = function(KEY)
{
  for(var i = 0; i < this.keys.length; ++i)
  {
    if(this.keys[i].name == KEY)
    {
      this.keys[i] = this.keys.slice(0, i).concat(this.keys.slice(i+1, this.keys.length));
    }
  }
}


Menu.prototype.addMouseButton = function(BUTTON, action, delay)
{
  this.mouseButtons[this.mouseButtons.length] = new Object();
  this.mouseButtons[this.mouseButtons.length - 1].name = BUTTON;
  this.mouseButtons[this.mouseButtons.length - 1].action = action;
  if(delay == undefined) delay = 200;
  this.mouseButtons[this.mouseButtons.length - 1].delay = delay;
  this.mouseButtons[this.mouseButtons.length - 1].lastPressed = GetTime();
}


Menu.prototype.addDefaultKeys = function(up, down, select, escape)
{
  var ref = this;
  if(up == undefined) up = GameUpKey;
  if(down == undefined) down = GameDownKey;
  if(select == undefined) select = GameActionKey;
  if(escape == undefined) escape = GameEscapeKey;

  this.addKey(up, function()
  {
    if(BiosKeyPressed(up))
      ref.selection -= 1;
  });

  this.addKey(down, function()
  {   
    if(BiosKeyPressed(down))
      ref.selection +=1;
  });

  this.addKey(select, function()
  {   
    if(BiosKeyPressed(select))
    {
      ref.handleSelection();
      ref.lastMenuItemReturnValue = ref.items[ref.selection].onSelection();
    }
  });

  this.addKey(escape, function()
  {   
    if(BiosKeyPressed(escape))
    {
      if(ref.escapeable())
      {
        ref.done = true;
        ref.lastMenuItemReturnValue = ref.escape_function();
      }
    }
  });
}


Menu.prototype.addDefaultMouseButtons = function()
{
  this.addMouseButton(MOUSE_LEFT, function()
  {   
    if(IsMouseButtonPressed(MOUSE_LEFT))
    {
      if(this.lastPressed + this.delay < GetTime()){
        ref.lastMenuItemReturnValue = ref.items[ref.selection].onSelection();
        this.lastPressed = GetTime();
      }
    }
  });
}


Menu.prototype.add = function(x, y, item,  w, h, drawMethod, highLightMethod, isSelectable, onSelection)
{
  this.items[this.items.length] = new Object();
  this.items[this.items.length - 1].x = x;
  this.items[this.items.length - 1].y = y;
  this.items[this.items.length - 1].item = item;
  this.items[this.items.length - 1].width = w;
  this.items[this.items.length - 1].height = h;
  this.items[this.items.length - 1].drawMethod = drawMethod;
  this.items[this.items.length - 1].highLightMethod = highLightMethod;
  this.items[this.items.length - 1].isSelectable = isSelectable;
  this.items[this.items.length - 1].onSelection = onSelection;
}


Menu.prototype.handleSelection = function()
{
  if(this.selection > this.items.length - 1)
    this.selection = 0;
      
  if(this.selection < 0)
    this.selection = this.items.length - 1;
}


Menu.prototype.draw = function(x,y,w,h)
{
  x = x != undefined ? x : this.x;
  y = y != undefined ? y : this.y;

  if(w == undefined)
    w = this.width;
  if(h == undefined)
    h = this.height;

  this.shown_items = new Array();
  this.handleSelection();

  for(var i = 0; i < this.items.length; ++i)
  {  
    var selected = false;
  
    if(this.multiselection)
    {
      if(this.selectionArray.length > 0)
      for(var j = 0; j < this.selectionArray.length; ++j)
      {
        if(this.selectionArray[j] == i || this.selection == i)
        {
          selected = true;
          break;
        }
      }
      else
        { if(this.selection == i) selected = true; }
    }
    else
      if(i == this.selection) selected  = true;

    if(selected)
    {
      if(this.items[i].x >= x && (!this.cutOffWidth || this.items[i].x + this.items[i].width <= x + w))
      {
        if(this.items[i].y >= y && (!this.cutOffHeight || this.items[i].y + this.items[i].height <= y + h))
        {
          this.shown_items.push(i);
          this.items[i].highLightMethod();
        }
        else
          if(this.selection == i)
            this.whenOffScreen();
      }
      else
       if(this.selection == i)  
         this.whenOffScreen();
      
    }
    else
    {
      if(this.items[i].x >= x && (!this.cutOffWidth || this.items[i].x + this.items[i].width <= x + w))
      {
        if(this.items[i].y >= y && (!this.cutOffHeight || this.items[i].y + this.items[i].height <= y + h))
        {
          this.shown_items.push(i);
          this.items[i].drawMethod();
        }
      }
    }
  }

}


Menu.prototype.preRender = function()
{

}


Menu.prototype.handleKeys = function()
{
  if(this.keys.length == 0)
    this.addDefaultKeys();

  for(var i = 0; i < this.keys.length; ++i)
  {
    if(BiosKeyPressed(this.keys[i].name))
    {
      this.keys[i].action();
    }
  }

  this.handleSelection();

  ClearKeyQueue();
}


Menu.prototype.handleMouse = function(x,y,w,h)
{
  x = x != undefined ? x : this.x;
  y = y != undefined ? y : this.y;
  
  if(w == undefined)
    w = this.width;
  if(h == undefined)
    h = this.height;

  if(this.mouseSupport)
  {
    var hovering = false;
    var mouseMoved = false;
    var mouseOverItem = 0;

    if(this.mouseX != GetMouseX() || this.mouseY != GetMouseY())
    {
      this.mouseX = GetMouseX();
      this.mouseY = GetMouseY();
      mouseMoved = true;  
    } // if mouse moved...

    if(false)
    {
      if(GetMouseX() < x || GetMouseY() < y)
        mouseMoved = false;
      if(GetMouseX() > x + w || GetMouseY() > y + h)
        mouseMoved = false;
    }
    
    // check items to see if mouse is hovering, set MouseOverItem = selection
    for(var i = 0; i < this.items.length; ++i)
    {
      if(GetMouseX() > this.items[i].x && GetMouseX() < this.items[i].x + this.items[i].width)
      {
        if(GetMouseY() > this.items[i].y && GetMouseY() < this.items[i].y + this.items[i].height)
        {
          if(mouseMoved)
            this.selection = i;
          mouseOverItem = i;
          hovering = true;
        }
      }
    }

    if(hovering)
    {
      for(var i = 0; i < this.mouseButtons.length; ++i)
      {
        if(IsMouseButtonPressed(this.mouseButtons[i].name))
        {
          this.selection = mouseOverItem;
          this.mouseButtons[i].action();
        }
      }
    }

    this.mouse.blit(GetMouseX(), GetMouseY());
  }
}


Menu.prototype.postRender = function()
{

}


Menu.prototype.go = function(x,y,w,h,selection)
{
  if(x == undefined) x = this.x;
  if(y == undefined) y = this.y;
  if(w == undefined) w = this.width;
  if(h == undefined) h = this.height;
  if(selection == undefined) selection = this.selection;

  if(!this.done)
  {
    this.draw(x,y,w,h);
    this.handleKeys();
    this.handleMouse(x,y,w,h);
  }
}


Menu.prototype.execute = function(x,y,w,h)
{
  if(x == undefined) x = this.x;
  if(y == undefined) y = this.y;
  if(w == undefined) w = this.width;
  if(h == undefined) h = this.height;

  ClearKeyQueue();

  while(!this.done)
  {
    this.preRender();
    this.draw(x,y,w,h);
    this.postRender();

    this.handleKeys();
    this.handleMouse(x,y,w,h);

    FlipScreen();
  }
  return this.lastMenuItemReturnValue;
}


Menu.prototype.whenOffScreen = function()
{
  // move down
  if(this.items[this.selection].y + this.items[this.selection].height > this.y + this.height)
     for(var i = 0; i < this.items.length; ++i)
       if (this.smooth_scrolling)
         this.items[i].y -= 1;
       else
         this.items[i].y -= this.items[i].height;

  // move up    
  if(this.items[this.selection].y < this.y)
    for(var i = 0; i < this.items.length; ++i)
      if (this.smooth_scrolling)
        this.items[i].y +=  1;
      else
         this.items[i].y += this.items[i].height;

  // move right
  if(this.items[this.selection].x + this.items[this.selection].width > this.x + this.width)
    for(var i = 0; i < this.items.length; ++i)
      if (this.smooth_scrolling)
        this.items[i].x -=  1;
      else
         this.items[i].x -= this.items[i].width;

  // move left
  if(this.items[this.selection].x < this.x)
    for(var i = 0; i < this.items.length; ++i)
      if (this.smooth_scrolling)
        this.items[i].x +=  1;
      else
         this.items[i].x += this.items[i].width;
}

Menu.prototype.getNextX = function()
{
  var x = this.x;
  if(this.items.length > 0)
  {
    x = this.items[this.items.length - 1].x;

    if (this.horizontal)
      x += this.items[this.items.length - 1].width;
  }
  return x;
}

Menu.prototype.getNextY = function()
{
  var y = this.y;
  if(this.items.length > 0)
  {
    y = this.items[this.items.length - 1].y;

    if (this.vertical)
      y += this.items[this.items.length - 1].height;
  }
  return y;
}


///////////////////////////////////////////////////////////////

// EXTENSION METHODS

///////////////////////////////////////////////////////////////

Menu.prototype.addText = function(name, action, font, color, highlightcolor, pointer)
{
  var o = new Object();
  o.font = font ? font : GetGameFont();
  o.pointer = pointer ? pointer : GetGameArrow();
  o.color = color ? color : NonactiveColor;
  o.highlightcolor = highlightcolor ? highlightcolor : ActiveColor;
  o.name = name;
  
  var ref = this;
  var x = this.getNextX();
  var y = this.getNextY();

  this.add(x,y, o, o.pointer.width + o.font.getStringWidth(o.name), o.font.getHeight(),
  function(){ this.item.font.drawText(this.x  + this.item.pointer.width, this.y, this.item.name); },
  function(){
    o.pointer.blit(this.x, this.y);
    this.item.font.setColorMask(this.item.highlightcolor);
    this.item.font.drawText(this.x + this.item.pointer.width, this.y, this.item.name);
    this.item.font.setColorMask(this.item.color);
  }, function(){return true;}, action);
}

Menu.prototype.addTextBox = function(name, action, text_width, font, color, highlightcolor, pointer)
{
  var o = new Object();
  o.font = font ? font : GetGameFont();
  o.pointer = pointer ? pointer : GetGameArrow();
  o.color = color ? color : NonactiveColor;
  o.highlightcolor = highlightcolor ? highlightcolor : ActiveColor;
  o.name = name;
  o.text_width = text_width;

  var ref = this;
  var x = this.getNextX();
  var y = this.getNextY();

  this.add(x,y, o, o.pointer.width + o.text_width, o.font.getStringHeight(o.name, o.text_width),
  function(){ this.item.font.drawTextBox(this.x + this.item.pointer.width, this.y, this.item.text_width, this.height, 0, this.item.name); },
  function(){
    this.item.pointer.blit(this.x, this.y);
    this.item.font.setColorMask(highlightcolor);
    this.item.font.drawTextBox(this.x + this.item.pointer.width, this.y, this.width, this.height, 0, this.item.name);
    this.item.font.setColorMask(this.item.color);
  }, function(){ return true; }, action);
}


Menu.prototype.addImage = function(image, action, normaltint, highlighttint, pointer)
{
  var o = new Object();
  o.pointer = pointer ? pointer : GetGameArrow();
  o.normaltint = normaltint ? normaltint : NonactiveColor;
  o.highlighttint = highlighttint ? highlighttint : ActiveColor;
  o.image = image;

  var ref = this;
  var x = this.getNextX();
  var y = this.getNextY();
    
  this.add(x,y, o, o.pointer.width + o.image.width, o.image.height,
    function(){ this.item.image.blitMask(this.x + this.item.pointer.width, this.y, this.item.normaltint); },
    function(){
      this.item.pointer.blit(this.x, this.y);
      this.item.image.blitMask(this.x + this.item.pointer.width, this.y, this.item.highlighttint);
    }, function(){return true;}, action);
}


Menu.prototype.addSpriteset = function(spriteset, action, normaltint, highlighttint, text, font, space, pointer)
{
  pointer = pointer ? pointer : GetGameArrow();
  normaltint = normaltint ? normaltint : NonactiveColor;
  highlighttint = highlighttint ? highlighttint : ActiveColor;
  font = font ? font : GetGameFont();
  space = space ? space : 0;

  var ref = this;
  var sprite = new Object();
  sprite.spriteset = spriteset;
  sprite.text = text;
  sprite.font = font;
  sprite.frame = 0;
  sprite.direction = 0;
  sprite.lastOccurance = 0;
  sprite.delay = 80;
  
  var x = this.getNextX();
  var y = this.getNextY();
    
  this.add(x,y, sprite,
   pointer.width + sprite.spriteset.images[sprite.spriteset.directions[sprite.direction].frames[0].index].width + space + sprite.font.getStringWidth(sprite.text),
     Math.max(sprite.spriteset.images[sprite.spriteset.directions[sprite.direction].frames[0].index].height, sprite.font.getStringHeight(sprite.text, this.width)),
    function(){
      if(this.item.lastOccurance + this.item.delay <= GetTime()){
        this.item.lastOccurance = GetTime();
        if(++this.item.frame >= this.item.spriteset.directions[this.item.direction].frames.length)
          this.item.frame = 0;
      }

      this.item.spriteset.images[this.item.spriteset.directions[this.item.direction].frames[this.item.frame].index].blitMask(this.x + pointer.width, this.y, normaltint);
      if(this.item.text != undefined)
        this.item.font.drawText(this.x + pointer.width + space, this.y, this.item.text);
    },
    function(){
      if(this.item.lastOccurance + this.item.delay <= GetTime()){
        this.item.lastOccurance = GetTime();
        if(++this.item.frame >= this.item.spriteset.directions[this.item.direction].frames.length)
          this.item.frame = 0;
      }
      if(this.item.text != undefined)
      {
        this.item.font.setColorMask(highlighttint);
        this.item.font.drawText(this.x + pointer.width + space, this.y, this.item.text);
        this.item.font.setColorMask(normaltint);
      }
      
      pointer.blit(this.x, this.y);
      this.item.spriteset.images[this.item.spriteset.directions[this.item.direction].frames[this.item.frame].index].blitMask(this.x + pointer.width, this.y, highlighttint);
    }, function(){ return true; }, action);

}



Menu.prototype.addTextGradient = function(text, action, fontcolor, activefontcolor, backgroundcolor, font, pointer)
{
  var ref = this;
  var x = this.getNextX();
  var y = this.getNextY();

  var woo = new Object();
  woo.font = (font == undefined ? GetSystemFont() : font);
  woo.text = text;
  woo.fontcolor = (fontcolor == undefined ? CreateColor(255,255,255) : fontcolor);
  woo.activefontcolor = (activefontcolor == undefined ? CreateColor(0,255,255) : activefontcolor);
  woo.pointer = (pointer == undefined ? GetSystemArrow() : pointer);
  backgroundcolor = (backgroundcolor == undefined ? CreateColor(255,0,0) : backgroundcolor); 
  
  woo.fadeCounter = 0;
  woo.fadeDirection = "in";
  woo.r = backgroundcolor.red;
  woo.g = backgroundcolor.green;
  woo.b = backgroundcolor.blue;

  this.add(x, y, woo, woo.font.getStringWidth(woo.text) + woo.pointer.width, woo.font.getHeight(), function(){
    this.item.font.drawText(this.x + this.item.pointer.width, this.y, this.item.text);
  }, function(){
    GradientRectangle(this.x + this.item.pointer.width, this.y, this.item.font.getStringWidth(this.item.text), this.item.font.getHeight(), CreateColor(this.item.r, this.item.g, this.item.b, this.item.fadeCounter), CreateColor(this.item.r, this.item.g, this.item.b, -this.item.fadeCounter), CreateColor(this.item.r, this.item.g, this.item.b, -this.item.fadeCounter), CreateColor(this.item.r, this.item.g, this.item.b, this.item.fadeCounter));

    this.item.pointer.blit(this.x, this.y);
    this.item.font.setColorMask(this.item.activefontcolor);
    this.item.font.drawText(this.x + this.item.pointer.width, this.y, this.item.text);
    this.item.font.setColorMask(this.item.fontcolor);

    if(this.item.fadeDirection == "in")
      this.item.fadeCounter+=2;
    else
      this.item.fadeCounter-=2;
    if(this.item.fadeCounter > 255)
    {
      this.item.fadeDirection = "out";
      this.item.fadeCounter = 255;
    }
    if(this.item.fadeCounter < 0)
    {
      this.item.fadeDirection = "in";
      this.item.fadeCounter = 0;
    }
  }, function(){ return true; }, action);
}




Menu.prototype.addTextWindowStyle = function(text, action, fontcolor, activefontcolor, windowstyle, font, pointer)
{
  var ref = this;
  var x = this.getNextX();
  var y = this.getNextY();

  var woo = new Object();
  woo.font = (font == undefined ? GetGameFont() : font);
  woo.text = text;
  woo.fontcolor = (fontcolor == undefined ? NonactiveColor : fontcolor);
  woo.activefontcolor = (activefontcolor == undefined ? ActiveColor : activefontcolor);
  woo.pointer = (pointer == undefined ? GetGameArrow() : pointer);
  woo.windowstyle = (windowstyle == undefined ? GetGameWindowStyle() : windowstyle);
  
  this.add(x, y, woo, woo.font.getStringWidth(woo.text) + woo.pointer.width, woo.font.getHeight(), function(){
    this.item.font.drawText(this.x + this.item.pointer.width, this.y, this.item.text);
  }, function(){
    this.item.windowstyle.drawWindow(this.x, this.y, this.width, this.height);
    this.item.pointer.blit(this.x, this.y);
    this.item.font.setColorMask(this.item.activefontcolor);
    this.item.font.drawText(this.x + this.item.pointer.width, this.y, this.item.text);
    this.item.font.setColorMask(this.item.fontcolor);
  }, function(){ return true; }, action);
}


Menu.prototype.defaultMouseSupport = function(support, image, defaultbuttons)
{
  this.mouse = image;
  this.mouseSupport = support;
  if(this.mouseSupport)
    this.addDefaultMouseButtons();
}


Menu.prototype.getX = function()
{
  ref = this;
  x = ref.items[0].x;

  for(var i = 0; i < ref.items.length; ++i)
  {
    if(ref.items[i].x < x)
      x = ref.items[i].x;
  }
  return x;
}

Menu.prototype.getY = function()
{
  ref = this;
  y = ref.items[0].y;

  for(var i = 0; i < ref.items.length; ++i)
  {
    if(ref.items[i].y < y)
      y = ref.items[i].y;
  }

  return y;
}


Menu.prototype.getWidth = function()
{
  ref = this;

  x = ref.getX();
  CurrentWidth = 0;
  for(var i = 0; i < ref.items.length; ++i)
  {
    if(ref.items[i].x + ref.items[i].width - x > CurrentWidth)
    {
      CurrentWidth = ref.items[i].x + ref.items[i].width - x;
    }
  }

  return CurrentWidth;
}


Menu.prototype.getHeight = function()
{
  ref = this;

  y = ref.getY();
  CurrentHeight = 0;
  for(var i = 0; i < ref.items.length; ++i)
  {
    if(ref.items[i].y + ref.items[i].height - y > CurrentHeight)
    {
      CurrentHeight = ref.items[i].y + ref.items[i].height - y;
    }
  }

  return CurrentHeight;
}


Menu.prototype.configureKeysForRows = function(rows)
{
  ref = this;
  this.addKey(KEY_LEFT, function(){ ref.selection -= 1; });
  this.addKey(KEY_RIGHT, function(){ ref.selection += 1; });
  
  this.addKey(KEY_UP, function(){
    var OldSelection = ref.selection;
    ref.selection -= rows;
    if(ref.selection < 0)
    {
      WasInRow = (OldSelection % rows)
      TargetRow = WasInRow - 1;
      if(TargetRow == -1)
        TargetRow = rows - 1;

      NewSelection = ref.items.length;

      while(NewSelection % rows != TargetRow) 
        --NewSelection;

      ref.selection = NewSelection;
    }
  });
  
  this.addKey(KEY_DOWN, function(){
    var OldSelection = ref.selection;
    ref.selection += rows; 
    if(ref.selection > ref.items.length)
      ref.selection = (OldSelection % rows) + 1;
  });
}





Menu.prototype.addBattlePointer = function(target_list, action, pointer)
{
  var o = new Object();
  o.pointer = pointer != undefined ? pointer : GetGameArrow();
  o.target_list = target_list;

  var x = 0;
  var y = 0;
  var width = 0;
  var height = 0;

  if (target_list.length > 1) // array of targets
  {
   x = entities[target_list[0]].x;
   y = entities[target_list[0]].y;
  } 
  else // only one
  {
    x = entities[target_list[0]].x;
    y = entities[target_list[0]].y;
    width = entities[target_list[0]].width;
    height = entities[target_list[0]].height;
  }
  
  this.add(x, y, o, width, height,
  function(){  },
  function(){
    for(var j = 0; j < this.item.target_list.length; ++j)
    {
      this.item.pointer.blit(entities[this.item.target_list[j]].x - this.item.pointer.width, entities[this.item.target_list[j]].y);
    }
  }, function(){ return true; }, action);
}




Menu.prototype.init_ring_menu = function(center_x, center_y)
{
  this.angle_difference = 360 / this.items.length;
  this.radius = 50;
  this.end_angle = 0;
  this.angle = 0;
  this.perspective = 2;
  this.rotation_speed = 2;
  this.center_x = center_x;
  this.center_y = center_y;

  this.recalculate_ring_menu_positions(this.center_x, this.center_y, this.angle);

  var ref = this;

  this.postRender = function(){
    GetGameArrow().blit(ref.center_x - GetGameArrow().width, ref.center_y + ref.radius / ref.perspective);
  }


  this.addKey(KEY_UP, function()
  {
    if(BiosKeyPressed(KEY_UP))
    {
      ref.end_angle = (a.angle - 360 / a.items.length) % 360;
      ref.end_angle += 720;	// to get around that stupid wrap-around junk
      while (ref.angle < ref.end_angle) ref.angle += 360;	// x_x

      do
      {
        ref.recalculate_ring_menu_positions(ref.center_x, ref.center_y, ref.angle);
        ref.preRender();
        ref.draw();
        ref.postRender();
        FlipScreen();

        ref.angle -= ref.rotation_speed;
      } while (ref.angle > ref.end_angle);

      ref.angle = (ref.end_angle + 720) % 360;

      ref.selection -= 1;
      if (ref.selection < 0)
        ref.selection = ref.items.length - 1;
    }
  });

  ref.addKey(KEY_DOWN, function()
  {
    if(BiosKeyPressed(KEY_DOWN))
    {
      ref.end_angle = (ref.angle + 360 / ref.items.length) % 360;
      ref.end_angle += 720;
      ref.angle += 720; // to get around that stupid wrap-around junk

   	  while (ref.angle > ref.end_angle) ref.angle -= 360;	// x_x

      do
      {
        ref.recalculate_ring_menu_positions(120, 120, ref.angle);
        ref.preRender();
        ref.draw();
        ref.postRender();
        FlipScreen();

        ref.angle += ref.rotation_speed;
      } while (ref.angle < ref.end_angle);

      ref.angle = (ref.end_angle + 720) % 360;

      ref.selection += 1;
      if (ref.selection > ref.items.length - 1)
        ref.selection = 0;
    }
  });

}

Menu.prototype.recalculate_ring_menu_positions = function(center_x, center_y, theta)
{
  for (var i = 0; i < this.items.length; ++i)
  {
    theta += 90;

    this.items[i].x = this.radius * Math.cos((theta + this.angle_difference *i) * Math.PI/180);
    this.items[i].y = this.radius * Math.sin((theta + this.angle_difference *i) * Math.PI/180);
    this.items[i].y /= this.perspective;

    this.items[i].x += center_x;
    this.items[i].y += center_y;

  }
}

/*
var a = DefaultMenu(16, 16);

a.addText("1", function(){ a.done = true; }, GetGameFont(), ActiveColor, NonactiveColor, CreateSurface(0,0, CreateColor(0,0,0,0)));
a.addText("2", function(){ a.done = true; }, GetGameFont(), ActiveColor, NonactiveColor, CreateSurface(0,0, CreateColor(0,0,0,0)));
a.addText("3", function(){ a.done = true; }, GetGameFont(), ActiveColor, NonactiveColor, CreateSurface(0,0, CreateColor(0,0,0,0)));
a.addText("4", function(){ a.done = true; }, GetGameFont(), ActiveColor, NonactiveColor, CreateSurface(0,0, CreateColor(0,0,0,0)));
a.addText("5", function(){ a.done = true; }, GetGameFont(), ActiveColor, NonactiveColor, CreateSurface(0,0, CreateColor(0,0,0,0)));
a.addText("6", function(){ a.done = true; }, GetGameFont(), ActiveColor, NonactiveColor, CreateSurface(0,0, CreateColor(0,0,0,0)));
a.addText("7", function(){ a.done = true; }, GetGameFont(), ActiveColor, NonactiveColor, CreateSurface(0,0, CreateColor(0,0,0,0)));
a.addText("8", function(){ a.done = true; }, GetGameFont(), ActiveColor, NonactiveColor, CreateSurface(0,0, CreateColor(0,0,0,0)));


a.addDefaultKeys();
a.init_ring_menu(120, 120, 0);
a.preRender = function(){
  for (var i = 0; i < a.items.length; ++i)
  {
   // GetGameFont().drawText(16, 16 + 16 * i, a.items[i].x + " " + a.items[i].y);
  }
}

a.execute();

*/

/*


function MultiMenu()
{
  this.menuArray = new Array();
  this.current_menu = 0;
  this.done = false;
  this.escapeable = false;
}

MultiMenu.prototype.addMenu = function(menu)
{
  this.menuArray.push(menu);
}

MultiMenu.prototype.execute = function()
{
  while (!this.done && this.current_menu < this.menuArray.length)
  {
    this.menuArray[this.current_menu].execute()
    if (this.menuArray[this.current_menu].done)
      ++this.current_menu;
    else if (this.current_menu > 0)
      --this.current_menu;
      else if (this.escapeable)
        this.done = true;
  }
}

// var a = DefaultMenu(16, 16);
var b = DefaultMenu(32, 72);
var c = DefaultMenu(72, 16);

//a.addText("Next", function(){ a.done = true; });
//a.addText("Quit", function(){ a.done = true; k.done = true; });

b.addText("Next", function(){ b.done = true; });
b.addText("Quit", function(){ b.done = true; k.done = true; });

c.addText("Done", function(){ c.done = true; });
c.addText("Quit", function(){ c.done = true; k.done = true; });


var k = new MultiMenu();
k.addMenu(a);
k.addMenu(b);
k.addMenu(c);
k.execute();

*/
