RequireSystemScript('print.js');


// Load images
FLARE = LoadSurface('flara1.png'),
BG = LoadSurface('ringt.jpg');


MODES = {
	BLEND:BLEND,
	ADD:ADD,
	SUBTRACT:SUBTRACT,
	MULTIPLY:MULTIPLY,
	AVERAGE:AVERAGE,
	INVERT:INVERT
}

function game(){

	for(mode in MODES){
		var B = BG.clone();
		B.setBlendMode(MODES[mode]);
		// B.blitSurface(FLARE, -20, 0); B.blitSurface(FLARE,  20, 0);
		B.blitSurface(FLARE, 0, 0); 
		B.blit(0,0);

		print(0, 0, "MODE="+mode+". Press Key/click for next.", print.fx.OUTLINED);
		FlipScreen();
		while(!IsAnyKeyPressed()&&!IsMouseButtonPressed(MOUSE_LEFT)){}
		while(IsAnyKeyPressed()||IsMouseButtonPressed(MOUSE_LEFT)){}
	}
}


/*

blitting images to the backbuffer or drawing onto surfaces
  - BLEND:      DestColor = (DestColor * (255 - SrcAlpha) + SrcColor * SrcAlpha) / 255
  - ADD:        DestColor = DestColor + ((SrcColor * SrcAlpha) / 255)
  - SUBTRACT:   DestColor = DestColor - ((SrcColor * SrcAlpha) / 255)
  - MULTIPLY:   DestColor = DestColor * ((SrcColor * SrcAlpha) / 255) / 255
  - AVERAGE:    DestColor = DestColor + ((SrcColor * SrcAlpha) / 255) / 2
  - INVERT:     DestColor = DestColor * (255 - ((SrcColor * SrcAlpha) / 255)) / 255

masking
  - BLEND:      DestColor = (DestColor * (255 - MaskAlpha) + MaskColor * MaskAlpha) / 255
  - ADD:        DestColor = DestColor + MaskColor
  - SUBTRACT:   DestColor = DestColor - MaskColor
  - MULTIPLY:   DestColor = DestColor * MaskColor / 255
  - AVERAGE:    DestColor = (DestColor + MaskColor) / 2
  - INVERT:     DestColor = DestColor * (255 - MaskColor) / 255

drawing onto surfaces or masking
  - REPLACE:    DestColor = SrcColor
  - RGB_ONLY:   DestRGB   = SrcRGB
  - ALPHA_ONLY: DestAlpha = SrcAlpha


*/
