pi=4*Math.atan(1);

function RingMenu()
{
    this.items=new Array();
    
    // options
    this.nRadius=50;						// menu radius
    this.nPerspective=1.0;
    this.nRotationspeed=1;
    this.window=GetSystemWindowStyle();
    this.font=GetSystemFont();
    this.cursor=GetSystemArrow();
    
    // Internal state things
    this.nCursorpos=0;						// index of the item at which the cursor points to
    this.nAngle=0;							// the current orientation of the menu
    this.RenderFunc=function() {}			// this is run before the menu is drawn.  Assign it to render your map or something
}

function RingMenuItem(name, ic, func)
{
    this.sName = name;
    this.icon = ic;
    this.pFunction = func;
}

RingMenuItem.prototype.zoomBlit = function(x,y,scale)
{
    this.icon.zoomBlit(
        x - this.icon.width * scale / 2, 
        y - this.icon.height * scale / 2,
        scale);
}

RingMenu.prototype.AddItem=function(sName,icon,pFunction)
{
	blah=new RingMenuItem(sName,icon,pFunction);
	
	this.items.push(blah);
}

RingMenu.prototype.Render=function(cx,cy,theta)		// centre x/y, rotation angle
{
    with (this)
    {
        RenderFunc();
        
        theta+=90;
        var y = GetScreenHeight() - font.getHeight() - 20;
        window.drawWindow(10, y, GetScreenWidth() - 20, font.getHeight());		
        font.drawText(10, y, items[nCursorpos].sName);

        angle=360/items.length;	// angle difference between each item
        for (i=0; i<items.length; i++)
        {
            x=nRadius*Math.cos((theta + angle * i) * pi / 180);
            y=nRadius*Math.sin((theta + angle * i) * pi / 180);

            y/=nPerspective;

            nScale=((nPerspective-1)/3)*(y/nRadius*2)+1;
            
            items[i].zoomBlit(x+cx,y+cy,nScale);
        }
        
        cursor.blit(cx - cursor.width, cy + nRadius / nPerspective);
    }
}

RingMenu.prototype.MoveRight=function(x,y)
{
    with (this)
    {
        nEndangle=(nAngle-360/items.length)%360;
        nEndangle+=720;	// to get around that stupid wrap-around junk
        while (nAngle<nEndangle) nAngle+=360;	// x_x

        do
        {
            Render(x,y,nAngle);
            FlipScreen();

            nAngle-=nRotationspeed;
        } while (nAngle>nEndangle);
        nAngle=(nEndangle+720)%360;
        nCursorpos--;
        if (nCursorpos<0)
            nCursorpos=items.length-1;
    }
}

RingMenu.prototype.MoveLeft=function(x,y)
{
    with (this)
    {
        nEndangle=(nAngle+360/items.length)%360;
        nEndangle+=720;		nAngle+=720;
        while (nAngle>nEndangle) nAngle-=360;	// GAY
        
        do
        {
            Render(x,y,nAngle);
            FlipScreen();

            nAngle+=nRotationspeed;
        } while (nAngle<nEndangle);
        nAngle=(nEndangle+720)%360;
        nCursorpos++;
        if (nCursorpos>=items.length)
            nCursorpos=0;
    }
}

RingMenu.prototype.HandleInput=function(x,y)
{
    with (this)
    {
        if (!AreKeysLeft())
            return -1;
        
        c=GetKey();
        
        if (c==KEY_LEFT)
            MoveLeft(x,y);
        if (c==KEY_RIGHT)
            MoveRight(x,y);

        if (c==KEY_ESCAPE)
            return NaN
            
        if (c==KEY_ENTER)
            return nCursorpos;
        
        while (AreKeysLeft())
            GetKey();
            
        return -1;
    }
}

RingMenu.prototype.Execute=function(x,y)
{
	with (this)
	{
		nCursorpos=0;			  			// variable declaration
		//nItems=items.length;				// typing long variable names bugs me.
		nAngledif=360/items.length;			// So that... forget it, I don't want to explain this junk. :P
		
		bDone=false;
		
		a=0;
		while (!bDone)
		{
			nResult=HandleInput(x,y);
			if (nResult!=-1)
				return nResult;
			
			Render(x,y,nCursorpos*nAngledif);
			FlipScreen();
		}	
	}
}
