EvaluateScript("ringmenu.js")
EvaluateSystemScript("screen.js")

var games = GetGameList()
var particleImage = LoadImage("particle.png")
var earthImage = LoadImage("earth.jpg")
var xres = GetScreenWidth()
var yres = GetScreenHeight()

function MenuItem(game)
{
    this.game = game
}

function game()
{
    intro()
    mainMenu()
}

function intro()
{
    var titleImage = LoadImage("title.png")
    titleImage.blit(0,0)
    FadeIn(500)
    GetKey()
}

function crossFade(img, time)
{
    var scr = GrabImage(0, 0, xres, yres)
    var bias = 0
    var c = CreateColor(255, 255, 255, 255)
    
    var t = GetTime()/10
    while (bias < 1)
    {
        bias += (GetTime()/10 - t) / time
        if (bias > 1) bias = 1
        c.alpha = 255 - bias * 255

        scr.blit(0, 0)
        img.blitMask(0, 0, c)
        FlipScreen()
    }
}

function mainMenu()
{
    var menu = new RingMenu()
    menu.nRadius = xres
    menu.nRotationspeed = 0.75
    menu.RenderFunc = function()
    {
        earthImage.blit(0,0)
    }
    
    for (var i = 0; i < games.length; i++)
    {
        var g = games[i];
        menu.AddItem(g.name, particleImage, function(){})
    }
    
    var scr = GrabImage(0, 0, xres, yres)
    menu.Render(xres / 2, -yres, 0)
    crossFade(scr, 600)

    result = menu.Execute(xres / 2, -yres);
    if (result == result) // Not NaN
    {
        ExecuteGame(games[result].directory)
    }
}