RequireSystemScript("time.js");

var paddlePic = LoadImage("paddle.png");
var ballPic = LoadImage("ball.png");
var bg = LoadImage("bg.png");

var player = new Object();
player.x = 280;
player.y = 80;
player.score = 0;

var comp = new Object();
comp.x = 30;
comp.y = 140;
comp.score = 0;

var ball = new Object();
ball.angle = -45;
ball.x = 110;
ball.y = 140;
ball.velocity = 1;



function game(){
	SetFrameRate(60);
	bg.blit(0,0);
	GetSystemFont().drawText(120,100,"Ready...Set");
	FlipScreen();
	Delay(1000);
	bg.blit(0,0);
	GetSystemFont().drawText(120,100,"Go!!");
	FlipScreen();
	Delay(1000);
	while(true){
		bg.blit(0,0);
		paddlePic.blit(player.x,player.y);
		paddlePic.blit(comp.x,comp.y);
		ball.x += Math.cos(convertToRad(ball.angle)) * ball.velocity;
		ball.y += Math.sin(convertToRad(ball.angle)) * ball.velocity;
		ballPic.blit(ball.x,ball.y);
		collideCheck();
		checkForKeyPress();
		updateComputer();
		drawScore();
		FlipScreen();
		checkGoal();
	}
	SetFrameRate(0);
}


function convertToRad(degrees){
	return degrees * (Math.PI / 180);
}


function drawScore(){
	GetSystemFont().drawText(110,4,comp.score);
	GetSystemFont().drawText(200,4,player.score);
}

function collideCheck(){
	if (ball.y <= 18) ball.angle = -ball.angle;
	if (ball.y + ballPic.height >= 222) ball.angle = -ball.angle;
	if (ball.x <= comp.x + paddlePic.width && ball.y + 8 >= comp.y && ball.y <= comp.y + paddlePic.height) {
		ball.angle -= 95;
		ball.velocity += .2;
	}
	if (ball.x + ballPic.width >= player.x && ball.y + ballPic.height >= player.y && ball.y <= player.y + paddlePic.height) {
		ball.angle -= 95;
		ball.velocity += .2;
	}
}

function checkGoal(){
	if(ball.x <= 17) {
		bg.blit(0,0);
		player.score++;
		GetSystemFont().drawText(110,100,"GOAL!!");
		drawScore();
		FlipScreen();
		Delay(2000);
		resetBall();
	}
	if(ball.x + ballPic.width >= 301) {
		bg.blit(0,0);
		comp.score++;
		GetSystemFont().drawText(110,100,"GOAL!!");
		drawScore();
		FlipScreen();
		Delay(2000);
		resetBall();
	}
} 

function resetBall(){
	ball.x = 110;
	ball.y = 140;
	ball.velocity = 1;
	ball.angle = Math.random()*360;
}

function checkForKeyPress(){
	if(IsKeyPressed(KEY_UP) && player.y > 18) player.y-=2;
	if(IsKeyPressed(KEY_DOWN) && player.y < 222 - paddlePic.height) player.y+=2;
}

function updateComputer(){
	if(ball.x < GetScreenWidth()/2){
		if(ball.y < comp.y + paddlePic.height/2 && comp.y > 18) comp.y -= 3;
		if(ball.y > comp.y + paddlePic.height/2 && comp.y < 222 - paddlePic.height) comp.y += 3;
	}
}