const DIRECTION_EAST = 1;
const DIRECTION_WEST = 2;
const DIRECTION_TOP = 3;
const DIRECTION_BOTTOM = 4;
const MODE_IDLE = 1;
const MODE_WALKING = 2;
const MODE_JUMPING = 3;
const MODE_FALLING = 4;


const FALL_RATE = 0.4;
const JUMP_FORCE = 9.4;
const WALK_SPEED = 2;
RequireScript("kcl.js");
RequireSystemScript("screen.js") ;
RequireSystemScript("time.js") ;
RequireSystemScript("menu.js");
var currentdirection = DIRECTION_EAST;
var currentmode = MODE_IDLE;
var shellmode = false;
var shellmoving = false;
var vy = 0;
var shell_vx = 0;
var LastAtX = 123;
var LastAtY = 144;
var coins = 0;
var lives = 4;
var soundDie = LoadSound('Die.wav');
var soundCoin = LoadSound('25.WAV');
var soundHit = LoadSound('26.WAV');
var musicMain = LoadSound('mario.mod');
var spriteShell = LoadSpriteset("shell.rss")
var spriteKoopa = LoadSpriteset("koopa.rss")
var imageShell = LoadImage("shell.png");
var imageCoin = LoadImage("coin.png");
var imageMario = LoadImage("mario.png");
var font = GetSystemFont();
var black_font = GetSystemFont();
var mario = false;
var wario = false;
var peach = false;
var kinopio = false;
var luigi = false;
black_font.setColorMask(CreateColor(0,0,0,255));
function game()
{
  var TitleScreen = LoadImage("title.png");
  TitleScreen.blit(0,0);
  
  CreatePerson("koopa", "koopa.rss", false);
  
  AttachCamera("koopa");
  
 
 var MainMenu = new Menu();
 MainMenu.addItem("New", function () {SetRenderScript("DrawHUD();");
  MapEngine("backdrop.rmp", 60);});
 MainMenu.addItem("Exit", function () {});
 
 
 MainMenu.execute(200, 220, 50, 30);
  
  
  
}

var count =0;
var pressed = false;
function update() {
  
  //Compensate for imperfectness of calculations and for the "Suspended in solids" bug 
  //NOTE: This is a hack, but it works, and it isn't a major hit to performance. 
  if (IsPersonObstructed("koopa",GetPersonX("koopa"), GetPersonY("koopa")) && (currentmode == MODE_IDLE || currentmode == MODE_WALKING)) {
    if (count > 2) SetPersonY("koopa",GetPersonY("koopa")+5); else SetPersonY("koopa",GetPersonY("koopa")-1);
    count++;
    
  }
  else count = 0;



  

 
  //Determine player mode and direction based on input.  
   if (!(IsPersonObstructed("koopa", GetPersonX("koopa"), GetPersonY("koopa") + vy)) && (currentmode != MODE_JUMPING)) {
       currentmode = MODE_FALLING;
   if (vy == 0) vy = 1;
   }
  
  if (shellmode && !shellmoving) {
    if (IsKeyPressed(KEY_LEFT)) {
     if (shell_vx > -25) shell_vx -= 0.4;
    }
    else if (IsKeyPressed(KEY_RIGHT)) {
     if (shell_vx < 25) shell_vx += 0.4;
    }
    if (IsKeyPressed(KEY_SPACE)) {
     shellmoving = true;
    }
    if (!IsAnyKeyPressed()) {
     if (shell_vx > 0) { shell_vx -= 0.4;}
     if (shell_vx < 0) { shell_vx += 0.4;}
    }
  
  }
  
  if (shellmoving) {
  
  
    if (shell_vx > 0) { shell_vx -= 0.2;}
    if (shell_vx < 0) { shell_vx += 0.2;}
    if (Math.floor(shell_vx) == 0) { shellmoving = false; shell_vx = 0;}
  }
  
  if ((currentmode == MODE_JUMPING) && (vy > 0)) {
    
      currentmode = MODE_FALLING;
    
    
  }
  
  if ((IsPersonObstructed("koopa",GetPersonX("koopa"),GetPersonY("koopa") + vy)) && (currentmode == MODE_FALLING) ) {
   
   while (IsPersonObstructed("koopa",GetPersonX("koopa"),GetPersonY("koopa") + vy)) {
   vy -= 1;
   }
   if (vy < 1) { currentmode = MODE_IDLE; vy = 0;}
   
  }
  
  if (IsKeyPressed(KEY_DOWN)) {
   shellmode = true;
   shell_vx = 0; 
  }
  if (shellmode && IsKeyPressed(KEY_UP)) {
   shellmode = false;
   SetPersonSpriteset("koopa",spriteKoopa);
   currentmode = MODE_JUMPING;
    vy = -7;
    pressed = true;
  }
  if (pressed) {
    if (!IsKeyPressed(KEY_SPACE)) pressed = false;
  }

  if (!shellmode) {
  if ((currentmode != MODE_FALLING) && (currentmode != MODE_JUMPING) && IsKeyPressed(KEY_SPACE) && !pressed) {
    currentmode = MODE_JUMPING;
    vy = -JUMP_FORCE;
    pressed = true;
  }
  
  
 
  //if ((currentmode == MODE_JUMPING) && (IsPersonObstructed("koopa", GetPersonX("koopa"), GetPersonY("koopa") + vy)) ) {
  //  currentmode = MODE_FALLING;
  //  vy = 1;
 // }
  
  
  if ((currentmode == MODE_IDLE) && (IsKeyPressed(KEY_LEFT) || IsKeyPressed(KEY_RIGHT))) {
    currentmode = MODE_WALKING;
  }
  if (IsKeyPressed(KEY_LEFT)) {
    currentdirection = DIRECTION_WEST;
  }
  if (IsKeyPressed(KEY_RIGHT)) {
    currentdirection = DIRECTION_EAST;
  }
  }
  if ((!IsAnyKeyPressed()) && currentmode != MODE_FALLING && currentmode != MODE_JUMPING ) {
    currentmode = MODE_IDLE;
  }
 
 
  //assign animations to modes and directions.
  if (!shellmode) {
  if (currentmode == MODE_IDLE) {
    if (currentdirection == DIRECTION_EAST) {
      SetPersonDirection("koopa","east");
    }
    else
    {
      SetPersonDirection("koopa","west");
    }
  }
  
  if (currentmode == MODE_JUMPING) {
    if (currentdirection == DIRECTION_EAST) {
      SetPersonDirection("koopa","jump_east");
    }
    else
    {
      SetPersonDirection("koopa","jump_west");
    }
  }
  if (currentmode == MODE_FALLING) {
    if (currentdirection == DIRECTION_EAST) {
      SetPersonDirection("koopa","fall_east");
    }
    else
    {
      SetPersonDirection("koopa","fall_west");
    }
  }
  if (currentmode == MODE_WALKING) {
    if (IsKeyPressed(KEY_CTRL)) {
     
      if (currentdirection == DIRECTION_EAST) {
        SetPersonDirection("koopa","run_east");
      }
      else
      {
        SetPersonDirection("koopa","run_west");
      }    
    }
    else {
    
      if (currentdirection == DIRECTION_EAST) {
        SetPersonDirection("koopa","walk_east");
      }
      else
      {
        SetPersonDirection("koopa","walk_west");
      }
    }
    
    
  }
  }
  else {
    SetPersonSpriteset("koopa",spriteShell);
    if (shell_vx < 0) {
      SetPersonDirection("koopa","west_moving");
      }
    else {
      SetPersonDirection("koopa","east_moving");
    }
  }
  
  
  if (!shellmode || (shellmode && shellmoving)) QueuePersonCommand("koopa", COMMAND_ANIMATE, true);
  
  //Do the physics
    if (!shellmode) {
    if (IsKeyPressed(KEY_CTRL) && (currentmode == MODE_WALKING || currentmode == MODE_FALLING || currentmode == MODE_JUMPING) ) {
      if (currentdirection == DIRECTION_WEST && IsKeyPressed(KEY_LEFT) && (!IsPersonObstructed("koopa", GetPersonX("koopa") - WALK_SPEED * 1.5, GetPersonY("koopa")))) {
        SetPersonX("koopa",GetPersonX("koopa") - WALK_SPEED * 1.5);
      }
      else if (currentdirection == DIRECTION_EAST && IsKeyPressed(KEY_RIGHT) && (!IsPersonObstructed("koopa", GetPersonX("koopa") + WALK_SPEED * 1.5, GetPersonY("koopa")))) {
        SetPersonX("koopa",GetPersonX("koopa") + WALK_SPEED * 1.5);
      }
    }
    else {
      if (currentdirection == DIRECTION_WEST && IsKeyPressed(KEY_LEFT) && (!IsPersonObstructed("koopa", GetPersonX("koopa") - WALK_SPEED , GetPersonY("koopa")))) {
        SetPersonX("koopa",GetPersonX("koopa") - WALK_SPEED );
      }
      else if (currentdirection == DIRECTION_EAST && IsKeyPressed(KEY_RIGHT) && (!IsPersonObstructed("koopa", GetPersonX("koopa") + WALK_SPEED , GetPersonY("koopa")))) {
        SetPersonX("koopa",GetPersonX("koopa") + WALK_SPEED );
      }
    }
    }
    if (shellmode && shellmoving) {
       
       
       if (IsPersonObstructed("koopa",GetPersonX("koopa") + shell_vx, GetPersonY("koopa")) ) {
         var item = GetObstructingPerson("koopa",GetPersonX("koopa") + shell_vx, GetPersonY("koopa"));
         if (item.split("_")[1] == "shellbounce" || item == "") {
           if (!IsPersonObstructed("koopa",GetPersonX("koopa"),GetPersonY("koopa"))) shell_vx = -shell_vx;
         }
         
       }
       else if (IsPersonObstructed("koopa",GetPersonX("koopa") + shell_vx / 3, GetPersonY("koopa")) ) {
         var item = GetObstructingPerson("koopa",GetPersonX("koopa") + shell_vx / 3, GetPersonY("koopa"));
         if (item.split("_")[1] == "shellbounce" || item == "") {
           if (!IsPersonObstructed("koopa",GetPersonX("koopa"),GetPersonY("koopa"))) shell_vx = -shell_vx;
         }
         
       }
       SetPersonX("koopa",GetPersonX("koopa") + shell_vx );
    }
    
    if (currentmode == MODE_FALLING || currentmode == MODE_JUMPING) {
      vy += FALL_RATE;
      SetPersonY("koopa",GetPersonY("koopa") + vy);
    }
    
    if (GetPersonY("koopa") > GetLayerHeight(2) * GetTileHeight()) {
      PlayerDie();
    }
    var list = GetPersonList();
    for (var i =0; i < list.length; i++) {
      if (GetPersonY(list[i]) > GetLayerHeight(2) * GetTileHeight()) {
        DestroyPerson(list[i]);
      }
    }
}

function GetObstructors() {
var theperson = "";
    theperson = GetObstructingPerson("koopa",GetPersonX("koopa"), GetPersonY("koopa"));
  
  if ((currentmode == MODE_FALLING || MODE_JUMPING) && theperson == "") {
    theperson = GetObstructingPerson("koopa",GetPersonX("koopa"), GetPersonY("koopa") + vy);
  }
  if (currentmode == MODE_WALKING && IsKeyPressed(KEY_CTRL) && theperson == "") {
    if (currentdirection == DIRECTION_WEST) {
    
      theperson = GetObstructingPerson("koopa",GetPersonX("koopa") - WALK_SPEED * 1.5, GetPersonY("koopa"));
    }
    else {
      theperson = GetObstructingPerson("koopa",GetPersonX("koopa") + WALK_SPEED * 1.5, GetPersonY("koopa"));
    }
  }
  if (currentmode != MODE_IDLE && theperson == "") {
    if (currentdirection == DIRECTION_WEST) {
    
      theperson = GetObstructingPerson("koopa",GetPersonX("koopa") - WALK_SPEED, GetPersonY("koopa"));
    }
    else {
      theperson = GetObstructingPerson("koopa",GetPersonX("koopa") + WALK_SPEED, GetPersonY("koopa"));
    }
  
  }
  return theperson;
}

function PlayerDie() {
  musicMain.stop();
  soundDie.play(false);
  FadeOut(1000);
  SetPersonX("koopa",LastAtX);
  SetPersonY("koopa",LastAtY);
  SetCameraX(LastAtX);
  SetCameraY(LastAtY);
  Delay(2000);
  shellmode = false;
  SetPersonSpriteset("koopa",spriteKoopa);

  currentdirection = DIRECTION_EAST;
  currentmode = MODE_FALLING;
  vy = 1;
  RenderMap();
  FadeIn(1000);
  musicMain.play(true);
}

function IsCollisionDownward(person) {
  if (person == "") return false;
      
  if ((GetPersonY("koopa") + GetPersonBase("koopa").y2 - 10<= GetPersonY(person) ))  {
     return true;
  } 
  else {
     return false
  }
  
   
}

function IsCollisionUpward(person) {
  if (person == "") return false;
      
  if ((GetPersonY("koopa") >= GetPersonY(person) + GetPersonBase(person).x2 - 10  ))  {
     return true;
  } 
  else {
     return false
  }
  
   
}

function BouncePlayer() {
  if (vy > 0) {
      vy = -vy / 2;
      if (vy > -6 ) vy = -6;
      currentmode = MODE_JUMPING;
  }
  else {
      vy = 1;
      currentmode = MODE_FALLING;
  }
}

function KillPerson(theperson) {
   SetPersonLayer(theperson,4) 
    
   SetPersonScript(theperson, SCRIPT_COMMAND_GENERATOR, "QueuePersonScript(\"" + theperson + "\",\"SetPersonY('" + theperson + "', GetPersonY('" + theperson + "') + 6);\",true);" );   

}


function KillPersonUp(theperson) {
   SetPersonLayer(theperson,4) 
   var originalY = GetPersonY(theperson); 
   SetPersonScript(theperson, SCRIPT_COMMAND_GENERATOR, "QueuePersonScript(\"" + theperson + "\",\"SetPersonY('" + theperson + "', GetPersonY('" + theperson + "') - 4);if (GetPersonY('" + theperson + "') < " + (originalY - 60) + ") DestroyPerson('" + theperson + "');\",true);" );   

}
function KillPersonFade(theperson) {
   SetPersonLayer(theperson,2) 
   SetPersonScript(theperson, SCRIPT_COMMAND_GENERATOR, "QueuePersonScript(\"" + theperson + "\",\"SetPersonMask('" + theperson + "', CreateColor(255,255,255,GetPersonMask('" + theperson + "').alpha - 4));if (GetPersonMask('" + theperson + "').alpha <= 0) DestroyPerson('" + theperson + "');\",true);" );   

}
function DrawHUD() {
  imageShell.blit(5,5);
  imageCoin.blit(105,7);
  if (mario) imageMario.blit(460,2);
  black_font.drawZoomedText(122,6,1.1,coins);
  black_font.drawZoomedText(124,6,1.1,coins);
  black_font.drawZoomedText(124,5,1.1,coins);
  black_font.drawZoomedText(124,7,1.1,coins);
  black_font.drawZoomedText(122,5,1.1,coins);
  black_font.drawZoomedText(122,7,1.1, coins);
  font.drawZoomedText(123,6,1.1,coins);
  
  black_font.drawZoomedText(22,7,1.1, lives);
  black_font.drawZoomedText(22,5,1.1, lives);
  
  black_font.drawZoomedText(24,7,1.1, lives);
  black_font.drawZoomedText(24,5,1.1, lives);
  
  black_font.drawZoomedText(22,6,1.1, lives);
  black_font.drawZoomedText(24,6,1.1, lives);
  font.drawZoomedText(23,6,1.1,lives);
  
  var screen_x = MapToScreenX(3,GetPersonX("koopa")) - 75;
  var screen_y = MapToScreenY(3,GetPersonY("koopa")) - 50;
  
  
  if (shellmode && !shellmoving && Math.abs(Math.floor(shell_vx)) >= 1) {
  Line(screen_x,screen_y,screen_x + 150,screen_y,CreateColor(0,0,0,255));
  Line(screen_x,screen_y,screen_x,screen_y + 20,CreateColor(0,0,0,255));
  Line(screen_x,screen_y + 20,screen_x + 150,screen_y +20,CreateColor(0,0,0,255));
  Line(screen_x + 150,screen_y,screen_x + 150,screen_y + 20,CreateColor(0,0,0,255));
  Rectangle(screen_x,screen_y,150,20,CreateColor(0,0,0,128));
  if (shell_vx < 0) {
  Rectangle(screen_x + 75 - Math.abs(shell_vx) * 3 +3,screen_y+2,Math.abs(shell_vx) * 3 -2,17,CreateColor(255,255 - Math.abs(shell_vx * 10),255 - Math.abs(shell_vx * 10),Math.abs(shell_vx * 10)));
  } else
  Rectangle(screen_x + 75,screen_y+2,Math.abs(shell_vx) * 3 -2,17,CreateColor(255,255-Math.abs(shell_vx * 10),255-Math.abs(shell_vx * 10),Math.abs(shell_vx * 10)));
  
  }
  
  
}










function firstmap() {
  var theperson = GetObstructors();
  var persontype = theperson.split("_")[0];
  var vertical = IsCollisionDownward(theperson);  
  var upward = IsCollisionUpward(theperson); 
  if (persontype == "flyguy" || persontype == "walkguy") {

    if ((vertical && currentmode == MODE_FALLING) || shellmode) {
      KillPerson(theperson);
      if (!shellmode) BouncePlayer();
      soundHit.play(false);
    }
    else {
      PlayerDie();
    }
  }
  if (persontype == "coin") {
    KillPersonUp(theperson);
    coins +=1;
    if (soundCoin.isPlaying()) soundCoin.stop();
    soundCoin.play(false);
  }
  if (persontype == "redcoin") {
    KillPersonUp(theperson);
    coins +=5;
    if (soundCoin.isPlaying()) soundCoin.stop();
    soundCoin.play(false);
  }
  if (persontype == "Mario") {
    KillPersonFade(theperson);
    mario = true;
  }
  if (persontype == "query") {
    if ((upward) && currentmode == MODE_JUMPING) { BouncePlayer(); CallPersonScript(theperson,SCRIPT_ON_ACTIVATE_TOUCH); }
  
  }
  
}

