/*
* KAMATSU'S CLASS LIBRARY
* Version 0.43
*  
* Created by Kamatsu
* 
* Released under the MIT license.
* 
* Copyright (C) 2007 Liam O'Connor-Davis e.a. Only a couple of rights reserved.
* Feel free to use/modify this for your projects, provided this copyright notice
* remains intact.
*
* Also, no warranty. Either expressed or implied, including the implied warranties
* of merchantability or fitness for a particular purpose. 
*
* Enjoy.
*
*/

/*

kclDeclares.js: Constants, game objects, other stuff in the global scope.

*/

try {
    LibraryRegistry.abortIfNotInstalled("Spheritype",1.1,false);
}
catch (ex) {
    Abort("Spheritype Not Installed!");
}

LibraryRegistry.addLibraryData("Kamatsu's Class Library: Declares",0.43);


//CONSTANTS
const WINDOWSTYLE_NONE = 1
const WINDOWSTYLE_DEFAULT = 2
const ALIGNMENT_TOPLEFT = 1
const ALIGNMENT_TOPRIGHT = 2
const ALIGNMENT_TOPCENTER = 3
const ALIGNMENT_BOTTOMLEFT = 4
const ALIGNMENT_BOTTOMRIGHT = 5
const ALIGNMENT_BOTTOMCENTER = 6
const ALIGNMENT_MIDDLELEFT = 7
const ALIGNMENT_MIDDLERIGHT = 8
const ALIGNMENT_MIDDLECENTER = 9
const TEXTANIM_CHARBYCHAR = 1
const TEXTANIM_SLIDE = 2
const TEXTANIM_FADE = 3
const TEXTANIM_NONE = 4
const WINDOWANIM_NONE = 1
const WINDOWANIM_FADE = 2
const WINDOWANIM_GROW = 3
const BACKGROUND_NONE = 1
const BACKGROUND_RENDERMAP = 2
const IMAGE_ARROW = 1
const IMAGE_ARROW_UP = 2
const IMAGE_ARROW_DOWN = 3
const IMAGE_FROM_BUFFER = 4
const IMAGE_NONE = 5


/* OBJECT: Game (single instance)

   Simply stores global settings in a Game Class.
   
 */
var Game = Class.extend({
 constructor: null,//makes this a single instance
 
 windowStyle: GetSystemWindowStyle(), //Game.windowStyle is used instead of GetSystemWindowStyle in this library to enable users to change the "default" window style this way.
 font: GetSystemFont(), //Game.font is used instead of GetSystemfont in this library to enable users to change the "default" font this way.
 systemArrow: GetSystemArrow(),
 systemArrowUp: GetSystemUpArrow(),
 systemArrowDown: GetSystemDownArrow(),
 keyConfirm: KEY_ENTER
});