/*
* KAMATSU'S CLASS LIBRARY
* Version 0.43
*  
* Created by Kamatsu
* 
* Released under the MIT license.
* 
* Copyright (C) 2007 Liam O'Connor-Davis e.a. Only a couple of rights reserved.
* Feel free to use/modify this for your projects, provided this copyright notice
* remains intact.
*
* Also, no warranty. Either expressed or implied, including the implied warranties
* of merchantability or fitness for a particular purpose. 
*
* Enjoy.
*
*/


/* Some Contributions by:

   * Tunginobi (String Prototype Wrapping Extensions)

*/



/*
Changelog:

0.32  - Initial Release
0.321 - Changed order of arguments
      - Renamed TextWindow class
      - Added universal Game object.
0.33  - Added font object, fixed up some references. 
      - Added NeoLogix wrapping to String prototype.
0.34  - Added animations to window superclass. 
      - Restructured window superclass to include a more discrete drawing.
0.36  - Added text animations. No character-by-character animation yet. 
      - Moved font object into the TextWindow class. 
      - Fixed callback bug. 
      - Fixed out of date comments. 
      - Added a bunch of new useful properties to the textwindow class.
0.361 - Added Initialize/Text methods to stop problems with repeated showing/hiding. Now can be used for sequential display of text.
      - Fixed some other miscellaneous bugs. 
0.37  - Removed all NeoLogiX contributions. 
      - Added tunginobi's wrapping module as a prototype extension to String and Array. 
      - Some minor modifications to drawing
      - Addition of textVisible property
      - Addition of a character by character text intro animation. 
      - Creation of Tech Demo.
0.38  - Rewrote background drawing for windows. 
      - Added Surface, Color, Image, ColorMatrix objects and integrated them with the system.
      - No more RenderMap arguments. Now specified in Background property.  
0.39  - Modified ToLongString prototype extension to a generic "stitch" function that conjoins array elements into a string with a seperator.
      - Added MessageWindow class with automatic pagination. Also added a nameWindow system and an Arrow.
      - Added a "Confirm" key to the Game Object
      - Made confirm key skip charbychar animation.
0.4   - Replaced strings with constants for flag arguments.
      - Added alignment property to NameWindow
      - Added ImageWindow object (for images and surfaces), for screen entities.
      - Switched from ugly CEA to my new Spheritype Library, allowing for cleaner superclass calls.
      - Broke the library into several files
      - Fixed up some defaults to make all windows except MessageWindows backbuffer only by default (so you have to FlipScreen them unless you change their properties).
      - Using the new spheritype library, made the Game object self instantiating - no p_game prototype
      - General code cleanups and improvements thanks to Spheritype.
      - Made the nameWindow always float ABOVE the window it superimposes.
      - Reordered Window arguments.
      - Fixed Wrapping bug
      - Added disablable wrapping in TextWindow.
0.41  - Broke padding property into seperate top, left, right, bottom properties for both imagewindow and textwindow.
      - ImageWindow now implements proper polymorphism.
      - Portraits and portraitalignment property support added.
      - Addition of an InitializeWindows property to configure subwindow positions for Messagewindow to avoid reinvention and aid expansion.
      - Bugfixes and cleanups
      - Newline fix in tunginobi's wrapping module using regexp.
0.42  - Added Library Registry to Spheritype
      - Added surface object returnings rather than null
      - Added windowstyle wrapper object.
      - Configured the KCL with Library Registry.
0.43  - Added ScreenElement classes, including a polar-coordinated object.
      - Fixed up window FlipScreening to make more sense using a property rather than arguments
      - Also removed anims as arguments to show and hide functions as this shortcut makes the library unclear and soils it.
      - Made window "Visible" property ACTUALLY hide the window TOTALLY by blocking the Redraw function.
      - Commented and clarified techdemo. Added polar coordinates demo.
*/

EvaluateScript("kclSpheritype.js");

try {
    //This script requires the Spheritype Library - There is virtually no way to get around this so live with it.

    LibraryRegistry.abortIfNotInstalled("Spheritype",1.1,false);
}
catch (ex) {
    Abort("Spheritype Not Installed or Incorrect Spheritype Version!");
}

LibraryRegistry.addLibraryData("Kamatsu's Class Library",0.43);


//Constants, Game Object, any other global declares.
EvaluateScript("kclDeclares.js");

//Wrapper Classes for Sphere Objects
EvaluateScript("kclWrapperClasses.js");

//Extensions to JS Prototypes such as Array and String
EvaluateScript("kclPrototypeExtensions.js");

//Window Classes
EvaluateScript("kclWindowClasses.js");

//Screen Elements
EvaluateScript("kclScreenElements.js");


