// zoom.js
// zoom in/out functions for battle simulation (Sphere)

/*  Copyright (C) 2008-2009  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

RequireScript("entities/entity.js");
// also uses ResolutionCm, PauseFlag, MapReadyFlag, CreatePeopleFlag, and MapName

function ZoomIn() {
  if (ResolutionCm == 4) {
    Zoom(2);
  } else if (ResolutionCm == 2) {
    Zoom(1.5);
  }
}

function ZoomOut() {
  if (ResolutionCm == 1.5) {
    Zoom(2);
  } else if (ResolutionCm == 2) {
    Zoom(4);
  }
}

function Zoom(resolution_cm) {
  //DebugCall("Zoom", [resolution_cm]);

  // get starting eye x,y and zoom factor
  CenterMap();
  var es_cm = LocusEsCm(EyeLocus);
  var eye_x = CmToMapX(es_cm[0]);
  var eye_y = CmToMapY(es_cm[1]);
  var start_x = MapToScreenX(Layer, eye_x);
  var start_y = MapToScreenY(Layer, eye_y);
  var end_factor = ResolutionCm/resolution_cm;

  // grab map image 
  Screen.fill(MapWindowFillColor);
  RenderMap();
  var map_image = Screen.grab();
  
  Message.draw("Zooming...");
  FlipScreen();

  // change resolution and load new map
  ResolutionCm = resolution_cm;
  var map_file = Quote(ResolutionCm) + "cm/" + Map + ".rmp";
  MapReadyFlag = false;
  CreateEntitiesFlag = false;
  ChangeMap(map_file);
  // at this point, EnterMap() gets called again

  // get ending x,y for eye
  CenterMap();
  es_cm = LocusEsCm(EyeLocus);
  eye_x = CmToMapX(es_cm[0]);
  eye_y = CmToMapY(es_cm[1]);
  var end_x = MapToScreenX(Layer, eye_x);
  var end_y = MapToScreenY(Layer, eye_y);

  for (var progress = 0.1; progress < 1; progress += 0.1) {
    var factor = progress*end_factor + 1 - progress;
    var x = (end_x - start_x*end_factor)*progress;
    var y = (end_y - start_y*end_factor)*progress;
    map_image.zoomBlit(x, y, factor);
    Message.draw("Zooming...");
    FlipScreen();
  }
    
  RenderMap();
}