// random.js
// random number utilities for Sphere

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
RequireScript("utilities/debug.js");

function Randomize() {
  //DebugCall("Randomize");
  
  var tick = GetTime();
  var numIters = tick % 255;
  for (var i = 0; i < numIters; i++) {
    Math.random();
  } 
  //DebugLog.write("numIters=" + Quote(numIters));
}

// generate a random floating-point number from a uniform distribution
function Uniform(low, high) {
  //DebugCall("Uniform", [low, high]);
  
  if (low > high) {
    var t = low; 
    low = high; 
    high = t;
  }
  var range = high - low;
  
  var r = Math.random();
  var offset = r * range;
  var pick = low + offset;
  
  return pick;
}

// generate a random floating-point number from a triangular distribution
function Triangular(low, high) {
  //DebugCall("Triangular", [low, high]);
  
  if (low > high) {
    var t = low; 
    low = high; 
    high = t;
  }
  var range = high - low;
  
  var r = 0.5*(Math.random() + Math.random());
  var offset = r * range;
  var pick = low + offset;
  
  return pick;
}

// generate a random letter uniformly distributed from 'a' to 'z'
function RandomLetter() {
  //DebugCall("RandomLetter");

  var ascii = "a".charCodeAt(0) + Math.floor(Uniform(0, 26));
  var letter = CreateStringFromCode(ascii);
  
  return letter;
}

// generate a random sign: -1 or +1
function RandomSign() {
  //DebugCall("RandomSign");

  var r = Uniform(-1, 1);

  var sign;
  if (r > 0) {
    sign = 1;
  } else {
    sign = -1;
  }
  
  return sign;
}

// pick a random value from a list
function ListPick(list) {
  //DebugCall("ListPick");

  var len = list.length;
  var i = Math.floor(Uniform(0, list.length));
  return list[i];
}

// A mix is a string containing values and
// percentages, such as:
//   "mix 30%archer 70%sands"

MixSeparator = " ";

function IsMix(mix_string) {
  //DebugCall("IsMix", [mix_string]);
  
  var words = mix_string.split(MixSeparator);
  var result = (words[0] == "mix");
  
  return result;
}

// pick a random value from a mix
function RandomMix(mix_string) {
  //DebugCall("RandomMix", [mix_string]);
  
  var percentile = Uniform(0, 100);
  
  var result;
  var pairs = mix_string.split(MixSeparator);
  pairs.shift();
  for (var i in pairs) {
    var pair = pairs[i];
    var words = pair.split("%");
    var percentage = Number(words[0]);
    //DebugLog.write(" percentile=" + Quote(percentile) + " percentage=" + Quote(percentage));    
    if (percentage > percentile) {
      result = words[1];
      //DebugLog.write(" set result=" + Quote(result));
      break;
    }
    percentile -= percentage;
  }
  
  return result;
}