// math.js
// math utilities for Sphere

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
RequireScript("utilities/debug.js");


// cosine of the angle between two 2-d vectors
function CosBetween(x1, y1, x2, y2) {
  //DebugCall("CosBetween", [x1, y1, x2, y2]);
  
  var dot = Dot(x1, y1, x2, y2);
  var n1 = Norm(x1, y1);
  var n2 = Norm(x2, y2);
  
  if (n1 == 0 || n2 == 0) {
    Abort("Error in CosBetween()");
  }
  var cos = dot/(n1 * n2);
  
  return cos;
}

// sine of the angle between two 2-d vectors (for left-handed coordinates)
function SinBetween(x1, y1, x2, y2) {
  //DebugCall("SinBetween", [x1, y1, x2, y2]);
  
  var cross = x1 * y2 - y1 * x2;
  var n1 = Norm(x1, y1);
  var n2 = Norm(x2, y2);
  if (n1 == 0 || n2 == 0) {
    Abort("Error in SinBetween()");
  }
  var sin = cross/(n1 * n2);
  
  return sin;
}

// dot product of two 2-d vectors
function Dot(x1, y1, x2, y2) {
  //DebugCall("Dot", [x1, y1, x2, y2]);
  var dot = x1 * x2 + y1 * y2;

  return dot;
}

// length of a 2-d vector
function Norm(x, y) {
  //DebugCall("Norm", [x, y]);
  var norm2 = Norm2(x, y);
  var norm = Math.sqrt(norm2);

  return norm;
}
function NormV(v) {
  //DebugCall("NormV", v);
  var norm2 = Norm2V(v);
  var norm = Math.sqrt(norm2);

  return norm;
}

// squared length of a 2-d vector
function Norm2(x, y) {
  //DebugCall("Norm2", [x, y]);
  var norm2 = x*x + y*y;

  return norm2;
}
function Norm2V(v) {
  //DebugCall("Norm2V", v);
  var norm2 = v[0]*v[0] + v[1]*v[1];

  return norm2;
}

// sign of a number
function GetSign(x) {
  //DebugCall("GetSign", [x]);
  var sign;
  
  if (x < 0) {
    // negative
    sign = -1;
  } else {
    // positive or zero
    sign = 1
  }
  
  return sign;
}

// trig functions for angles in degrees
function CosineDegrees(degrees) {
  //DebugCall("CosineDegrees", [degrees]);

  var radians = degrees*Math.PI/180;
  var result = Math.cos(radians);

  return result;
} 

function SineDegrees(degrees) {
  //DebugCall("SineDegrees", [degrees]);

  var radians = degrees*Math.PI/180;
  var result = Math.sin(radians);

  return result;
} 
