// list.js
// list utilities for Sphere

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
    
// A "list" is an Array whose indices run {0 .. length-1}.

RequireScript("utilities/debug.js");

// Create a copy of the given list with all instances 
//  of the given value removed.
// Abort if the value doesn't appear at least once.

function Remove(value, list) {
  //DebugCall("Remove", [value, list]);
  
  var found = false;
  var new_list = [];

  for (var i in list) {
    if (list[i] == value) {
      found = true;
    } else {
      new_list.push(list[i]);
    }
  }

  if (!found) {
    Abort(Quote(value) + " not found in list");
  }
  return new_list;
}

// Create a copy of the given list with any instances 
//  of the given value removed.

function RemoveIfPresent(value, list) {
  //DebugCall("RemoveIfPresent", [value, list]);
  
  var new_list = [];

  for (var i in list) {
    if (list[i] != value) {
      new_list.push(list[i]);
    }
  }

  return new_list;
}

// search for exact match in list

function ExistsIn(value, list) {
  //DebugCall("ExistsIn", [value, list]);
  
  for (var i in list) {
    if (list[i] == value) {
      return true;
    }
  }

  return false;
}

// convert all elements to lower-case

function ToLowerCase(list) {
  //DebugCall("ToLowerCase", [list]);
  
  var result = [];
  for (var i in list) {
    var str = list[i].toLowerCase();
    result.push(str);
  }

  return result;
}

// list integers in a range

function ListIntegers(first, last) {
  //DebugCall("ListIntegers", [first, last]);

  if (typeof(first) != "number") {
    Abort("invalid first: " + Quote(first));
  }
  if (typeof(last) != "number") {
    Abort("invalid last: " + Quote(last));
  }
  if (first > last) {
    var t = first;
    first = last;
    last = t;
  }
  
  var result = [];
  
  for (var i = first; i <= last; i++) {
    result.push(i);
  }
  
  return result;
}