// draw_boxes.js
// debug rendering of people in Sphere
//   -- draw frame edges of all people

/*  Copyright (C) 2008  Stephen R. Gold

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.*/

// DrawBoxes() draws the bounding box of every person on the map
// call DrawBoxes() every frame via SetRenderScript()

// settings, with defaults
//   note: choose colors that will contrast with the map!

RequireScript("ui/screen_rect.js");
// also uses Layer

// flag parameter to enable this feature

var BoxesFlag = PlayerFlag("Boxes", false);

// colors

var BoxesOutlineColor = CreateColor(0, 0, 0, 200);  // black

function DrawBoxes() {
  if (!BoxesFlag) {
    return;
  }
  //DebugCall("DrawBoxes");
  
  // save clipping rectangle
  var old_clip = ScreenRect();
  
  MapWindow.clip();

  var person_names = GetPersonList();
  for (var i in person_names) {
    var name = person_names[i];
    DrawPersonBox(name);
  }
  
  // restore old clipping rectangle
  old_clip.clip();
}

function DrawPersonBox(name) {
  //DebugCall("DrawPersonBox", [name]);

  var x = MapToScreenX(Layer, GetPersonX(name));
  var y = MapToScreenY(Layer, GetPersonY(name));
  
  // find upper left corner of frame image
  var b = GetPersonBase(name);
  x -= (b.x2 + b.x1)/2;
  y -= (b.y2 + b.y1)/2;

  var width = Number(GetPersonValue(name, "width"));
  var height = Number(GetPersonValue(name, "height"));
  OutlinedRectangle(x, y, width, height, BoxesOutlineColor);
}